/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.util;

import java.awt.Component;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import javax.swing.JOptionPane;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.MultiPartEmail;
import org.chorem.lima.LimaMain;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;
import org.jdesktop.swingx.error.ErrorReporter;
import org.nuiton.i18n.I18n;

public class ErrorHelper
implements ErrorReporter {
    private static final Log log = LogFactory.getLog(ErrorHelper.class);

    public static void showErrorDialog(Component parent, String message, Throwable cause) {
        JXErrorPane pane = new JXErrorPane();
        ErrorInfo info = new ErrorInfo(I18n._((String)"lima.common.error"), I18n._((String)"lima.error.errorpane.htmlmessage", (Object[])new Object[]{message}), null, null, cause, null, null);
        pane.setErrorInfo(info);
        pane.setErrorReporter((ErrorReporter)new ErrorHelper());
        JXErrorPane.showDialog((Component)parent, (JXErrorPane)pane);
    }

    public static void showErrorDialog(String message) {
        ErrorHelper.showErrorDialog(message, null);
    }

    public static void showErrorDialog(String message, Throwable cause) {
        ErrorHelper.showErrorDialog(null, message, cause);
    }

    public void reportError(ErrorInfo errorInfo) throws NullPointerException {
        block3: {
            try {
                String emailTo = LimaMain.config.getSupportEmail();
                MultiPartEmail email = new MultiPartEmail();
                email.setHostName("smtp");
                email.addTo(emailTo, "Support");
                email.setFrom("no-reply@nuiton.org", "Lima");
                email.setSubject("Project error notification : Lima");
                StringBuffer message = new StringBuffer();
                message.append(this.formatMessage("Project", "Lima " + LimaMain.config.getVersion()));
                message.append(this.formatMessage("Date", new Date().toString()));
                message.append(this.formatMessage("Title", errorInfo.getTitle()));
                message.append(this.formatMessage("Description", errorInfo.getBasicErrorMessage().replaceAll("<[^>]+>", "")));
                message.append(this.formatMessage("Configuration", null));
                ArrayList<String> propertiesNames = new ArrayList<String>(LimaMain.config.getOptions().stringPropertyNames());
                Collections.sort(propertiesNames);
                for (String propertyName : propertiesNames) {
                    if (propertyName.contains("pass")) continue;
                    message.append("\t" + propertyName + " : " + LimaMain.config.getOptions().getProperty(propertyName) + "\n");
                }
                StringWriter out = new StringWriter();
                PrintWriter writer = new PrintWriter(out);
                errorInfo.getErrorException().printStackTrace(writer);
                message.append(this.formatMessage("Exception", out.toString()));
                email.setContent((Object)message.toString(), "text/plain; charset=ISO-8859-9");
                email.send();
                JOptionPane.showMessageDialog(null, "A report message has been sent to " + emailTo);
            }
            catch (EmailException ex) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)"Can't send report email", (Throwable)ex);
            }
        }
    }

    protected String formatMessage(String category, String content) {
        String formatted = category + " :\n";
        if (StringUtils.isNotEmpty((String)content)) {
            formatted = formatted + "\t" + content + "\n";
        }
        return formatted;
    }
}

