/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.ledger;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.entity.FinancialPeriod;
import org.chorem.lima.entity.FiscalPeriod;
import org.chorem.lima.enums.ComboBoxDatesEnum;
import org.chorem.lima.ui.combobox.FinancialPeriodComboBoxModel;
import org.chorem.lima.ui.combobox.FinancialPeriodComboBoxRenderer;
import org.chorem.lima.ui.combobox.FiscalPeriodComboBoxModel;
import org.chorem.lima.ui.combobox.FiscalPeriodComboBoxRenderer;
import org.chorem.lima.ui.ledger.LedgerViewHandler;
import org.jdesktop.swingx.JXDatePicker;
import org.nuiton.i18n.I18n;

public class LedgerPeriodSearchPanel
extends JPanel {
    private static final Log log = LogFactory.getLog(LedgerPeriodSearchPanel.class);
    protected LedgerViewHandler handler;
    static final long serialVersionUID = 1L;

    public LedgerPeriodSearchPanel(LedgerViewHandler handler) {
        this.handler = handler;
        this.refresh(ComboBoxDatesEnum.FISCAL_PERIOD);
    }

    public void refresh(ComboBoxDatesEnum comboBoxPeriodEnum) {
        switch (comboBoxPeriodEnum) {
            case PERIOD: {
                Calendar calendarBegin = Calendar.getInstance();
                Date beginDate = calendarBegin.getTime();
                beginDate = DateUtils.truncate((Date)beginDate, (int)1);
                Calendar calendarEnd = Calendar.getInstance();
                Date endDate = calendarEnd.getTime();
                JLabel beginDateLabel = new JLabel(I18n._((String)"lima.common.begindate"));
                final JXDatePicker beginDatePicker = new JXDatePicker(beginDate);
                ActionListener beginDateActionListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        LedgerPeriodSearchPanel.this.handler.setBeginDate(beginDatePicker.getDate());
                        LedgerPeriodSearchPanel.this.handler.refresh();
                    }
                };
                this.handler.setBeginDate(beginDatePicker.getDate());
                beginDatePicker.addActionListener(beginDateActionListener);
                JLabel endDateLabel = new JLabel(I18n._((String)"lima.common.enddate"));
                final JXDatePicker endDatePicker = new JXDatePicker(endDate);
                ActionListener endDateActionListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        LedgerPeriodSearchPanel.this.handler.setEndDate(endDatePicker.getDate());
                        LedgerPeriodSearchPanel.this.handler.refresh();
                    }
                };
                this.handler.setEndDate(endDatePicker.getDate());
                endDatePicker.addActionListener(endDateActionListener);
                this.handler.refresh();
                this.removeAll();
                this.add(beginDateLabel);
                this.add((Component)beginDatePicker);
                this.add(endDateLabel);
                this.add((Component)endDatePicker);
                break;
            }
            case FISCAL_PERIOD: {
                FiscalPeriodComboBoxModel fiscalModel = new FiscalPeriodComboBoxModel();
                FiscalPeriodComboBoxRenderer fiscalRenderer = new FiscalPeriodComboBoxRenderer();
                final JComboBox<Object> fiscalPeriod = new JComboBox<Object>(fiscalModel);
                fiscalPeriod.setRenderer(fiscalRenderer);
                fiscalPeriod.setEditable(false);
                ActionListener fiscalPeriodActionListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        FiscalPeriod fPeriod = (FiscalPeriod)fiscalPeriod.getSelectedItem();
                        if (fPeriod != null) {
                            LedgerPeriodSearchPanel.this.handler.setBeginDate(fPeriod.getBeginDate());
                            LedgerPeriodSearchPanel.this.handler.setEndDate(fPeriod.getEndDate());
                            LedgerPeriodSearchPanel.this.handler.refresh();
                        }
                    }
                };
                fiscalPeriod.addActionListener(fiscalPeriodActionListener);
                this.removeAll();
                this.add(fiscalPeriod);
                break;
            }
            case FINANCIAL_PERIOD: {
                FinancialPeriodComboBoxModel financialModel = new FinancialPeriodComboBoxModel();
                FinancialPeriodComboBoxRenderer financialRenderer = new FinancialPeriodComboBoxRenderer();
                final JComboBox<Object> financialPeriod = new JComboBox<Object>(financialModel);
                financialPeriod.setRenderer(financialRenderer);
                financialPeriod.setEditable(false);
                ActionListener financialPeriodActionListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        FinancialPeriod fPeriod = (FinancialPeriod)financialPeriod.getSelectedItem();
                        if (fPeriod != null) {
                            LedgerPeriodSearchPanel.this.handler.setBeginDate(fPeriod.getBeginDate());
                            LedgerPeriodSearchPanel.this.handler.setEndDate(fPeriod.getEndDate());
                            LedgerPeriodSearchPanel.this.handler.refresh();
                        }
                    }
                };
                financialPeriod.addActionListener(financialPeriodActionListener);
                this.removeAll();
                this.add(financialPeriod);
            }
        }
    }
}

