/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.fiscalperiod;

import java.awt.Component;
import java.util.Date;
import javax.swing.JOptionPane;
import jaxx.runtime.JAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.entity.FiscalPeriod;
import org.chorem.lima.ui.fiscalperiod.AddPeriod;
import org.chorem.lima.ui.fiscalperiod.FiscalPeriodTable;
import org.chorem.lima.ui.fiscalperiod.FiscalPeriodTableModel;
import org.chorem.lima.ui.fiscalperiod.FiscalPeriodView;
import org.chorem.lima.util.DialogHelper;
import org.nuiton.i18n.I18n;
import org.nuiton.util.DateUtils;

public class FiscalPeriodViewHandler {
    private static final Log log = LogFactory.getLog(FiscalPeriodViewHandler.class);
    private FiscalPeriodView view;

    protected FiscalPeriodViewHandler(FiscalPeriodView view) {
        this.view = view;
    }

    public void addFiscalPeriod() {
        FiscalPeriodTableModel model = (FiscalPeriodTableModel)this.getView().getFiscalPeriodTable().getModel();
        AddPeriod addPeriodDialog = new AddPeriod((JAXXContext)this.getView());
        addPeriodDialog.setLocationRelativeTo((Component)((Object)this.getView()));
        addPeriodDialog.setVisible(true);
        FiscalPeriod fiscalPeriod = addPeriodDialog.getPeriod();
        if (fiscalPeriod != null) {
            int nbMonth = DateUtils.getDifferenceInMonths((Date)fiscalPeriod.getBeginDate(), (Date)fiscalPeriod.getEndDate());
            int n = 0;
            if (nbMonth != 12) {
                n = JOptionPane.showConfirmDialog((Component)((Object)this.getView()), I18n._((String)"lima.charts.fiscalperiod.question.morethan12"), I18n._((String)"lima.common.question"), 0, 3);
            }
            if (n == 0 || nbMonth == 11) {
                try {
                    model.addFiscalPeriod(fiscalPeriod);
                }
                catch (LimaException eee) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"Can't add fiscal period", (Throwable)eee);
                    }
                    DialogHelper.showMessageDialog(eee.getMessage());
                }
            }
        }
    }

    public void blockFiscalPeriod() {
        FiscalPeriodTable fiscalPeriodeTable = this.getView().getFiscalPeriodTable();
        int selectedRow = fiscalPeriodeTable.getSelectedRow();
        FiscalPeriodTableModel model = (FiscalPeriodTableModel)this.getView().getFiscalPeriodTable().getModel();
        try {
            FiscalPeriod selectedFiscalPeriod = model.getFiscalPeriodAtRow(selectedRow);
            int response = JOptionPane.showConfirmDialog((Component)((Object)this.getView()), I18n._((String)"lima.charts.fiscalperiod.question.blocked"), I18n._((String)"lima.common.question"), 0, 3);
            if (response == 0) {
                model.blockFiscalPeriod(selectedFiscalPeriod);
            }
        }
        catch (LimaException eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't block fiscalperiod", (Throwable)eee);
            }
            DialogHelper.showMessageDialog(eee.getMessage());
        }
    }

    public FiscalPeriodView getView() {
        return this.view;
    }
}

