/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.fiscalperiod;

import java.text.SimpleDateFormat;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.FiscalPeriodServiceMonitorable;
import org.chorem.lima.business.ImportServiceMonitorable;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.business.ServiceListener;
import org.chorem.lima.entity.FiscalPeriod;
import org.chorem.lima.service.LimaServiceFactory;
import org.nuiton.i18n.I18n;

public class FiscalPeriodTableModel
extends AbstractTableModel
implements ServiceListener {
    private static final long serialVersionUID = 77027335135838258L;
    private static final Log log = LogFactory.getLog(FiscalPeriodTableModel.class);
    protected FiscalPeriodServiceMonitorable fiscalPeriodService = LimaServiceFactory.getInstance().getService(FiscalPeriodServiceMonitorable.class);

    public FiscalPeriodTableModel() {
        this.fiscalPeriodService.addListener((ServiceListener)this);
        LimaServiceFactory.getInstance().getService(ImportServiceMonitorable.class).addListener((ServiceListener)this);
    }

    @Override
    public int getRowCount() {
        int result;
        block2: {
            result = 0;
            try {
                result = this.fiscalPeriodService.getAllFiscalPeriods().size();
            }
            catch (LimaException eee) {
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)"Can't get row count", (Throwable)eee);
            }
        }
        return result;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    public Object getElementAt(int row) {
        Object currentRow;
        block2: {
            currentRow = null;
            try {
                currentRow = this.fiscalPeriodService.getAllFiscalPeriods().get(row);
            }
            catch (LimaException eee) {
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)"Can't get elenment at table", (Throwable)eee);
            }
        }
        return currentRow;
    }

    @Override
    public String getColumnName(int columnIndex) {
        String result = "n/a";
        switch (columnIndex) {
            case 0: {
                result = I18n._((String)"lima.table.fiscalperiod");
                break;
            }
            case 1: {
                result = I18n._((String)"lima.table.closure");
            }
        }
        return result;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        String result;
        block7: {
            result = "n/a";
            try {
                List periods = this.fiscalPeriodService.getAllFiscalPeriods();
                FiscalPeriod fiscalPeriod = (FiscalPeriod)periods.get(rowIndex);
                if (fiscalPeriod != null) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd MMM yyyy");
                    switch (columnIndex) {
                        case 0: {
                            result = simpleDateFormat.format(fiscalPeriod.getBeginDate()) + " - " + simpleDateFormat.format(fiscalPeriod.getEndDate());
                            break;
                        }
                        case 1: {
                            result = fiscalPeriod.getLocked() ? I18n._((String)"lima.common.closed") : I18n._((String)"lima.common.open");
                        }
                    }
                }
            }
            catch (LimaException eee) {
                if (!log.isDebugEnabled()) break block7;
                log.debug((Object)"Can't update table", (Throwable)eee);
            }
        }
        return result;
    }

    public FiscalPeriod getFiscalPeriodAtRow(int row) throws LimaException {
        FiscalPeriod fiscalPeriod = null;
        fiscalPeriod = (FiscalPeriod)this.fiscalPeriodService.getAllFiscalPeriods().get(row);
        return fiscalPeriod;
    }

    public void addFiscalPeriod(FiscalPeriod period) throws LimaException {
        int currentRowCount = this.getRowCount();
        this.fiscalPeriodService.createFiscalPeriod(period);
        this.fireTableRowsInserted(currentRowCount, currentRowCount);
    }

    public void blockFiscalPeriod(FiscalPeriod fiscalPeriod) throws LimaException {
        this.fiscalPeriodService.blockFiscalPeriod(fiscalPeriod);
        this.fireTableDataChanged();
    }

    public void notifyMethod(String serviceName, String methodeName) {
        if (methodeName.contains("importAll")) {
            this.fireTableDataChanged();
        }
    }
}

