/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.financialtransactionsearch;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.chorem.lima.enums.ComboBoxOperatorsEnum;
import org.chorem.lima.ui.financialtransactionsearch.FinancialTransactionSearchViewHandler;

public class AmountSearchPanel
extends JPanel {
    protected FinancialTransactionSearchViewHandler handler;
    static final long serialVersionUID = 1L;

    public AmountSearchPanel(FinancialTransactionSearchViewHandler handler) {
        this.handler = handler;
        this.refresh(ComboBoxOperatorsEnum.EQUAL);
    }

    public void refresh(ComboBoxOperatorsEnum enums) {
        final JTextField amountTextField = new JTextField(16);
        amountTextField.setMinimumSize(amountTextField.getPreferredSize());
        KeyListener amountKeyListener = new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                String amount = amountTextField.getText();
                if (!amount.equals(AmountSearchPanel.this.handler.getAmount())) {
                    AmountSearchPanel.this.handler.setAmount(amount);
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        };
        amountTextField.addKeyListener(amountKeyListener);
        this.handler.setAmount2("");
        this.handler.setOperator(enums.getSymbol());
        this.handler.refresh();
        this.removeAll();
        this.add(amountTextField);
        switch (enums) {
            case INTERVAL: {
                final JTextField amount2TextField = new JTextField(16);
                amount2TextField.setMinimumSize(amount2TextField.getPreferredSize());
                KeyListener amount2KeyListener = new KeyListener(){

                    @Override
                    public void keyTyped(KeyEvent e) {
                    }

                    @Override
                    public void keyReleased(KeyEvent e) {
                        String amount2 = amount2TextField.getText();
                        if (!amount2.equals(AmountSearchPanel.this.handler.getAmount2())) {
                            AmountSearchPanel.this.handler.setAmount2(amount2);
                        }
                    }

                    @Override
                    public void keyPressed(KeyEvent e) {
                    }
                };
                amount2TextField.addKeyListener(amount2KeyListener);
                this.handler.setAmount("");
                this.add(amount2TextField);
            }
        }
        amountTextField.setText(this.handler.getAmount());
    }
}

