/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.financialtransaction;

import java.awt.Component;
import javax.swing.JOptionPane;
import javax.swing.ListSelectionModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.entity.Entry;
import org.chorem.lima.entity.FinancialTransaction;
import org.chorem.lima.ui.combobox.FinancialPeriodComboBoxModel;
import org.chorem.lima.ui.combobox.FiscalPeriodComboBoxModel;
import org.chorem.lima.ui.financialtransaction.FinancialTransactionTable;
import org.chorem.lima.ui.financialtransaction.FinancialTransactionTableModel;
import org.chorem.lima.ui.financialtransaction.FinancialTransactionView;
import org.chorem.lima.util.DialogHelper;
import org.nuiton.i18n.I18n;

public class FinancialTransactionViewHandler {
    private static final Log log = LogFactory.getLog(FinancialTransactionViewHandler.class);
    protected FinancialTransactionView view;
    protected FinancialTransactionTable table;
    protected FinancialTransactionTableModel tableModel;
    protected FiscalPeriodComboBoxModel fiscalPeriodComboBoxModel;
    protected FinancialPeriodComboBoxModel financialPeriodComboBoxModel;
    protected Object clipBoard;

    protected FinancialTransactionViewHandler(FinancialTransactionView view) {
        this.view = view;
    }

    public void copyRow() {
        this.table = this.view.getFinancialTransactionTable();
        int indexSelectedRow = this.table.getSelectedRow();
        if (indexSelectedRow != -1) {
            this.clipBoard = this.tableModel.getElementAt(indexSelectedRow);
        }
    }

    public void pasteRow() {
        this.table = this.view.getFinancialTransactionTable();
        int indexSelectedRow = this.table.getSelectedRow();
        if (indexSelectedRow != -1) {
            Object selectedValue = this.tableModel.getElementAt(indexSelectedRow);
            if (this.clipBoard instanceof Entry) {
                try {
                    this.tableModel.addEntry(selectedValue, (Entry)this.clipBoard, indexSelectedRow);
                    ListSelectionModel selectionModel = this.table.getSelectionModel();
                    selectionModel.setSelectionInterval(indexSelectedRow + 1, indexSelectedRow + 1);
                    this.table.changeSelection(indexSelectedRow + 1, 1, false, false);
                    this.table.requestFocusInWindow();
                }
                catch (LimaException eee) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"Can't past entry", (Throwable)eee);
                    }
                    DialogHelper.showMessageDialog(eee.getMessage());
                }
            }
        }
    }

    public void addFinancialTransaction() {
        this.table = this.view.getFinancialTransactionTable();
        this.tableModel = this.view.getFinancialTransactionTableModel();
        try {
            this.tableModel.addFinancialTransaction();
            int numberRow = this.table.getRowCount();
            ListSelectionModel selectionModel = this.table.getSelectionModel();
            selectionModel.setSelectionInterval(numberRow - 1, numberRow - 1);
            this.table.changeSelection(numberRow - 1, 0, false, false);
            this.table.requestFocusInWindow();
        }
        catch (LimaException eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't add financialtransaction", (Throwable)eee);
            }
            DialogHelper.showMessageDialog(eee.getMessage());
        }
    }

    public void addEmptyEntry() {
        this.table = this.view.getFinancialTransactionTable();
        this.tableModel = this.view.getFinancialTransactionTableModel();
        int indexSelectedRow = this.table.getSelectedRow();
        if (indexSelectedRow != -1) {
            Object selectedValue = this.tableModel.getElementAt(indexSelectedRow);
            try {
                this.tableModel.addEmptyEntry(selectedValue, indexSelectedRow);
                ListSelectionModel selectionModel = this.table.getSelectionModel();
                selectionModel.setSelectionInterval(indexSelectedRow + 1, indexSelectedRow + 1);
                this.table.changeSelection(indexSelectedRow + 1, 1, false, false);
                this.table.requestFocusInWindow();
            }
            catch (LimaException eee) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can't add emptyentry", (Throwable)eee);
                }
                DialogHelper.showMessageDialog(eee.getMessage());
            }
        } else if (log.isWarnEnabled()) {
            log.warn((Object)"Call addentry selected transaction without selection");
        }
    }

    public void deleteSelectedRow() {
        this.table = this.view.getFinancialTransactionTable();
        this.tableModel = this.view.getFinancialTransactionTableModel();
        int indexSelectedRow = this.table.getSelectedRow();
        if (indexSelectedRow != -1) {
            Object selectedValue = this.tableModel.getElementAt(indexSelectedRow);
            String message = null;
            message = selectedValue instanceof FinancialTransaction ? I18n._((String)"lima.charts.financialtransaction.question.removetransaction") : I18n._((String)"lima.charts.financialtransaction.question.removeentry");
            int response = JOptionPane.showConfirmDialog((Component)((Object)this.view), message, I18n._((String)"lima.common.confirmation"), 0);
            if (response == 0) {
                try {
                    this.tableModel.removeObject(selectedValue, indexSelectedRow);
                    ListSelectionModel selectionModel = this.table.getSelectionModel();
                    selectionModel.setSelectionInterval(indexSelectedRow - 1, indexSelectedRow - 1);
                }
                catch (LimaException eee) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"Can't remove transaction or entry", (Throwable)eee);
                    }
                    DialogHelper.showMessageDialog(eee.getMessage());
                }
            }
        } else if (log.isWarnEnabled()) {
            log.warn((Object)"Call delete selected row without selection");
        }
    }

    public void refresh() {
        this.tableModel = this.view.getFinancialTransactionTableModel();
        this.tableModel.refresh();
        this.fiscalPeriodComboBoxModel = this.view.getModelFiscalPeriod();
        this.fiscalPeriodComboBoxModel.refresh();
        this.financialPeriodComboBoxModel = this.view.getModelFinancialPeriod();
        this.financialPeriodComboBoxModel.refresh();
    }
}

