/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.financialstatementchart;

import java.util.List;
import javax.swing.tree.TreePath;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.FinancialStatementServiceMonitorable;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.entity.FinancialStatement;
import org.chorem.lima.entity.FinancialStatementImpl;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.financialstatementchart.FinancialStatementChartViewHandler;
import org.jdesktop.swingx.treetable.AbstractTreeTableModel;
import org.nuiton.i18n.I18n;

public class FinancialStatementChartTreeTableModel
extends AbstractTreeTableModel {
    private static final Log log = LogFactory.getLog(FinancialStatementChartViewHandler.class);
    protected final FinancialStatementServiceMonitorable financialStatementService = LimaServiceFactory.getInstance().getService(FinancialStatementServiceMonitorable.class);

    public FinancialStatementChartTreeTableModel() {
        super((Object)new FinancialStatementImpl());
    }

    public int getColumnCount() {
        return 5;
    }

    public String getColumnName(int column) {
        String res = null;
        switch (column) {
            case 0: {
                res = I18n._((String)"lima.table.label");
                break;
            }
            case 1: {
                res = I18n._((String)"lima.table.debitcredit");
                break;
            }
            case 2: {
                res = I18n._((String)"lima.table.debit");
                break;
            }
            case 3: {
                res = I18n._((String)"lima.table.credit");
                break;
            }
            case 4: {
                res = I18n._((String)"lima.table.provisiondeprecationamount");
            }
        }
        return res;
    }

    public int getChildCount(Object node) {
        int result = 0;
        if (node == this.getRoot()) {
            try {
                result = this.financialStatementService.getChildrenFinancialStatement(null).size();
            }
            catch (LimaException eee) {
                log.debug((Object)"Can't count child", (Throwable)eee);
            }
        } else {
            FinancialStatement parentFinancialStatementHeader = (FinancialStatement)node;
            try {
                result = this.financialStatementService.getChildrenFinancialStatement(parentFinancialStatementHeader).size();
            }
            catch (LimaException eee) {
                log.debug((Object)"Can't count child", (Throwable)eee);
            }
        }
        return result;
    }

    public Object getChild(Object parent, int index) {
        Object result = null;
        if (parent == this.getRoot()) {
            try {
                List financialStatements = this.financialStatementService.getChildrenFinancialStatement(null);
                result = financialStatements.get(index);
            }
            catch (LimaException eee) {
                log.debug((Object)"Can't get child", (Throwable)eee);
            }
        } else {
            FinancialStatement parentFinancialStatement = (FinancialStatement)parent;
            try {
                List financialStatements = this.financialStatementService.getChildrenFinancialStatement(parentFinancialStatement);
                result = financialStatements.get(index);
            }
            catch (LimaException eee) {
                log.debug((Object)"Can't get child", (Throwable)eee);
            }
        }
        return result;
    }

    public int getIndexOfChild(Object parent, Object child) {
        int result = 0;
        if (parent == this.getRoot()) {
            try {
                List financialStatements = this.financialStatementService.getChildrenFinancialStatement(null);
                result = financialStatements.indexOf(child);
            }
            catch (LimaException eee) {
                log.debug((Object)"Can't get index child", (Throwable)eee);
            }
        } else {
            FinancialStatement parentFinancialStatement = (FinancialStatement)parent;
            try {
                List financialStatements = this.financialStatementService.getChildrenFinancialStatement(parentFinancialStatement);
                result = financialStatements.indexOf(child);
            }
            catch (LimaException eee) {
                log.debug((Object)"Can't get index child", (Throwable)eee);
            }
        }
        return result;
    }

    public Object getValueAt(Object node, int column) {
        String result = "n/a";
        FinancialStatement financialStatement = (FinancialStatement)node;
        switch (column) {
            case 0: {
                result = financialStatement.getLabel();
                break;
            }
            case 1: {
                result = financialStatement.getAccounts();
                break;
            }
            case 2: {
                result = financialStatement.getDebitAccounts();
                break;
            }
            case 3: {
                result = financialStatement.getCreditAccounts();
                break;
            }
            case 4: {
                result = financialStatement.getProvisionDeprecationAccounts();
            }
        }
        return result;
    }

    public boolean isCellEditable(Object node, int column) {
        return false;
    }

    public boolean isLeaf(Object node) {
        return this.getChildCount(node) == 0;
    }

    public void refreshTree() throws LimaException {
        this.modelSupport.fireNewRoot();
    }

    public void addFinancialStatement(TreePath path, FinancialStatement financialStatement) throws LimaException {
        FinancialStatement parentFinancialStatementHeader = (FinancialStatement)path.getLastPathComponent();
        if (parentFinancialStatementHeader == this.getRoot()) {
            parentFinancialStatementHeader = null;
        }
        this.financialStatementService.createFinancialStatement(parentFinancialStatementHeader, financialStatement);
        this.modelSupport.fireTreeStructureChanged(path);
    }

    public void updateFinancialStatement(TreePath path, FinancialStatement financialStatement) throws LimaException {
        this.financialStatementService.updateFinancialStatement(financialStatement);
        this.modelSupport.fireTreeStructureChanged(path);
    }

    public void removeFinancialStatementObject(TreePath path, FinancialStatement financialStatement) throws LimaException {
        int index = this.getIndexOfChild(path.getParentPath().getLastPathComponent(), financialStatement);
        this.financialStatementService.removeFinancialStatement(financialStatement);
        this.modelSupport.fireChildRemoved(path.getParentPath(), index, (Object)financialStatement);
    }
}

