/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.financialperiod;

import java.awt.Component;
import javax.swing.JOptionPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.entity.ClosedPeriodicEntryBook;
import org.chorem.lima.ui.financialperiod.FinancialPeriodTable;
import org.chorem.lima.ui.financialperiod.FinancialPeriodTableModel;
import org.chorem.lima.ui.financialperiod.FinancialPeriodView;
import org.chorem.lima.util.DialogHelper;
import org.nuiton.i18n.I18n;

public class FinancialPeriodViewHandler {
    private static final Log log = LogFactory.getLog(FinancialPeriodViewHandler.class);
    protected FinancialPeriodView view;

    protected FinancialPeriodViewHandler(FinancialPeriodView view) {
        this.view = view;
    }

    public void blockFinancialPeriod() {
        FinancialPeriodTable financialPeriodeTable = this.view.getFinancialPeriodTable();
        int selectedRow = financialPeriodeTable.getSelectedRow();
        FinancialPeriodTableModel model = (FinancialPeriodTableModel)this.view.getFinancialPeriodTable().getModel();
        try {
            ClosedPeriodicEntryBook closedPeriodicEntryBook = model.getFinancialPeriodAtRow(selectedRow);
            int response = JOptionPane.showConfirmDialog((Component)((Object)this.view), I18n._((String)"lima.charts.financialperiod.question.blocked"), I18n._((String)"lima.common.question"), 0, 3);
            if (response == 0) {
                model.blockFinancialPeriod(closedPeriodicEntryBook);
            }
        }
        catch (LimaException eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't block financialperiod", (Throwable)eee);
            }
            DialogHelper.showMessageDialog(eee.getMessage());
        }
    }

    public FinancialPeriodView getView() {
        return this.view;
    }
}

