/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.financialperiod;

import java.awt.Color;
import java.awt.Component;
import java.text.SimpleDateFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.FinancialPeriodServiceMonitorable;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.business.ejbinterface.FinancialPeriodService;
import org.chorem.lima.entity.ClosedPeriodicEntryBook;
import org.chorem.lima.entity.ClosedPeriodicEntryBookImpl;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.financialperiod.FinancialPeriodTableModel;
import org.chorem.lima.ui.financialperiod.FinancialPeriodViewHandler;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;

public class FinancialPeriodTable
extends JXTable {
    private static final long serialVersionUID = -1960326844433064178L;
    private static final Log log = LogFactory.getLog(FinancialPeriodTableModel.class);
    protected FinancialPeriodViewHandler handler;
    protected FinancialPeriodTableModel model;
    protected FinancialPeriodService financialPeriodService;
    private Highlighter colorTransaction;

    public FinancialPeriodTable(FinancialPeriodViewHandler handler) {
        this.handler = handler;
        this.model = this.handler.getView().modelFinancialPeriodTable;
        this.financialPeriodService = (FinancialPeriodService)LimaServiceFactory.getInstance().getService(FinancialPeriodServiceMonitorable.class);
        this.addMonthColor();
        this.addBlockColor();
    }

    protected void addMonthColor() {
        HighlightPredicate predicate = new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM");
                ClosedPeriodicEntryBook closedPeriodicEntryBook = (ClosedPeriodicEntryBook)FinancialPeriodTable.this.model.getElementAt(adapter.row);
                int month = Integer.parseInt(simpleDateFormat.format(closedPeriodicEntryBook.getFinancialPeriod().getBeginDate()));
                return month % 2 == 0;
            }
        };
        this.colorTransaction = new ColorHighlighter(predicate, new Color(222, 222, 222), null);
        this.addHighlighter(this.colorTransaction);
    }

    protected void addBlockColor() {
        HighlightPredicate predicate = new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                ClosedPeriodicEntryBookImpl closedPeriodicEntryBook = new ClosedPeriodicEntryBookImpl();
                ClosedPeriodicEntryBook selectedClosedPeriodicEntryBook = (ClosedPeriodicEntryBook)FinancialPeriodTable.this.model.getElementAt(adapter.row);
                try {
                    closedPeriodicEntryBook = FinancialPeriodTable.this.financialPeriodService.getClosedPeriodicEntryBook(selectedClosedPeriodicEntryBook.getEntryBook(), selectedClosedPeriodicEntryBook.getFinancialPeriod());
                }
                catch (LimaException eee) {
                    log.debug((Object)"Can't get closePeriodicEntryBook", (Throwable)eee);
                }
                return closedPeriodicEntryBook.getLocked();
            }
        };
        this.colorTransaction = new ColorHighlighter(predicate, null, new Color(222, 0, 0));
        this.addHighlighter(this.colorTransaction);
    }
}

