/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.accountsreports;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComboBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.entity.Account;
import org.chorem.lima.ui.accountsreports.AccountsReportsViewHandler;
import org.chorem.lima.ui.combobox.AccountComboBoxModel;
import org.chorem.lima.ui.combobox.AccountRenderer;
import org.chorem.lima.util.AccountToString;
import org.jdesktop.swingx.autocomplete.AutoCompleteDecorator;
import org.jdesktop.swingx.autocomplete.ObjectToStringConverter;

public class AccountComboBox
extends JComboBox
implements KeyListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(AccountComboBox.class);
    protected AccountsReportsViewHandler handler;

    public AccountComboBox(AccountsReportsViewHandler handler) {
        this.handler = handler;
        AccountComboBoxModel accountComboBoxModel = new AccountComboBoxModel();
        AccountRenderer accountRenderer = new AccountRenderer();
        this.setModel(accountComboBoxModel);
        this.setRenderer(accountRenderer);
        this.setEditable(true);
        AutoCompleteDecorator.decorate((JComboBox)this, (ObjectToStringConverter)AccountToString.getInstance());
        this.getEditor().getEditorComponent().addKeyListener(this);
        this.addActionListener(this);
    }

    public void back() {
        int row = this.getSelectedIndex();
        log.debug((Object)row);
        if (row > 0) {
            this.getEditor().setItem(this.getItemAt(row - 1));
            this.handler.setAccount((Account)this.getSelectedItem());
        }
    }

    public void next() {
        int size = this.getModel().getSize();
        int row = this.getSelectedIndex();
        log.debug((Object)row);
        if (row < size - 1) {
            this.getEditor().setItem(this.getItemAt(row + 1));
            this.handler.setAccount((Account)this.getSelectedItem());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object object = this.getSelectedItem();
        if (object instanceof Account) {
            this.handler.setAccount((Account)this.getSelectedItem());
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        Object object = this.getSelectedItem();
        if (object instanceof Account) {
            this.handler.setAccount((Account)this.getSelectedItem());
        }
        if (e.getKeyChar() == '\n') {
            this.firePopupMenuCanceled();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

