/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.account;

import java.util.List;
import javax.swing.tree.TreePath;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.AccountServiceMonitorable;
import org.chorem.lima.business.LimaBusinessException;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.entity.Account;
import org.chorem.lima.entity.AccountImpl;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.account.AccountViewHandler;
import org.jdesktop.swingx.treetable.AbstractTreeTableModel;
import org.nuiton.i18n.I18n;

public class AccountTreeTableModel
extends AbstractTreeTableModel {
    private static final Log log = LogFactory.getLog(AccountViewHandler.class);
    protected final AccountServiceMonitorable accountService = LimaServiceFactory.getInstance().getService(AccountServiceMonitorable.class);

    public AccountTreeTableModel() {
        super((Object)new AccountImpl());
    }

    public int getColumnCount() {
        return 2;
    }

    public String getColumnName(int column) {
        String res = null;
        switch (column) {
            case 0: {
                res = I18n._((String)"lima.table.number");
                break;
            }
            case 1: {
                res = I18n._((String)"lima.table.label");
            }
        }
        return res;
    }

    public int getChildCount(Object node) {
        int result = 0;
        if (node == this.getRoot()) {
            try {
                result = this.accountService.getChildrenAccounts(null).size();
            }
            catch (LimaException eee) {
                log.debug((Object)"Can't count child", (Throwable)eee);
            }
        } else {
            Account parentAccount = (Account)node;
            try {
                result = this.accountService.getChildrenAccounts(parentAccount).size();
            }
            catch (LimaException eee) {
                log.debug((Object)"Can't count child", (Throwable)eee);
            }
        }
        return result;
    }

    public Object getChild(Object parent, int index) {
        Object result = null;
        if (parent == this.getRoot()) {
            try {
                List allAccounts = this.accountService.getChildrenAccounts(null);
                result = allAccounts.get(index);
            }
            catch (LimaException eee) {
                log.debug((Object)"Can't get child", (Throwable)eee);
            }
        } else {
            Account parentAccount = (Account)parent;
            try {
                List subaccounts = this.accountService.getChildrenAccounts(parentAccount);
                result = subaccounts.get(index);
            }
            catch (LimaException eee) {
                log.debug((Object)"Can't get child", (Throwable)eee);
            }
        }
        return result;
    }

    public int getIndexOfChild(Object parent, Object child) {
        int result = 0;
        Account parentAccount = (Account)parent;
        Account childAccount = (Account)child;
        if (parent == this.getRoot()) {
            try {
                List allAccounts = this.accountService.getChildrenAccounts(null);
                result = allAccounts.indexOf(child);
            }
            catch (LimaException eee) {
                log.debug((Object)"Can't get index child", (Throwable)eee);
            }
        } else {
            try {
                List subaccounts = this.accountService.getChildrenAccounts(parentAccount);
                result = subaccounts.indexOf(childAccount);
            }
            catch (LimaException eee) {
                log.debug((Object)"Can't get index child", (Throwable)eee);
            }
        }
        return result;
    }

    public Object getValueAt(Object node, int column) {
        String result = "n/a";
        if (node instanceof Account) {
            Account account = (Account)node;
            switch (column) {
                case 0: {
                    result = account.getAccountNumber();
                    break;
                }
                case 1: {
                    result = account.getLabel();
                }
            }
        }
        return result;
    }

    public boolean isCellEditable(Object node, int column) {
        return false;
    }

    public boolean isLeaf(Object node) {
        return this.getChildCount(node) == 0;
    }

    public void addAccount(TreePath path, Account account) throws LimaException {
        Account parentAccount = (Account)path.getLastPathComponent();
        if (parentAccount == this.getRoot()) {
            parentAccount = null;
        }
        this.accountService.createAccount(parentAccount, account);
        this.modelSupport.fireTreeStructureChanged(path);
    }

    public void addSubLedger(TreePath path, Account account) throws LimaException {
        Account parentAccount = (Account)path.getLastPathComponent();
        if (parentAccount == this.getRoot()) {
            parentAccount = null;
        }
        this.accountService.createSubLedger(parentAccount, account);
        this.modelSupport.fireTreeStructureChanged(path);
    }

    public void updateAccount(TreePath path, Account account) throws LimaException {
        try {
            this.accountService.updateAccount(account);
        }
        catch (LimaBusinessException eee) {
            this.modelSupport.fireTreeStructureChanged(path);
            throw eee;
        }
        this.modelSupport.fireTreeStructureChanged(path);
    }

    public void refreshTree() throws LimaException {
        this.modelSupport.fireNewRoot();
    }

    public void removeAccount(TreePath path, Account account) throws LimaException {
        int index = this.getIndexOfChild(path.getParentPath().getLastPathComponent(), account);
        this.accountService.removeAccount(account);
        this.modelSupport.fireChildRemoved(path.getParentPath(), index, (Object)account);
    }
}

