/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.service;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openejb.OpenEJB;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.Assembler;
import org.apache.openejb.loader.SystemInstance;
import org.chorem.lima.LimaMain;
import org.chorem.lima.service.ServiceMonitorableHandler;

public class LimaServiceFactory {
    private static Log log = LogFactory.getLog(LimaServiceFactory.class);
    private static LimaServiceFactory instance;
    protected HashMap<Class, Object> services;
    protected static InitialContext ctx;

    protected LimaServiceFactory() {
        block3: {
            this.services = new HashMap();
            Properties props = LimaMain.config.getFlatOptions();
            if (!props.containsKey("java.naming.factory.initial")) {
                throw new RuntimeException("Application configuration is missing mandatory property java.naming.factory.initial");
            }
            try {
                ctx = new InitialContext(props);
            }
            catch (NamingException eee) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)"Can't initialize initial context", (Throwable)eee);
            }
        }
    }

    public static LimaServiceFactory getInstance() {
        if (instance == null) {
            instance = new LimaServiceFactory();
        }
        return instance;
    }

    public <M> M getService(Class<M> serviceMonitorableClass) {
        Object result = this.services.get(serviceMonitorableClass);
        if (result == null) {
            Object ejbHome;
            block3: {
                ejbHome = null;
                String serviceName = serviceMonitorableClass.getSimpleName().replace("Monitorable", "ImplRemote");
                try {
                    ejbHome = ctx.lookup(serviceName);
                }
                catch (NamingException eee) {
                    if (!log.isErrorEnabled()) break block3;
                    log.error((Object)("Can't lookup for service : " + serviceName), (Throwable)eee);
                }
            }
            ServiceMonitorableHandler handler = new ServiceMonitorableHandler(ejbHome);
            result = Proxy.newProxyInstance(serviceMonitorableClass.getClassLoader(), new Class[]{serviceMonitorableClass}, (InvocationHandler)handler);
            this.services.put(serviceMonitorableClass, result);
        }
        return (M)result;
    }

    public void destroy() throws Exception {
        Assembler assembler = (Assembler)SystemInstance.get().getComponent(Assembler.class);
        for (AppInfo appInfo : assembler.getDeployedApplications()) {
            assembler.destroyApplication(appInfo.jarPath);
        }
        OpenEJB.destroy();
    }
}

