/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.enums;

public enum EncodingEnum {
    UTF8("UTF-8", "UTF-8   Lima"),
    ISOLATIN1("ISO-8859-1", "ISO-Latin-1   Excel / Windows"),
    MACROMAN("MacRoman", "MacRoman Excel / Mac");

    private final String encoding;
    private final String description;

    private EncodingEnum(String encoding, String description) {
        this.encoding = encoding;
        this.description = description;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getDescription() {
        return this.description;
    }

    public static String[] descriptions() {
        int nbElts = EncodingEnum.values().length;
        String[] descriptions = new String[nbElts];
        EncodingEnum[] encodingEnums = EncodingEnum.values();
        for (int i = 0; i < nbElts; ++i) {
            descriptions[i] = encodingEnums[i].getDescription();
        }
        return descriptions;
    }

    public static EncodingEnum valueOfDescription(String description) {
        EncodingEnum value = null;
        for (EncodingEnum encodingEnum : EncodingEnum.values()) {
            if (!description.equals(encodingEnum.description)) continue;
            value = encodingEnum;
            break;
        }
        return value;
    }
}

