/*
 * #%L
 * Lima Swing
 * 
 * $Id: BalanceTableModel.java 3051 2010-11-29 14:57:16Z echatellier $
 * $HeadURL: http://svn.chorem.org/svn/lima/tags/lima-0.4.3/lima-swing/src/main/java/org/chorem/lima/ui/balance/BalanceTableModel.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.ui.balance;

import static org.nuiton.i18n.I18n._;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.beans.BalanceTrial;
import org.chorem.lima.beans.ReportsDatas;


/**
 * Entry book table model.
 * By : $Author: echatellier $
 */
public class BalanceTableModel extends AbstractTableModel {

    /** serialVersionUID. */
    private static final long serialVersionUID = 1L;

    /** log. */
    private static final Log log = LogFactory.getLog(BalanceTableModel.class);
    
    /** data cache */
    protected BalanceTrial cacheDataList;

    @Override
    public int getRowCount() {
        int result = 0;
        if (cacheDataList != null){
            result = cacheDataList.getReportsDatas().size();    
        }
        return result;
    }

    @Override
    public int getColumnCount() {
        return 6;
    }

    @Override
    public String getColumnName(int column) {
        String res = "n/a";
        switch (column) {
            case 0:
                res = _("lima.table.number"); // Numero de compte
                break;
            case 1:
                res = _("lima.table.label"); // Label
                break;
            case 2:
                res = _("lima.table.move.debit"); // Total Debit
                break;
            case 3:
                res = _("lima.table.move.credit"); // Total Credit
                break;
            case 4:
                res = _("lima.table.solde.debit"); //Solde Debit
                break;
            case 5:
                res = _("lima.table.solde.credit"); //Solde Credit
                break;
        }
        return res;
    }

    @Override
    public Object getValueAt(int row, int column) {
        Object result = null;
        ReportsDatas currentRow = ((List<ReportsDatas>) cacheDataList.getReportsDatas()).get(row);
        //get entries for the period for the current row 
        try {
            switch (column) {
                case 0:
                    result = currentRow.getAccount().getAccountNumber(); //account number
                    break;
                case 1:
                    result = currentRow.getAccount().getLabel(); //account label
                    break;
                case 2:
                    result = currentRow.getAmountDebit(); // total debit
                    break;
                case 3:
                    result = currentRow.getAmountCredit(); // total crédit
                    break;
                case 4: // solde debit
                    if (currentRow.getSoldeDebit()){
                        result = currentRow.getAmountSolde();
                    }
                    else {
                        result = 0;
                    }
                    break;
                case 5: // solde credit
                    if (!currentRow.getSoldeDebit()){
                        result = currentRow.getAmountSolde();
                    }
                    else {
                        result = 0;
                    }
                    break;
            }
        }
        catch (Exception eee) {
            log.debug("Can't get entries", eee);
        }
            
        return result;
    }


    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        // Just read, no write
        return false;
    }
    
    
    public void refresh(BalanceTrial datasList){
        cacheDataList = datasList;
        fireTableDataChanged();
    }
    
}
