/*
 * #%L
 * Lima :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2008 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package org.chorem.lima.ui.account;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.ui.account.*;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static org.nuiton.i18n.I18n._;

public class AccountView extends jaxx.runtime.swing.Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_HANDLER = "handler";
    public static final String PROPERTY_SELECTED_ROW = "selectedRow";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ADD_SUB_LEDGER_ENABLED = "addSubLedger.enabled";
    public static final String BINDING_REMOVE_BUTTON_ENABLED = "removeButton.enabled";
    public static final String BINDING_UPDATE_BUTTON_ENABLED = "updateButton.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUz08TQRSeVkotBRRQxAgCgl6MW6PxBEF+hQApaigxxF6cdibt4HRnnJml68X4J/gn6N2LiTdPxoNnD16M/4IxHrwa3+yWbgtradImndnMe98333vz3nv3E6W0QrMH2Pcd5bmG1aizvbK//7B0QMtmneqyYtIIhcJfIomSRZQlzXNt0Fwxb+G5Bjy3JmpSuNRtQS/k0YA2LzjVVUqNQVPtiLLWuULTvOBLTx2xNkXFsb75/Sv5mrx6m0TIl6AuC6HMnIaKIunLoyQjBo3CTYc4x7FbARmKuRXQO2TP1jjW+gGu0efoJUrnUb/ECsgMutZ9yAFHgPelQen5PVzi9LZBN4SqOOWqULTmcFbDjsccXC4LoHRWwv0xo3UpA3A/QKvYJZwqg251B90M/SOGrKYcXpWSXVE3aMRG6NionVUhOMVu5Dk0v10oK8H5I+xasZesr+/oOiTHaTFZ90wTNdIQofcUpUGcBk1brQdQMM+MkCGB72zvNz0sdLTJcGE+z7QpBDKZcHcEoRyuv9p6/UmPSHcGE7LqGSNcg8baNIen7XoHwbvglfKUVKiyZ1PH7J4k2NAIetwODyAOO9gZlIUyJ+0KXWkrU2gAJ2qAqEITRZRSHhwbNFE82TO7YAq7ZeJYt1jCwPp3fOzbxx8fNlpb5GKsa0uHQ+lKJSSUGrNXnwv7wzOM53awXCiiTFhIQftPxggrNMwgDu4LC83CnU2sq0CRSn//9Hn86dczKLmBBrjAZANb/y2UMVUFWRCc+PL+cqBosH4W1vNWG6S0yipVDn9D7eXDi/BAeKbEXAKvvORDKiZjUtHUU8p8+TNWeL98lI4EyLv8X/coJaknqJ+5nLk0mBmNcRA7I7JSU4+IqO3jBkHC7uOyUbg3gzUXF++Qbq1063bH9+x2N1Bvv+51TTZsjrouaJse2foM9WEUji6GiZnBBmZnyTN0KZ5zsgvONHWtPNJB2vSpNPZ4zS7rvTBsddAw27OG7hg6aZjrWUPvDNeB4R8LBhqgQwgAAA==";
    public static final String PROPERTY$LIST_SELECTION_MODEL0 = "$ListSelectionModel0";
    private static final Log log = LogFactory.getLog(org.chorem.lima.ui.account.AccountView.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected org.jdesktop.swingx.JXTreeTable accountsTreeTable;
    protected javax.swing.JButton addButton;
    protected javax.swing.JButton addSubLedger;
    protected org.chorem.lima.ui.account.AccountViewHandler handler;
    protected javax.swing.JButton importButton;
    protected javax.swing.JButton removeButton;
    protected java.lang.Boolean selectedRow;
    protected javax.swing.JButton updateButton;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private AccountView $Table0 = this;
    private javax.swing.JScrollPane $JScrollPane0;
    private javax.swing.ListSelectionModel $ListSelectionModel0;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AccountView() {
        $initialize();
    }

    public AccountView(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__addButton(java.awt.event.ActionEvent event) {
        getHandler().addAccount();
    }

    public void doActionPerformed__on__addSubLedger(java.awt.event.ActionEvent event) {
        getHandler().addSubLedger();
    }

    public void doActionPerformed__on__importButton(java.awt.event.ActionEvent event) {
        getHandler().importAccountsChart();
    }

    public void doActionPerformed__on__removeButton(java.awt.event.ActionEvent event) {
        getHandler().removeAccount();
    }

    public void doActionPerformed__on__updateButton(java.awt.event.ActionEvent event) {
        getHandler().updateAccount();
    }

    public void doValueChanged__on__$ListSelectionModel0(javax.swing.event.ListSelectionEvent event) {
        setSelectedRow(accountsTreeTable.getSelectedRow() != -1);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public org.jdesktop.swingx.JXTreeTable getAccountsTreeTable() {
        return accountsTreeTable;
    }

    public javax.swing.JButton getAddButton() {
        return addButton;
    }

    public javax.swing.JButton getAddSubLedger() {
        return addSubLedger;
    }

    public org.chorem.lima.ui.account.AccountViewHandler getHandler() {
        return handler;
    }

    public javax.swing.JButton getImportButton() {
        return importButton;
    }

    public javax.swing.JButton getRemoveButton() {
        return removeButton;
    }

    public java.lang.Boolean getSelectedRow() {
        return selectedRow;
    }

    public javax.swing.JButton getUpdateButton() {
        return updateButton;
    }

    public java.lang.Boolean isSelectedRow() {
        return selectedRow !=null && selectedRow;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void set$ListSelectionModel0(javax.swing.ListSelectionModel newValue) {
        javax.swing.ListSelectionModel oldValue = this.$ListSelectionModel0;
        this.$ListSelectionModel0 = newValue;
        firePropertyChange(PROPERTY$LIST_SELECTION_MODEL0, oldValue, newValue);
    }

    public void setHandler(org.chorem.lima.ui.account.AccountViewHandler newValue) {
        org.chorem.lima.ui.account.AccountViewHandler oldValue = this.handler;
        this.handler = newValue;
        firePropertyChange(PROPERTY_HANDLER, oldValue, newValue);
    }

    public void setSelectedRow(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.selectedRow;
        this.selectedRow = newValue;
        firePropertyChange(PROPERTY_SELECTED_ROW, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected javax.swing.ListSelectionModel get$ListSelectionModel0() {
        return $ListSelectionModel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createAccountsTreeTable() {
        $objectMap.put("accountsTreeTable", accountsTreeTable = new org.jdesktop.swingx.JXTreeTable());
        
        accountsTreeTable.setName("accountsTreeTable");
    }

    protected void createAddButton() {
        $objectMap.put("addButton", addButton = new javax.swing.JButton());
        
        addButton.setName("addButton");
        addButton.setText(_("lima.charts.account.addAccount"));
        addButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addButton"));
    }

    protected void createAddSubLedger() {
        $objectMap.put("addSubLedger", addSubLedger = new javax.swing.JButton());
        
        addSubLedger.setName("addSubLedger");
        addSubLedger.setText(_("lima.charts.account.addSubLedger"));
        addSubLedger.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addSubLedger"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new AccountViewHandler(this));
    }

    protected void createImportButton() {
        $objectMap.put("importButton", importButton = new javax.swing.JButton());
        
        importButton.setName("importButton");
        importButton.setText(_("lima.importexport.import"));
        importButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__importButton"));
    }

    protected void createRemoveButton() {
        $objectMap.put("removeButton", removeButton = new javax.swing.JButton());
        
        removeButton.setName("removeButton");
        removeButton.setText(_("lima.common.remove"));
        removeButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__removeButton"));
    }

    protected void createSelectedRow() {
        $objectMap.put("selectedRow", selectedRow = false);
    }

    protected void createUpdateButton() {
        $objectMap.put("updateButton", updateButton = new javax.swing.JButton());
        
        updateButton.setName("updateButton");
        updateButton.setText(_("lima.common.update"));
        updateButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__updateButton"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $Table0
        add($JScrollPane0, new GridBagConstraints(0, 0, 1, 5, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add(addButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(addSubLedger, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(updateButton, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(removeButton, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(importButton, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(accountsTreeTable);
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 3 property setters
        accountsTreeTable.setHighlighters(org.jdesktop.swingx.decorator.HighlighterFactory.createSimpleStriping(new java.awt.Color(222,222,222)));
        accountsTreeTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        accountsTreeTable.setTreeTableModel(new org.chorem.lima.ui.account.AccountTreeTableModel());
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$Table0", this);
        createHandler();
        createSelectedRow();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createAccountsTreeTable();
        // inline creation of $ListSelectionModel0
        $objectMap.put("$ListSelectionModel0", $ListSelectionModel0 = getAccountsTreeTable().getSelectionModel());
        
        $ListSelectionModel0.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__$ListSelectionModel0"));
        createAddButton();
        createAddSubLedger();
        createUpdateButton();
        createRemoveButton();
        createImportButton();
        // inline creation of $Table0
        setName("$Table0");
        
        // registers 3 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 3 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_ADD_SUB_LEDGER_ENABLED, true ,"selectedRow") {
        
            @Override
            public void processDataBinding() {
                addSubLedger.setEnabled(isSelectedRow());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_UPDATE_BUTTON_ENABLED, true ,"selectedRow") {
        
            @Override
            public void processDataBinding() {
                updateButton.setEnabled(isSelectedRow());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REMOVE_BUTTON_ENABLED, true ,"selectedRow") {
        
            @Override
            public void processDataBinding() {
                removeButton.setEnabled(isSelectedRow());
            }
        });
    }

}