/*
 * #%L
 * Lima :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2008 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package org.chorem.lima.ui;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.*;
import java.util.Locale;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.LimaConfig;
import org.chorem.lima.business.HttpServerServiceMonitorable;
import org.chorem.lima.enums.ImportExportEnum;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.*;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static org.nuiton.i18n.I18n._;

public class MainView extends javax.swing.JFrame implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_DESKTOP = "desktop";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_I18N_EN_ENABLED = "i18n_en.enabled";
    public static final String BINDING_I18N_FR_ENABLED = "i18n_fr.enabled";
    public static final String BINDING_MENU_FILE_FULLSCREEN_VISIBLE = "menuFileFullscreen.visible";
    public static final String BINDING_MENU_FILE_NORMALSCREEN_VISIBLE = "menuFileNormalscreen.visible";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JFRAME0_UNDECORATED = "$JFrame0.undecorated";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAALWZz2/cRBTHJ0s2P1vS5lcDaUX6A6EKcH7/aqJSmmjVRElaNaGKGkQ7u55kJ/Xarj1ONhUqPXNAgLhwgzsXJG5wQQhx5oCQUP8FhDhwRTx7d+3dZHY86hM9bFN/3/vM970Z26+bb/4kWd8jF/dpuWx4gS14iRmr725v387vs4JYZn7B465wPFL505IhmR3SbcbXfUEu76yF6aPV9NElp+Q6NrPrshfWSJcvjizmFxkTglxozCj4/uhmLC+U3cCrUWNTMupXf/+V+dR89nWGkLIL7q5BKSNpWUklrWskw01BemGlAzpqUXsPbHjc3gO/p8NrSxb1/Q1aYo/JU9K+Rtpc6gFMkEv6JUeMKL/sCtJxZTXnAXBMkGHH2zMKRcdjJcPiJWoE3Fin3L7H2aHrRiltgrRDrx8JB1LPhI4MeiiM5cqlJKjryuo6s4Ob1ANufxhXNvxDKMSoXa8DVmIh8OyJwDCk53jkePjP/vCj97g0EUsDsdRdkVYEK8EaAyfWCIUw9JwsI1pruKk8oZYnJXLV6aTa6VSceUkmT6vlGbU8K5Grtqaa93Y6lt6SQediqCGT5yVyFTwjAZ+q24KxOHVKqo/L9U0GNweFkw+7Ptiw67HSWGc9M9nYXikzWnOxef6kPD/Wp1L4Eyn8aUl+tZ2zcTt7pKnJ4ViR6rMp+lyKPq/WJ8YketX6nNr6RLLT70n1iRR9MkWfkuhVa/Mp1pINeSDVZ1L02RR9LkWfl+gd1eflmMR7bwmUHLdYLrAseEcwZseER3FUfy1qw/FKtHlcbaVxyUqtRWa5cc7j5LrPBZNcz9K8EwiJUFskecgnWjsfn7Mf7Hpx2tExqc72UT3xDrWZBU+I3oYnRHQ1DOqMY88WHFvAG3WL5vPMDAMEOdeQlChhykcuvPyHG17+MFYYyViRvPdbdkjWC+CyIEM7JyeRuyBVZpChYzNICIzUfwf7fvv++Xe52uBRhLUHpKF1cxMMBK7nuMwTPFy6pzJ1BIJbo+vUXdghnT6zYOiKhqrzEmObVRnMwXrR29sI041b1C8CItv+x48/DT789SWSyZEuy6FmjobxK6RTFD3ogmOZZfedG5GjU4cd8Hkm9AZvaZPt0sASS5bjs9tgkQoO7Se9i9y2uM1GqIC5KB8Idr0MfTkv6UtsLt/5yz99m9/eqPWmBby+0jQ86U/2PmmrrBaNZeGetjcZw7pdnwWmk0xWslmrJfy7qzYkfRx9fiIr/jQrw0EzmbkpqIBz8vKiSQUdyXPbhHMGBYeZn0eVhD99oQ1uKzK+V4xurc9enNLJ4U5YKdG9qPovESA4AvwJzVsM6SgruEBDugNoecGBk8ZMZGHZQ5jii0g/rQKOgYLRl8oIL/+gIAzquAg3W9GOIbQLPOFVNOECmvAamnBRi/CzYi8uoz3gCa+jCW+gCVfRhDfRhLfRuzmK9oAnjKMJk+g+TKM94AmzaMI8ug/X0R70CCoPN9Ee9AgqD8toD3oElYdbaA/pBPjfSclmJcfmhf/VyaoOoeWawoMWQdnPNXQVegSVhw20Bz2CysMdtAc9gsrDXbQHPYLKwxbaA55wD31faBGUfdhGV6FHUHm4j/agR1B5eB/tQY+g8vAB2gOe8BB9JrUIyj7k0VXoEVQeTLQHPYLKwy7agx5B5aGI9qBHUHnYR3vAEyz0faFFUPbBRleRThCkWziOtcXdLfWXQzqo9gPu8+qXb5iaKn19YSNpfXXRfdUitPyOJjzHVqHsJL4PHvou0SIod1Ogq9AjqDwcoD3oEVQeymgPegSVhydoD1oE5YnS86Cq4kOdRx2zw18zqL7XT8ekNUOPoCrlqQ4hcxVLUFaRThCkzaJH1V/RNvHxDCj/ATr3v7PLJQAA";
    private static final Log log = LogFactory.getLog(org.chorem.lima.ui.MainView.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JMenuItem about;
    protected javax.swing.JTabbedPane contentTabbedPane;
    protected java.awt.Desktop desktop;
    protected javax.swing.JMenuItem help;
    protected javax.swing.JMenuItem i18n_en;
    protected javax.swing.JMenuItem i18n_fr;
    protected javax.swing.JMenuItem menuFileFullscreen;
    protected javax.swing.JMenuItem menuFileNormalscreen;
    protected javax.swing.JMenuItem site;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private MainView $JFrame0 = this;
    private javax.swing.JMenuBar $JMenuBar0;
    private javax.swing.JMenu $JMenu0;
    private javax.swing.JMenu $JMenu1;
    private javax.swing.JMenu $JMenu2;
    private javax.swing.JMenuItem $JMenuItem0;
    private javax.swing.JMenuItem $JMenuItem1;
    private javax.swing.JMenuItem $JMenuItem2;
    private javax.swing.JMenuItem $JMenuItem3;
    private javax.swing.JMenu $JMenu3;
    private javax.swing.JMenuItem $JMenuItem4;
    private javax.swing.JMenuItem $JMenuItem5;
    private javax.swing.JMenuItem $JMenuItem6;
    private javax.swing.JMenuItem $JMenuItem7;
    private javax.swing.JMenu $JMenu4;
    private javax.swing.JMenu $JMenu5;
    private javax.swing.JMenuItem $JMenuItem8;
    private javax.swing.JMenuItem $JMenuItem9;
    private javax.swing.JMenu $JMenu6;
    private javax.swing.JMenuItem $JMenuItem10;
    private javax.swing.JMenuItem $JMenuItem11;
    private javax.swing.JSeparator $JSeparator0;
    private javax.swing.JMenuItem $JMenuItem12;
    private javax.swing.JSeparator $JSeparator1;
    private javax.swing.JMenuItem $JMenuItem13;
    private javax.swing.JMenuItem $JMenuItem14;
    private javax.swing.JSeparator $JSeparator2;
    private javax.swing.JMenuItem $JMenuItem15;
    private javax.swing.JMenu $JMenu7;
    private javax.swing.JMenuItem $JMenuItem16;
    private javax.swing.JMenuItem $JMenuItem17;
    private javax.swing.JMenuItem $JMenuItem18;
    private javax.swing.JMenuItem $JMenuItem19;
    private javax.swing.JMenuItem $JMenuItem20;
    private javax.swing.JMenu $JMenu8;
    private javax.swing.JMenuItem $JMenuItem21;
    private javax.swing.JMenuItem $JMenuItem22;
    private javax.swing.JMenuItem $JMenuItem23;
    private javax.swing.JMenuItem $JMenuItem24;
    private javax.swing.JMenu $JMenu9;
    private javax.swing.JMenuItem $JMenuItem25;
    private javax.swing.JMenuItem $JMenuItem26;
    private javax.swing.JMenuItem $JMenuItem27;
    private javax.swing.JMenuItem $JMenuItem28;
    private javax.swing.JMenuItem $JMenuItem29;
    private javax.swing.JMenu $JMenu10;
    private javax.swing.JMenu $JMenu11;
    private javax.swing.JMenu $JMenu12;
    private javax.swing.JPanel $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    	public LimaConfig getConfig() {
    	    return getContextValue(LimaConfig.class);
    	}
    
    	public MainViewHandler getHandler() {
    	    return getContextValue(MainViewHandler.class);
    	}
    
    	public boolean acceptLocale(Locale l, String expected) {
    	  return l != null && l.toString().equals(expected);
    	}
       
        public void loadURI(){
    		try {
    		  int port = LimaServiceFactory.getInstance().getService(
                    HttpServerServiceMonitorable.class).getHttpPort();
    		  String address = LimaConfig.getInstance().getHostAdress();
    		  String url = "http://"+address+":"+port+"/";
    		  desktop.browse(new URI(url));
    		} catch (IOException e) {
    		    log.error("Can't open browser",e);
    		} catch (URISyntaxException e) {
    		    log.error("Can't create URI",e);
    		}
        }
    
    /**
     * Show a new closable tab.
     * 
     * @param name      name of tab to show
     * @param container the tab container
     * @param canClose {@code false} if tab can't be closed
     */
    protected void showTab(String name, Component container, boolean canClose) {
        // if contentTabbedPane doesnot yet contains tab
        if (contentTabbedPane.indexOfTab(name) == -1) {
            ClosableTabHeader closableHeader = new ClosableTabHeader();
            closableHeader.setTitle(name);
            closableHeader.setCanClose(canClose);
            contentTabbedPane.addTab(name, container);
            contentTabbedPane.setSelectedComponent(container);
            contentTabbedPane.setTabComponentAt(contentTabbedPane.indexOfTab(name), closableHeader);
            closableHeader.getCloseTab().addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    JButton button = (JButton) e.getSource();
                    ClosableTabHeader closableTab = (ClosableTabHeader) button.getParent();
                    String name = closableTab.getTitle();
                    contentTabbedPane.remove(contentTabbedPane.indexOfTab(name));
                }
            });
        }
    }
    
    /**
     * Show a new closable tab.
     * 
     * @param name      name of tab to show
     * @param container the tab container
     */
    protected void showTab(String name, Component container) {
        showTab(name, container, true);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public MainView() {
        $initialize();
    }

    public MainView(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JMenuItem21(java.awt.event.ActionEvent event) {
        getHandler().showTransactionView(this);
    }

    public void doActionPerformed__on__$JMenuItem20(java.awt.event.ActionEvent event) {
        getHandler().showFinancialStatementView(this);
    }

    public void doActionPerformed__on__$JMenuItem29(java.awt.event.ActionEvent event) {
        getHandler().showFinancialStatementReportsView(this);
    }

    public void doActionPerformed__on__$JMenuItem28(java.awt.event.ActionEvent event) {
        getHandler().showLedgerView(this);
    }

    public void doActionPerformed__on__$JMenuItem27(java.awt.event.ActionEvent event) {
        getHandler().showBalanceView(this);
    }

    public void doActionPerformed__on__$JMenuItem26(java.awt.event.ActionEvent event) {
        getHandler().showEntryBookReports(this);
    }

    public void doActionPerformed__on__$JMenuItem25(java.awt.event.ActionEvent event) {
        getHandler().showAccountReports(this);
    }

    public void doActionPerformed__on__$JMenuItem24(java.awt.event.ActionEvent event) {
        getHandler().showLetteringView(this);
    }

    public void doActionPerformed__on__$JMenuItem23(java.awt.event.ActionEvent event) {
        getHandler().showTransactionSearchView(this);
    }

    public void doActionPerformed__on__$JMenuItem22(java.awt.event.ActionEvent event) {
        getHandler().showTransactionUnbalancedView(this);
    }

    public void doActionPerformed__on__$JMenuItem6(java.awt.event.ActionEvent event) {
        getHandler().showImportExportView(this, ImportExportEnum.CSV_ENTRYBOOKS_EXPORT);
    }

    public void doActionPerformed__on__$JMenuItem7(java.awt.event.ActionEvent event) {
        getHandler().showImportExportView(this, ImportExportEnum.CSV_FINANCIALSTATEMENTS_EXPORT);
    }

    public void doActionPerformed__on__$JMenuItem4(java.awt.event.ActionEvent event) {
        getHandler().showImportExportView(this, ImportExportEnum.CSV_ALL_EXPORT);
    }

    public void doActionPerformed__on__$JMenuItem5(java.awt.event.ActionEvent event) {
        getHandler().showImportExportView(this, ImportExportEnum.CSV_ACCOUNTCHARTS_EXPORT);
    }

    public void doActionPerformed__on__$JMenuItem2(java.awt.event.ActionEvent event) {
        getHandler().showImportExportView(this, ImportExportEnum.CSV_ENTRYBOOKS_IMPORT);
    }

    public void doActionPerformed__on__$JMenuItem3(java.awt.event.ActionEvent event) {
        getHandler().showImportExportView(this, ImportExportEnum.CSV_FINANCIALSTATEMENTS_IMPORT);
    }

    public void doActionPerformed__on__$JMenuItem0(java.awt.event.ActionEvent event) {
        getHandler().showImportExportView(this, ImportExportEnum.CSV_ALL_IMPORT);
    }

    public void doActionPerformed__on__$JMenuItem19(java.awt.event.ActionEvent event) {
        getHandler().showFinancialPeriodView(this);
    }

    public void doActionPerformed__on__$JMenuItem1(java.awt.event.ActionEvent event) {
        getHandler().showImportExportView(this, ImportExportEnum.CSV_ACCOUNTCHARTS_IMPORT);
    }

    public void doActionPerformed__on__$JMenuItem10(java.awt.event.ActionEvent event) {
        getHandler().showImportExportView(this, ImportExportEnum.EBP_ACCOUNTCHARTS_EXPORT);
    }

    public void doActionPerformed__on__$JMenuItem18(java.awt.event.ActionEvent event) {
        getHandler().showFiscalPeriodView(this);
    }

    public void doActionPerformed__on__$JMenuItem17(java.awt.event.ActionEvent event) {
        getHandler().showEntryBookView(this);
    }

    public void doActionPerformed__on__$JMenuItem16(java.awt.event.ActionEvent event) {
        getHandler().showAccountView(this);
    }

    public void doActionPerformed__on__$JMenuItem15(java.awt.event.ActionEvent event) {
        getHandler().close(this);
    }

    public void doActionPerformed__on__$JMenuItem9(java.awt.event.ActionEvent event) {
        getHandler().showImportExportView(this, ImportExportEnum.EBP_ENTRIES_IMPORT);
    }

    public void doActionPerformed__on__$JMenuItem14(java.awt.event.ActionEvent event) {
        getHandler().showConfig(this);
    }

    public void doActionPerformed__on__$JMenuItem8(java.awt.event.ActionEvent event) {
        getHandler().showImportExportView(this, ImportExportEnum.EBP_ACCOUNTCHARTS_IMPORT);
    }

    public void doActionPerformed__on__$JMenuItem13(java.awt.event.ActionEvent event) {
        getHandler().showIdentity(this);
    }

    public void doActionPerformed__on__$JMenuItem12(java.awt.event.ActionEvent event) {
        loadURI();
    }

    public void doActionPerformed__on__$JMenuItem11(java.awt.event.ActionEvent event) {
        getHandler().showImportExportView(this, ImportExportEnum.EBP_ENTRIES_EXPORT);
    }

    public void doActionPerformed__on__about(java.awt.event.ActionEvent event) {
        getHandler().showAbout(this);
    }

    public void doActionPerformed__on__help(java.awt.event.ActionEvent event) {
        getHandler().showHelp(this, null);
    }

    public void doActionPerformed__on__i18n_en(java.awt.event.ActionEvent event) {
        getHandler().changeLanguage(this, Locale.UK);
    }

    public void doActionPerformed__on__i18n_fr(java.awt.event.ActionEvent event) {
        getHandler().changeLanguage(this, Locale.FRANCE);
    }

    public void doActionPerformed__on__menuFileFullscreen(java.awt.event.ActionEvent event) {
        getHandler().changeScreen(this, true);
    }

    public void doActionPerformed__on__menuFileNormalscreen(java.awt.event.ActionEvent event) {
        getHandler().changeScreen(this, false);
    }

    public void doActionPerformed__on__site(java.awt.event.ActionEvent event) {
        getHandler().gotoSite(this);
    }

    public void doWindowClosing__on__$JFrame0(java.awt.event.WindowEvent event) {
        getHandler().close(this);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JMenuItem getAbout() {
        return about;
    }

    public javax.swing.JTabbedPane getContentTabbedPane() {
        return contentTabbedPane;
    }

    public java.awt.Desktop getDesktop() {
        return desktop;
    }

    public javax.swing.JMenuItem getHelp() {
        return help;
    }

    public javax.swing.JMenuItem getI18n_en() {
        return i18n_en;
    }

    public javax.swing.JMenuItem getI18n_fr() {
        return i18n_fr;
    }

    public javax.swing.JMenuItem getMenuFileFullscreen() {
        return menuFileFullscreen;
    }

    public javax.swing.JMenuItem getMenuFileNormalscreen() {
        return menuFileNormalscreen;
    }

    public javax.swing.JMenuItem getSite() {
        return site;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setDesktop(java.awt.Desktop newValue) {
        java.awt.Desktop oldValue = this.desktop;
        this.desktop = newValue;
        firePropertyChange(PROPERTY_DESKTOP, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JMenuBar get$JMenuBar0() {
        return $JMenuBar0;
    }

    protected javax.swing.JMenu get$JMenu0() {
        return $JMenu0;
    }

    protected javax.swing.JMenu get$JMenu1() {
        return $JMenu1;
    }

    protected javax.swing.JMenu get$JMenu2() {
        return $JMenu2;
    }

    protected javax.swing.JMenuItem get$JMenuItem0() {
        return $JMenuItem0;
    }

    protected javax.swing.JMenuItem get$JMenuItem1() {
        return $JMenuItem1;
    }

    protected javax.swing.JMenuItem get$JMenuItem2() {
        return $JMenuItem2;
    }

    protected javax.swing.JMenuItem get$JMenuItem3() {
        return $JMenuItem3;
    }

    protected javax.swing.JMenu get$JMenu3() {
        return $JMenu3;
    }

    protected javax.swing.JMenuItem get$JMenuItem4() {
        return $JMenuItem4;
    }

    protected javax.swing.JMenuItem get$JMenuItem5() {
        return $JMenuItem5;
    }

    protected javax.swing.JMenuItem get$JMenuItem6() {
        return $JMenuItem6;
    }

    protected javax.swing.JMenuItem get$JMenuItem7() {
        return $JMenuItem7;
    }

    protected javax.swing.JMenu get$JMenu4() {
        return $JMenu4;
    }

    protected javax.swing.JMenu get$JMenu5() {
        return $JMenu5;
    }

    protected javax.swing.JMenuItem get$JMenuItem8() {
        return $JMenuItem8;
    }

    protected javax.swing.JMenuItem get$JMenuItem9() {
        return $JMenuItem9;
    }

    protected javax.swing.JMenu get$JMenu6() {
        return $JMenu6;
    }

    protected javax.swing.JMenuItem get$JMenuItem10() {
        return $JMenuItem10;
    }

    protected javax.swing.JMenuItem get$JMenuItem11() {
        return $JMenuItem11;
    }

    protected javax.swing.JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    protected javax.swing.JMenuItem get$JMenuItem12() {
        return $JMenuItem12;
    }

    protected javax.swing.JSeparator get$JSeparator1() {
        return $JSeparator1;
    }

    protected javax.swing.JMenuItem get$JMenuItem13() {
        return $JMenuItem13;
    }

    protected javax.swing.JMenuItem get$JMenuItem14() {
        return $JMenuItem14;
    }

    protected javax.swing.JSeparator get$JSeparator2() {
        return $JSeparator2;
    }

    protected javax.swing.JMenuItem get$JMenuItem15() {
        return $JMenuItem15;
    }

    protected javax.swing.JMenu get$JMenu7() {
        return $JMenu7;
    }

    protected javax.swing.JMenuItem get$JMenuItem16() {
        return $JMenuItem16;
    }

    protected javax.swing.JMenuItem get$JMenuItem17() {
        return $JMenuItem17;
    }

    protected javax.swing.JMenuItem get$JMenuItem18() {
        return $JMenuItem18;
    }

    protected javax.swing.JMenuItem get$JMenuItem19() {
        return $JMenuItem19;
    }

    protected javax.swing.JMenuItem get$JMenuItem20() {
        return $JMenuItem20;
    }

    protected javax.swing.JMenu get$JMenu8() {
        return $JMenu8;
    }

    protected javax.swing.JMenuItem get$JMenuItem21() {
        return $JMenuItem21;
    }

    protected javax.swing.JMenuItem get$JMenuItem22() {
        return $JMenuItem22;
    }

    protected javax.swing.JMenuItem get$JMenuItem23() {
        return $JMenuItem23;
    }

    protected javax.swing.JMenuItem get$JMenuItem24() {
        return $JMenuItem24;
    }

    protected javax.swing.JMenu get$JMenu9() {
        return $JMenu9;
    }

    protected javax.swing.JMenuItem get$JMenuItem25() {
        return $JMenuItem25;
    }

    protected javax.swing.JMenuItem get$JMenuItem26() {
        return $JMenuItem26;
    }

    protected javax.swing.JMenuItem get$JMenuItem27() {
        return $JMenuItem27;
    }

    protected javax.swing.JMenuItem get$JMenuItem28() {
        return $JMenuItem28;
    }

    protected javax.swing.JMenuItem get$JMenuItem29() {
        return $JMenuItem29;
    }

    protected javax.swing.JMenu get$JMenu10() {
        return $JMenu10;
    }

    protected javax.swing.JMenu get$JMenu11() {
        return $JMenu11;
    }

    protected javax.swing.JMenu get$JMenu12() {
        return $JMenu12;
    }

    protected javax.swing.JPanel get$JPanel0() {
        return $JPanel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createAbout() {
        $objectMap.put("about", about = new javax.swing.JMenuItem());
        
        about.setName("about");
        about.setText(_("lima.menu.help.about"));
        about.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__about"));
    }

    protected void createContentTabbedPane() {
        $objectMap.put("contentTabbedPane", contentTabbedPane = new javax.swing.JTabbedPane());
        
        contentTabbedPane.setName("contentTabbedPane");
    }

    protected void createDesktop() {
        $objectMap.put("desktop", desktop = java.awt.Desktop.getDesktop());
    }

    protected void createHelp() {
        $objectMap.put("help", help = new javax.swing.JMenuItem());
        
        help.setName("help");
        help.setText(_("lima.menu.help.help"));
        help.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__help"));
    }

    protected void createI18n_en() {
        $objectMap.put("i18n_en", i18n_en = new javax.swing.JMenuItem());
        
        i18n_en.setName("i18n_en");
        i18n_en.setText(_("lima.menu.help.i18n.uk"));
        i18n_en.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__i18n_en"));
    }

    protected void createI18n_fr() {
        $objectMap.put("i18n_fr", i18n_fr = new javax.swing.JMenuItem());
        
        i18n_fr.setName("i18n_fr");
        i18n_fr.setText(_("lima.menu.help.i18n.fr"));
        i18n_fr.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__i18n_fr"));
    }

    protected void createMenuFileFullscreen() {
        $objectMap.put("menuFileFullscreen", menuFileFullscreen = new javax.swing.JMenuItem());
        
        menuFileFullscreen.setName("menuFileFullscreen");
        menuFileFullscreen.setText(_("lima.action.fullscreen"));
        menuFileFullscreen.setToolTipText(_("lima.action.fullscreen.tip"));
        menuFileFullscreen.setMnemonic(80);
        menuFileFullscreen.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileFullscreen"));
    }

    protected void createMenuFileNormalscreen() {
        $objectMap.put("menuFileNormalscreen", menuFileNormalscreen = new javax.swing.JMenuItem());
        
        menuFileNormalscreen.setName("menuFileNormalscreen");
        menuFileNormalscreen.setText(_("lima.action.normalscreen"));
        menuFileNormalscreen.setToolTipText(_("lima.action.normalscreen.tip"));
        menuFileNormalscreen.setMnemonic(78);
        menuFileNormalscreen.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileNormalscreen"));
    }

    protected void createSite() {
        $objectMap.put("site", site = new javax.swing.JMenuItem());
        
        site.setName("site");
        site.setText(_("lima.menu.help.site"));
        site.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__site"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $JFrame0
        add($JPanel0);
        $JFrame0.setJMenuBar($JMenuBar0);
        // inline complete setup of $JMenuBar0
        $JMenuBar0.add($JMenu0);
        $JMenuBar0.add($JMenu7);
        $JMenuBar0.add($JMenu8);
        $JMenuBar0.add($JMenu9);
        $JMenuBar0.add($JMenu10);
        $JMenuBar0.add($JMenu11);
        // inline complete setup of $JMenu0
        $JMenu0.add($JMenu1);
        $JMenu0.add($JMenu4);
        $JMenu0.add($JSeparator0);
        $JMenu0.add($JMenuItem12);
        $JMenu0.add($JSeparator1);
        $JMenu0.add($JMenuItem13);
        $JMenu0.add($JMenuItem14);
        $JMenu0.add($JSeparator2);
        $JMenu0.add($JMenuItem15);
        // inline complete setup of $JMenu1
        $JMenu1.add($JMenu2);
        $JMenu1.add($JMenu3);
        // inline complete setup of $JMenu2
        $JMenu2.add($JMenuItem0);
        $JMenu2.add($JMenuItem1);
        $JMenu2.add($JMenuItem2);
        $JMenu2.add($JMenuItem3);
        // inline complete setup of $JMenu3
        $JMenu3.add($JMenuItem4);
        $JMenu3.add($JMenuItem5);
        $JMenu3.add($JMenuItem6);
        $JMenu3.add($JMenuItem7);
        // inline complete setup of $JMenu4
        $JMenu4.add($JMenu5);
        $JMenu4.add($JMenu6);
        // inline complete setup of $JMenu5
        $JMenu5.add($JMenuItem8);
        $JMenu5.add($JMenuItem9);
        // inline complete setup of $JMenu6
        $JMenu6.add($JMenuItem10);
        $JMenu6.add($JMenuItem11);
        // inline complete setup of $JMenu7
        $JMenu7.add($JMenuItem16);
        $JMenu7.add($JMenuItem17);
        $JMenu7.add($JMenuItem18);
        $JMenu7.add($JMenuItem19);
        $JMenu7.add($JMenuItem20);
        // inline complete setup of $JMenu8
        $JMenu8.add($JMenuItem21);
        $JMenu8.add($JMenuItem22);
        $JMenu8.add($JMenuItem23);
        $JMenu8.add($JMenuItem24);
        // inline complete setup of $JMenu9
        $JMenu9.add($JMenuItem25);
        $JMenu9.add($JMenuItem26);
        $JMenu9.add($JMenuItem27);
        $JMenu9.add($JMenuItem28);
        $JMenu9.add($JMenuItem29);
        // inline complete setup of $JMenu10
        $JMenu10.add(menuFileFullscreen);
        $JMenu10.add(menuFileNormalscreen);
        // inline complete setup of $JMenu11
        $JMenu11.add(help);
        $JMenu11.add(site);
        $JMenu11.add(about);
        $JMenu11.add($JMenu12);
        // inline complete setup of $JMenu12
        $JMenu12.add(i18n_fr);
        $JMenu12.add(i18n_en);
        // inline complete setup of $JPanel0
        $JPanel0.add(contentTabbedPane, BorderLayout.CENTER);
        
        // apply 5 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 40 property setters
        setExtendedState(this.MAXIMIZED_BOTH);
        setIconImage(new ImageIcon(getClass().getResource("/images/puzzle_icon.png")).getImage());
        $JMenu2.setIcon(jaxx.runtime.SwingUtil.createActionIcon("import-element"));
        $JMenu3.setIcon(jaxx.runtime.SwingUtil.createActionIcon("export-element"));
        $JMenu5.setIcon(jaxx.runtime.SwingUtil.createActionIcon("import-element"));
        $JMenu6.setIcon(jaxx.runtime.SwingUtil.createActionIcon("export-element"));
        $JMenuItem12.setIcon(jaxx.runtime.SwingUtil.createActionIcon("documents"));
        $JMenuItem13.setIcon(jaxx.runtime.SwingUtil.createActionIcon("identity"));
        $JMenuItem14.setIcon(jaxx.runtime.SwingUtil.createActionIcon("config"));
        $JMenuItem15.setIcon(jaxx.runtime.SwingUtil.createActionIcon("quit"));
        $JMenuItem15.setMnemonic('Q');
        $JMenu7.setMnemonic('S');
        $JMenuItem16.setIcon(jaxx.runtime.SwingUtil.createActionIcon("charts-accounts"));
        $JMenuItem17.setIcon(jaxx.runtime.SwingUtil.createActionIcon("charts-entrybooks"));
        $JMenuItem18.setIcon(jaxx.runtime.SwingUtil.createActionIcon("charts-fiscalperiod"));
        $JMenuItem19.setIcon(jaxx.runtime.SwingUtil.createActionIcon("charts-financialperiod"));
        $JMenuItem20.setIcon(jaxx.runtime.SwingUtil.createActionIcon("charts-financialstatements"));
        $JMenu8.setMnemonic('E');
        $JMenuItem21.setIcon(jaxx.runtime.SwingUtil.createActionIcon("entries-balanced"));
        $JMenuItem22.setIcon(jaxx.runtime.SwingUtil.createActionIcon("entries-unbalanced"));
        $JMenuItem23.setIcon(jaxx.runtime.SwingUtil.createActionIcon("entries-search"));
        $JMenuItem24.setIcon(jaxx.runtime.SwingUtil.createActionIcon("lettering"));
        $JMenu9.setMnemonic('R');
        $JMenuItem25.setIcon(jaxx.runtime.SwingUtil.createActionIcon("reports-account"));
        $JMenuItem26.setIcon(jaxx.runtime.SwingUtil.createActionIcon("reports-entrybook"));
        $JMenuItem27.setIcon(jaxx.runtime.SwingUtil.createActionIcon("reports-balance"));
        $JMenuItem28.setIcon(jaxx.runtime.SwingUtil.createActionIcon("reports-ledger"));
        $JMenuItem29.setIcon(jaxx.runtime.SwingUtil.createActionIcon("reports-financialstatement"));
        $JMenu10.setMnemonic('W');
        menuFileFullscreen.setIcon(jaxx.runtime.SwingUtil.createActionIcon("fullscreen"));
        menuFileNormalscreen.setIcon(jaxx.runtime.SwingUtil.createActionIcon("leave-fullscreen"));
        $JMenu11.setMnemonic('H');
        help.setIcon(jaxx.runtime.SwingUtil.createActionIcon("help"));
        site.setIcon(jaxx.runtime.SwingUtil.createActionIcon("site"));
        about.setIcon(jaxx.runtime.SwingUtil.createActionIcon("about"));
        $JMenu12.setIcon(jaxx.runtime.SwingUtil.createActionIcon("translate"));
        $JMenu12.setMnemonic('L');
        i18n_fr.setIcon(jaxx.runtime.SwingUtil.createActionIcon("i18n-fr"));
        i18n_en.setIcon(jaxx.runtime.SwingUtil.createActionIcon("i18n-uk"));
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$JFrame0", this);
        createDesktop();
        // inline creation of $JMenuBar0
        $objectMap.put("$JMenuBar0", $JMenuBar0 = new javax.swing.JMenuBar());
        
        $JMenuBar0.setName("$JMenuBar0");
        // inline creation of $JMenu0
        $objectMap.put("$JMenu0", $JMenu0 = new javax.swing.JMenu());
        
        $JMenu0.setName("$JMenu0");
        $JMenu0.setText(_("lima.menu.file"));
        // inline creation of $JMenu1
        $objectMap.put("$JMenu1", $JMenu1 = new javax.swing.JMenu());
        
        $JMenu1.setName("$JMenu1");
        $JMenu1.setText(_("lima.importexport.csv"));
        // inline creation of $JMenu2
        $objectMap.put("$JMenu2", $JMenu2 = new javax.swing.JMenu());
        
        $JMenu2.setName("$JMenu2");
        $JMenu2.setText(_("lima.importexport.import"));
        // inline creation of $JMenuItem0
        $objectMap.put("$JMenuItem0", $JMenuItem0 = new javax.swing.JMenuItem());
        
        $JMenuItem0.setName("$JMenuItem0");
        $JMenuItem0.setText(_("lima.importexport.all"));
        $JMenuItem0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem0"));
        // inline creation of $JMenuItem1
        $objectMap.put("$JMenuItem1", $JMenuItem1 = new javax.swing.JMenuItem());
        
        $JMenuItem1.setName("$JMenuItem1");
        $JMenuItem1.setText(_("lima.importexport.accountcharts"));
        $JMenuItem1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem1"));
        // inline creation of $JMenuItem2
        $objectMap.put("$JMenuItem2", $JMenuItem2 = new javax.swing.JMenuItem());
        
        $JMenuItem2.setName("$JMenuItem2");
        $JMenuItem2.setText(_("lima.common.entrybooks"));
        $JMenuItem2.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem2"));
        // inline creation of $JMenuItem3
        $objectMap.put("$JMenuItem3", $JMenuItem3 = new javax.swing.JMenuItem());
        
        $JMenuItem3.setName("$JMenuItem3");
        $JMenuItem3.setText(_("lima.importexport.financialstatements"));
        $JMenuItem3.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem3"));
        // inline creation of $JMenu3
        $objectMap.put("$JMenu3", $JMenu3 = new javax.swing.JMenu());
        
        $JMenu3.setName("$JMenu3");
        $JMenu3.setText(_("lima.importexport.export"));
        // inline creation of $JMenuItem4
        $objectMap.put("$JMenuItem4", $JMenuItem4 = new javax.swing.JMenuItem());
        
        $JMenuItem4.setName("$JMenuItem4");
        $JMenuItem4.setText(_("lima.importexport.all"));
        $JMenuItem4.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem4"));
        // inline creation of $JMenuItem5
        $objectMap.put("$JMenuItem5", $JMenuItem5 = new javax.swing.JMenuItem());
        
        $JMenuItem5.setName("$JMenuItem5");
        $JMenuItem5.setText(_("lima.importexport.accountcharts"));
        $JMenuItem5.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem5"));
        // inline creation of $JMenuItem6
        $objectMap.put("$JMenuItem6", $JMenuItem6 = new javax.swing.JMenuItem());
        
        $JMenuItem6.setName("$JMenuItem6");
        $JMenuItem6.setText(_("lima.common.entrybooks"));
        $JMenuItem6.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem6"));
        // inline creation of $JMenuItem7
        $objectMap.put("$JMenuItem7", $JMenuItem7 = new javax.swing.JMenuItem());
        
        $JMenuItem7.setName("$JMenuItem7");
        $JMenuItem7.setText(_("lima.importexport.financialstatements"));
        $JMenuItem7.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem7"));
        // inline creation of $JMenu4
        $objectMap.put("$JMenu4", $JMenu4 = new javax.swing.JMenu());
        
        $JMenu4.setName("$JMenu4");
        $JMenu4.setText(_("lima.importexport.ebp"));
        // inline creation of $JMenu5
        $objectMap.put("$JMenu5", $JMenu5 = new javax.swing.JMenu());
        
        $JMenu5.setName("$JMenu5");
        $JMenu5.setText(_("lima.importexport.import"));
        // inline creation of $JMenuItem8
        $objectMap.put("$JMenuItem8", $JMenuItem8 = new javax.swing.JMenuItem());
        
        $JMenuItem8.setName("$JMenuItem8");
        $JMenuItem8.setText(_("lima.importexport.accountcharts"));
        $JMenuItem8.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem8"));
        // inline creation of $JMenuItem9
        $objectMap.put("$JMenuItem9", $JMenuItem9 = new javax.swing.JMenuItem());
        
        $JMenuItem9.setName("$JMenuItem9");
        $JMenuItem9.setText(_("lima.importexport.entries"));
        $JMenuItem9.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem9"));
        // inline creation of $JMenu6
        $objectMap.put("$JMenu6", $JMenu6 = new javax.swing.JMenu());
        
        $JMenu6.setName("$JMenu6");
        $JMenu6.setText(_("lima.importexport.export"));
        // inline creation of $JMenuItem10
        $objectMap.put("$JMenuItem10", $JMenuItem10 = new javax.swing.JMenuItem());
        
        $JMenuItem10.setName("$JMenuItem10");
        $JMenuItem10.setText(_("lima.importexport.accountcharts"));
        $JMenuItem10.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem10"));
        // inline creation of $JMenuItem11
        $objectMap.put("$JMenuItem11", $JMenuItem11 = new javax.swing.JMenuItem());
        
        $JMenuItem11.setName("$JMenuItem11");
        $JMenuItem11.setText(_("lima.importexport.entries"));
        $JMenuItem11.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem11"));
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new javax.swing.JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        // inline creation of $JMenuItem12
        $objectMap.put("$JMenuItem12", $JMenuItem12 = new javax.swing.JMenuItem());
        
        $JMenuItem12.setName("$JMenuItem12");
        $JMenuItem12.setText(_("lima.documents"));
        $JMenuItem12.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem12"));
        // inline creation of $JSeparator1
        $objectMap.put("$JSeparator1", $JSeparator1 = new javax.swing.JSeparator());
        
        $JSeparator1.setName("$JSeparator1");
        // inline creation of $JMenuItem13
        $objectMap.put("$JMenuItem13", $JMenuItem13 = new javax.swing.JMenuItem());
        
        $JMenuItem13.setName("$JMenuItem13");
        $JMenuItem13.setText(_("lima.identity"));
        $JMenuItem13.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem13"));
        // inline creation of $JMenuItem14
        $objectMap.put("$JMenuItem14", $JMenuItem14 = new javax.swing.JMenuItem());
        
        $JMenuItem14.setName("$JMenuItem14");
        $JMenuItem14.setText(_("lima.preferences"));
        $JMenuItem14.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem14"));
        // inline creation of $JSeparator2
        $objectMap.put("$JSeparator2", $JSeparator2 = new javax.swing.JSeparator());
        
        $JSeparator2.setName("$JSeparator2");
        // inline creation of $JMenuItem15
        $objectMap.put("$JMenuItem15", $JMenuItem15 = new javax.swing.JMenuItem());
        
        $JMenuItem15.setName("$JMenuItem15");
        $JMenuItem15.setText(_("lima.common.quit"));
        $JMenuItem15.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem15"));
        // inline creation of $JMenu7
        $objectMap.put("$JMenu7", $JMenu7 = new javax.swing.JMenu());
        
        $JMenu7.setName("$JMenu7");
        $JMenu7.setText(_("lima.structure"));
        // inline creation of $JMenuItem16
        $objectMap.put("$JMenuItem16", $JMenuItem16 = new javax.swing.JMenuItem());
        
        $JMenuItem16.setName("$JMenuItem16");
        $JMenuItem16.setText(_("lima.charts.account"));
        $JMenuItem16.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem16"));
        // inline creation of $JMenuItem17
        $objectMap.put("$JMenuItem17", $JMenuItem17 = new javax.swing.JMenuItem());
        
        $JMenuItem17.setName("$JMenuItem17");
        $JMenuItem17.setText(_("lima.common.entrybooks"));
        $JMenuItem17.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem17"));
        // inline creation of $JMenuItem18
        $objectMap.put("$JMenuItem18", $JMenuItem18 = new javax.swing.JMenuItem());
        
        $JMenuItem18.setName("$JMenuItem18");
        $JMenuItem18.setText(_("lima.charts.fiscalyear"));
        $JMenuItem18.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem18"));
        // inline creation of $JMenuItem19
        $objectMap.put("$JMenuItem19", $JMenuItem19 = new javax.swing.JMenuItem());
        
        $JMenuItem19.setName("$JMenuItem19");
        $JMenuItem19.setText(_("lima.charts.financialperiod"));
        $JMenuItem19.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem19"));
        // inline creation of $JMenuItem20
        $objectMap.put("$JMenuItem20", $JMenuItem20 = new javax.swing.JMenuItem());
        
        $JMenuItem20.setName("$JMenuItem20");
        $JMenuItem20.setText(_("lima.charts.financialstatement"));
        $JMenuItem20.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem20"));
        // inline creation of $JMenu8
        $objectMap.put("$JMenu8", $JMenu8 = new javax.swing.JMenu());
        
        $JMenu8.setName("$JMenu8");
        $JMenu8.setText(_("lima.entries"));
        // inline creation of $JMenuItem21
        $objectMap.put("$JMenuItem21", $JMenuItem21 = new javax.swing.JMenuItem());
        
        $JMenuItem21.setName("$JMenuItem21");
        $JMenuItem21.setText(_("lima.entries.writetransaction"));
        $JMenuItem21.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem21"));
        // inline creation of $JMenuItem22
        $objectMap.put("$JMenuItem22", $JMenuItem22 = new javax.swing.JMenuItem());
        
        $JMenuItem22.setName("$JMenuItem22");
        $JMenuItem22.setText(_("lima.entries.searchunbalancedtransaction"));
        $JMenuItem22.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem22"));
        // inline creation of $JMenuItem23
        $objectMap.put("$JMenuItem23", $JMenuItem23 = new javax.swing.JMenuItem());
        
        $JMenuItem23.setName("$JMenuItem23");
        $JMenuItem23.setText(_("lima.entries.searchtransaction"));
        $JMenuItem23.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem23"));
        // inline creation of $JMenuItem24
        $objectMap.put("$JMenuItem24", $JMenuItem24 = new javax.swing.JMenuItem());
        
        $JMenuItem24.setName("$JMenuItem24");
        $JMenuItem24.setText(_("lima.entries.lettering"));
        $JMenuItem24.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem24"));
        // inline creation of $JMenu9
        $objectMap.put("$JMenu9", $JMenu9 = new javax.swing.JMenu());
        
        $JMenu9.setName("$JMenu9");
        $JMenu9.setText(_("lima.reports"));
        // inline creation of $JMenuItem25
        $objectMap.put("$JMenuItem25", $JMenuItem25 = new javax.swing.JMenuItem());
        
        $JMenuItem25.setName("$JMenuItem25");
        $JMenuItem25.setText(_("lima.reports.accounts"));
        $JMenuItem25.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem25"));
        // inline creation of $JMenuItem26
        $objectMap.put("$JMenuItem26", $JMenuItem26 = new javax.swing.JMenuItem());
        
        $JMenuItem26.setName("$JMenuItem26");
        $JMenuItem26.setText(_("lima.reports.entrybooks"));
        $JMenuItem26.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem26"));
        // inline creation of $JMenuItem27
        $objectMap.put("$JMenuItem27", $JMenuItem27 = new javax.swing.JMenuItem());
        
        $JMenuItem27.setName("$JMenuItem27");
        $JMenuItem27.setText(_("lima.reports.balance"));
        $JMenuItem27.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem27"));
        // inline creation of $JMenuItem28
        $objectMap.put("$JMenuItem28", $JMenuItem28 = new javax.swing.JMenuItem());
        
        $JMenuItem28.setName("$JMenuItem28");
        $JMenuItem28.setText(_("lima.reports.ledger"));
        $JMenuItem28.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem28"));
        // inline creation of $JMenuItem29
        $objectMap.put("$JMenuItem29", $JMenuItem29 = new javax.swing.JMenuItem());
        
        $JMenuItem29.setName("$JMenuItem29");
        $JMenuItem29.setText(_("lima.reports.financialstatement"));
        $JMenuItem29.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem29"));
        // inline creation of $JMenu10
        $objectMap.put("$JMenu10", $JMenu10 = new javax.swing.JMenu());
        
        $JMenu10.setName("$JMenu10");
        $JMenu10.setText(_("lima.menu.window"));
        createMenuFileFullscreen();
        createMenuFileNormalscreen();
        // inline creation of $JMenu11
        $objectMap.put("$JMenu11", $JMenu11 = new javax.swing.JMenu());
        
        $JMenu11.setName("$JMenu11");
        $JMenu11.setText(_("lima.menu.help"));
        createHelp();
        createSite();
        createAbout();
        // inline creation of $JMenu12
        $objectMap.put("$JMenu12", $JMenu12 = new javax.swing.JMenu());
        
        $JMenu12.setName("$JMenu12");
        $JMenu12.setText(_("lima.menu.help.i18n"));
        createI18n_fr();
        createI18n_en();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new javax.swing.JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        createContentTabbedPane();
        // inline creation of $JFrame0
        setName("$JFrame0");
        setDefaultCloseOperation(0);
        SwingUtil.setComponentHeight($JFrame0,600);
        setResizable(true);
        setTitle(_("lima.title"));
        SwingUtil.setComponentWidth($JFrame0,800);
        $JFrame0.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__$JFrame0"));
        
        // registers 5 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 5 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JFRAME0_UNDECORATED, true) {
        
            @Override
            public void applyDataBinding() {
                if (getConfig() != null) {
                    getConfig().addPropertyChangeListener("fullScreen", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getConfig() != null) {
                    setUndecorated(getConfig().isFullScreen());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getConfig() != null) {
                    getConfig().removePropertyChangeListener("fullScreen", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MENU_FILE_FULLSCREEN_VISIBLE, true ,"undecorated") {
        
            @Override
            public void processDataBinding() {
                menuFileFullscreen.setVisible(!isUndecorated());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MENU_FILE_NORMALSCREEN_VISIBLE, true ,"undecorated") {
        
            @Override
            public void processDataBinding() {
                menuFileNormalscreen.setVisible(isUndecorated());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_I18N_FR_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (getConfig() != null) {
                    getConfig().addPropertyChangeListener("locale", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getConfig() != null) {
                    i18n_fr.setEnabled(!acceptLocale(getConfig().getLocale(), "fr_FR"));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getConfig() != null) {
                    getConfig().removePropertyChangeListener("locale", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_I18N_EN_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (getConfig() != null) {
                    getConfig().addPropertyChangeListener("locale", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getConfig() != null) {
                    i18n_en.setEnabled(!acceptLocale(getConfig().getLocale(), "en_GB"));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getConfig() != null) {
                    getConfig().removePropertyChangeListener("locale", this);
                }
            }
        });
    }

}