/*
 * #%L
 * Lima Swing
 * 
 * $Id: MiscAction.java 3049 2010-11-29 14:34:09Z echatellier $
 * $HeadURL: http://svn.chorem.org/svn/lima/tags/lima-0.4.3/lima-swing/src/main/java/org/chorem/lima/actions/MiscAction.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.actions;

import static org.nuiton.i18n.I18n._;

import org.chorem.lima.LimaConfig;
import org.chorem.lima.LimaMain;

/**
 * Les actions appellables via {@link LimaMain}.
 *
 * @author tony
 * @version $Revision: 3049 $
 * 
 * Last update : $Date: 2010-11-29 15:34:09 +0100 (lun., 29 nov. 2010) $
 * By : $Author: echatellier $
 */
public class MiscAction {

    /** La configuration de l'application. */
    protected LimaConfig config;

    public MiscAction(LimaConfig config) {
        this.config = config;
    }

    public void help() {
        System.out.println(_("lima.message.help.usage"));
        for (LimaConfig.Option o : LimaConfig.Option.values()) {
            System.out.println("\t" + o.key + "(" + o.defaultValue + "):" + o.description);
        }

        System.out.println("Actions:");
        for (LimaConfig.Action a : LimaConfig.Action.values()) {
            System.out.println("\t" + java.util.Arrays.toString(a.aliases) + "(" + a.action + "):" + a.description);
        }
    }
}
