/* *##%
 Copyright (C) 2009 Callao
 *##%*/
package org.chorem.callao.entity;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

/**
 * Implantation POJO pour l'entité {@link CallaoUser}.
 */
public abstract class CallaoUserAbstract extends TopiaEntityAbstract implements CallaoUser {

    private int userID;

    private String login;

    private String password;

    private int right;

    /**
     * Constructeur de CallaoUserAbstract par défaut.
     */
    public CallaoUserAbstract() {
    }

    @Override
    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(CallaoUser.class).update(this);
    }

    @Override
    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(CallaoUser.class).delete(this);
    }

    /**
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
     * avec leur nom, type et valeur.
     *
     * @param visitor le visiteur de l'entite.
     *
     * @throws TopiaException if any pb while visit 
     */
    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, "userID", int.class, userID);
        visitor.visit(this, "login", String.class, login);
        visitor.visit(this, "password", String.class, password);
        visitor.visit(this, "right", int.class, right);
        visitor.end(this);
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur 
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur 
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) { 
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        
        return result;
    }

    /* (non-Javadoc)
     * @see CallaoUser#setUserID(int)
     */
    @Override
    public void setUserID(int value) {
        int _oldValue = this.userID;
        fireOnPreWrite("userID", _oldValue, value);
        this.userID = value;
        fireOnPostWrite("userID", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see CallaoUser#getUserID()
     */
    @Override
    public int getUserID() {
        fireOnPreRead("userID", userID);
        int result = this.userID;
        fireOnPostRead("userID", userID);
        return result;
    }

    /* (non-Javadoc)
     * @see CallaoUser#setLogin(String)
     */
    @Override
    public void setLogin(String value) {
        String _oldValue = this.login;
        fireOnPreWrite("login", _oldValue, value);
        this.login = value;
        fireOnPostWrite("login", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see CallaoUser#getLogin()
     */
    @Override
    public String getLogin() {
        fireOnPreRead("login", login);
        String result = this.login;
        fireOnPostRead("login", login);
        return result;
    }

    /* (non-Javadoc)
     * @see CallaoUser#setPassword(String)
     */
    @Override
    public void setPassword(String value) {
        String _oldValue = this.password;
        fireOnPreWrite("password", _oldValue, value);
        this.password = value;
        fireOnPostWrite("password", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see CallaoUser#getPassword()
     */
    @Override
    public String getPassword() {
        fireOnPreRead("password", password);
        String result = this.password;
        fireOnPostRead("password", password);
        return result;
    }

    /* (non-Javadoc)
     * @see CallaoUser#setRight(int)
     */
    @Override
    public void setRight(int value) {
        int _oldValue = this.right;
        fireOnPreWrite("right", _oldValue, value);
        this.right = value;
        fireOnPostWrite("right", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see CallaoUser#getRight()
     */
    @Override
    public int getRight() {
        fireOnPreRead("right", right);
        int result = this.right;
        fireOnPostRead("right", right);
        return result;
    }

    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append("userID", this.userID).
            append("login", this.login).
            append("password", this.password).
            append("right", this.right).
         toString();
        return result;
    }
        
} //CallaoUserAbstract
