/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.test.cluster;

import java.io.StringWriter;
import org.alfresco.jlan.client.DiskSession;
import org.alfresco.jlan.client.SMBFile;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.server.config.InvalidConfigurationException;
import org.alfresco.jlan.smb.SMBException;
import org.alfresco.jlan.test.cluster.BooleanTestResult;
import org.alfresco.jlan.test.cluster.ExceptionTestResult;
import org.alfresco.jlan.test.cluster.Test;
import org.alfresco.jlan.test.cluster.TestResult;
import org.alfresco.jlan.util.MemorySize;
import org.springframework.extensions.config.ConfigElement;

public class PerfDataTransferTest
extends Test {
    private static final long DefaultFileSize = 524288000L;
    private static final int DefaultWriteSize = 32768;
    private static final long MinimumFileSize = 0x3200000L;
    private static final long MaximumFileSize = 0x50000000000L;
    private static final int MinimumWriteSize = 128;
    private static final int MaximumWriteSize = 65536;
    private long m_fileSize = 524288000L;
    private int m_writeSize = 32768;

    public PerfDataTransferTest() {
        super("PerfDataTransfer");
    }

    @Override
    public void configTest(ConfigElement config) throws InvalidConfigurationException {
        String valueStr = config.getAttribute("fileSize");
        if (valueStr != null) {
            try {
                this.m_fileSize = MemorySize.getByteValue(valueStr);
                if (this.m_fileSize < 0x3200000L || this.m_fileSize > 0x50000000000L) {
                    throw new InvalidConfigurationException("Invalid file size (52428800 - 5497558138880)");
                }
            }
            catch (NumberFormatException ex) {
                throw new InvalidConfigurationException("Invalid file size, " + valueStr);
            }
        }
        if ((valueStr = config.getAttribute("writeSize")) != null) {
            try {
                this.m_writeSize = MemorySize.getByteValueInt(valueStr);
                if (this.m_writeSize < 128 || this.m_writeSize > 65536) {
                    throw new InvalidConfigurationException("Invalid write buffer size (128 - 65536)");
                }
            }
            catch (NumberFormatException ex) {
                throw new InvalidConfigurationException("Invalid write buffer size, " + valueStr);
            }
        }
    }

    @Override
    public TestResult runTest(int threadId, int iteration, DiskSession sess, StringWriter log) {
        if (threadId > 1) {
            return new BooleanTestResult(true);
        }
        TestResult result = null;
        try {
            String testFileName = this.getPerTestFileName(threadId, iteration);
            this.testLog(log, "Data Transfer Performance Test");
            if (sess.FileExists(testFileName)) {
                this.testLog(log, "File " + testFileName + " exists");
                result = new BooleanTestResult(true, "File already exists, " + testFileName);
            } else {
                byte[] ioBuf = new byte[this.m_writeSize];
                long startTime = System.currentTimeMillis();
                long endTime = 0L;
                try {
                    SMBFile testFile = sess.CreateFile(testFileName);
                    for (long fileSize = 0L; fileSize < this.m_fileSize; fileSize += (long)ioBuf.length) {
                        testFile.Write(ioBuf, ioBuf.length, 0);
                    }
                    testFile.Flush();
                    testFile.Close();
                    endTime = System.currentTimeMillis();
                    if (result == null) {
                        long elapsedMs = endTime - startTime;
                        int ms = (int)(elapsedMs % 1000L);
                        long elapsedSecs = elapsedMs / 1000L;
                        int secs = (int)(elapsedSecs % 60L);
                        int mins = (int)(elapsedSecs / 60L % 60L);
                        int hrs = (int)(elapsedSecs / 3600L);
                        long throughput = this.m_fileSize / elapsedSecs;
                        this.testLog(log, "Created " + testFileName + " (size " + MemorySize.asScaledString(this.m_fileSize) + "/writes " + MemorySize.asScaledString(this.m_writeSize) + ") in " + hrs + ":" + mins + ":" + secs + "." + ms + " (" + elapsedMs + "ms) with average speed of " + MemorySize.asScaledString(throughput) + "/sec");
                        result = new BooleanTestResult(true);
                    }
                }
                catch (SMBException ex) {
                    result = new ExceptionTestResult(ex);
                }
            }
            this.testLog(log, "Test completed");
        }
        catch (Exception ex) {
            Debug.println(ex);
            result = new ExceptionTestResult(ex);
        }
        return result;
    }

    @Override
    public void cleanupTest(int threadId, int iter, DiskSession sess, StringWriter log) throws Exception {
        if (threadId == 1) {
            String fName = this.getPerTestFileName(threadId, iter);
            this.testLog(log, "Cleanup test file " + fName);
            if (sess.FileExists(fName)) {
                sess.DeleteFile(fName);
            }
        }
    }
}

