/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.smb.server;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import org.alfresco.jlan.smb.server.CIFSPacketPool;
import org.alfresco.jlan.smb.server.PacketHandler;

public abstract class SocketPacketHandler
extends PacketHandler {
    private Socket m_socket;
    private DataInputStream m_in;
    private DataOutputStream m_out;

    public SocketPacketHandler(Socket sock, int typ, String name, String shortName, CIFSPacketPool packetPool) throws IOException {
        super(typ, name, shortName, packetPool);
        this.m_socket = sock;
        sock.setTcpNoDelay(true);
        this.m_in = new DataInputStream(this.m_socket.getInputStream());
        this.m_out = new DataOutputStream(this.m_socket.getOutputStream());
        this.setRemoteAddress(this.m_socket.getInetAddress());
    }

    @Override
    public int availableBytes() throws IOException {
        if (this.m_in != null) {
            return this.m_in.available();
        }
        return 0;
    }

    protected int readBytes(byte[] buf, int offset, int len) throws IOException {
        if (this.m_in != null) {
            return this.m_in.read(buf, offset, len);
        }
        return 0;
    }

    protected void writeBytes(byte[] pkt, int off, int len) throws IOException {
        if (this.m_out != null) {
            this.m_out.write(pkt, off, len);
        }
    }

    @Override
    public void flushPacket() throws IOException {
        if (this.m_out != null) {
            this.m_out.flush();
        }
    }

    @Override
    public void closeHandler() {
        if (this.m_in != null) {
            try {
                this.m_in.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.m_in = null;
        }
        if (this.m_out != null) {
            try {
                this.m_out.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.m_out = null;
        }
        if (this.m_socket != null) {
            try {
                this.m_socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_socket = null;
        }
    }
}

