/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.filesys.loader;

import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.server.filesys.DiskInterface;
import org.alfresco.jlan.server.filesys.NetworkFile;
import org.alfresco.jlan.server.filesys.TreeConnection;

public class WriteRequest {
    private NetworkFile m_file;
    private TreeConnection m_conn;
    private DiskInterface m_disk;
    private int m_writeLen;
    private long m_writeOff;
    private byte[] m_buffer;
    private int m_dataOff;

    public WriteRequest(NetworkFile file, TreeConnection tree, DiskInterface disk, int writeLen, long writeOff, byte[] data, int dataOff) {
        this.m_file = file;
        this.m_conn = tree;
        this.m_disk = disk;
        this.m_writeLen = writeLen;
        this.m_writeOff = writeOff;
        this.m_buffer = data;
        this.m_dataOff = dataOff;
    }

    public final NetworkFile getFile() {
        return this.m_file;
    }

    public final TreeConnection getConnection() {
        return this.m_conn;
    }

    public final DiskInterface getDisk() {
        return this.m_disk;
    }

    public final int getWriteLength() {
        return this.m_writeLen;
    }

    public final long getWriteOffset() {
        return this.m_writeOff;
    }

    public final byte[] getBuffer() {
        return this.m_buffer;
    }

    public final int getDataOffset() {
        return this.m_dataOff;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int doWrite() {
        int wlen = -1;
        try {
            NetworkFile networkFile = this.m_file;
            synchronized (networkFile) {
                this.m_file.openFile(false);
                wlen = this.m_disk.writeFile(null, this.m_conn, this.m_file, this.m_buffer, this.m_dataOff, this.m_writeLen, this.m_writeOff);
                this.m_file.closeFile();
            }
        }
        catch (Exception ex) {
            Debug.println("ThreadedWriter error=" + ex.toString());
            wlen = -1;
        }
        if (wlen == -1) {
            this.m_file.setDelayedWriteError(true);
        } else {
            this.m_file.incrementWriteCount();
        }
        return wlen;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[");
        str.append(this.getFile().getFullName());
        str.append(":wlen=");
        str.append(this.getWriteLength());
        str.append(",woff=");
        str.append(this.getWriteOffset());
        str.append("]");
        return str.toString();
    }
}

