/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.oncrpc;

import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.oncrpc.AuthType;
import org.alfresco.jlan.oncrpc.RpcAuthenticationException;
import org.alfresco.jlan.oncrpc.RpcAuthenticator;
import org.alfresco.jlan.oncrpc.RpcPacket;
import org.alfresco.jlan.server.SrvSession;
import org.alfresco.jlan.server.auth.ClientInfo;
import org.alfresco.jlan.server.config.InvalidConfigurationException;
import org.alfresco.jlan.server.config.ServerConfiguration;
import org.springframework.extensions.config.ConfigElement;

public class DefaultRpcAuthenticator
implements RpcAuthenticator {
    private int[] _authTypes = new int[]{0, 1};
    private boolean m_debug;

    @Override
    public Object authenticateRpcClient(int authType, RpcPacket rpc) throws RpcAuthenticationException {
        Number sessKey = null;
        switch (authType) {
            case 0: {
                sessKey = new Integer(rpc.getClientAddress().hashCode());
                break;
            }
            case 1: {
                rpc.positionAtCredentialsData();
                rpc.skipBytes(4);
                int nameLen = rpc.unpackInt();
                rpc.skipBytes(nameLen);
                int uid = rpc.unpackInt();
                int gid = rpc.unpackInt();
                sessKey = new Long(((long)rpc.getClientAddress().hashCode() << 32) + (long)(gid << 16) + (long)uid);
            }
        }
        if (sessKey == null) {
            throw new RpcAuthenticationException(1, "Unsupported auth type, " + authType);
        }
        if (this.hasDebug()) {
            Debug.println("RpcAuth: RPC from " + rpc.getClientDetails() + ", authType=" + AuthType.getTypeAsString(authType) + ", sessKey=" + sessKey);
        }
        return sessKey;
    }

    public final boolean hasDebug() {
        return this.m_debug;
    }

    @Override
    public int[] getRpcAuthenticationTypes() {
        return this._authTypes;
    }

    @Override
    public ClientInfo getRpcClientInformation(Object sessKey, RpcPacket rpc) {
        ClientInfo cInfo = ClientInfo.createInfo("", null);
        int authType = rpc.getCredentialsType();
        cInfo.setNFSAuthenticationType(authType);
        switch (authType) {
            case 0: {
                cInfo.setClientAddress(rpc.getClientAddress().getHostAddress());
                if (!this.hasDebug()) break;
                Debug.println("RpcAuth: Client info, type=" + AuthType.getTypeAsString(authType) + ", addr=" + rpc.getClientAddress().getHostAddress());
                break;
            }
            case 1: {
                rpc.positionAtCredentialsData();
                rpc.skipBytes(4);
                cInfo.setClientAddress(rpc.unpackString());
                cInfo.setUid(rpc.unpackInt());
                cInfo.setGid(rpc.unpackInt());
                int grpLen = rpc.unpackInt();
                if (grpLen > 0) {
                    int[] groups = new int[grpLen];
                    rpc.unpackIntArray(groups);
                    cInfo.setGroupsList(groups);
                }
                if (!this.hasDebug()) break;
                Debug.println("RpcAuth: Client info, type=" + AuthType.getTypeAsString(authType) + ", name=" + cInfo.getClientAddress() + ", uid=" + cInfo.getUid() + ", gid=" + cInfo.getGid() + ", groups=" + grpLen);
            }
        }
        return cInfo;
    }

    @Override
    public void initialize(ServerConfiguration config, ConfigElement params) throws InvalidConfigurationException {
        if (params.getChild("Debug") != null) {
            this.m_debug = true;
        }
    }

    @Override
    public void setCurrentUser(SrvSession sess, ClientInfo client) {
    }
}

