/*
 * Decompiled with CFR 0.152.
 */
package nl.knaw.dans.common.dbflib;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Locale;
import nl.knaw.dans.common.dbflib.Field;
import nl.knaw.dans.common.dbflib.Type;
import nl.knaw.dans.common.dbflib.Util;
import nl.knaw.dans.common.dbflib.Value;

public class NumberValue
extends Value {
    private static final int MAX_LENGTH_INTEGER = Integer.valueOf(Integer.MAX_VALUE).toString().length();
    private static final int MAX_LENGTH_LONG = Long.valueOf(Long.MAX_VALUE).toString().length();

    public NumberValue(Number number) {
        super(number);
    }

    NumberValue(Field field, byte[] rawValue) {
        super(field, rawValue);
    }

    @Override
    protected Object doGetTypedValue(byte[] rawValue) {
        String stringValue = new String(rawValue).trim();
        if (stringValue.isEmpty() || stringValue.equals(".")) {
            return null;
        }
        int decimalPointIndex = stringValue.indexOf(46);
        if (decimalPointIndex == -1) {
            if (stringValue.length() < MAX_LENGTH_INTEGER) {
                return Integer.parseInt(stringValue);
            }
            if (stringValue.length() < MAX_LENGTH_LONG) {
                return Long.parseLong(stringValue);
            }
            return new BigInteger(stringValue);
        }
        if (stringValue.length() < 14) {
            return Double.parseDouble(stringValue);
        }
        return new BigDecimal(stringValue);
    }

    @Override
    protected byte[] doGetRawValue(Field field) {
        Number number = (Number)this.typed;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byte[] bytes = null;
            bytes = field.getType() == Type.NUMBER || field.getType() == Type.FLOAT ? NumberValue.formatNumber(number, field).getBytes() : this.typed.toString().getBytes();
            byteArrayOutputStream.write(bytes);
            byteArrayOutputStream.write(Util.repeat((byte)0, field.getLength() - bytes.length));
        }
        catch (IOException ioException) {
            assert (false) : "Programming error: writing to ByteOutputStream should never cause and IOException";
            throw new RuntimeException(ioException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private static Number convertIntegralToFractional(Number integralNumber) {
        if (integralNumber instanceof BigInteger) {
            return new BigDecimal((BigInteger)integralNumber);
        }
        return integralNumber.doubleValue();
    }

    private static Number convertFractionalToIntegral(Number fractionalNumber) {
        return Math.round(fractionalNumber.doubleValue());
    }

    private static boolean isIntegralNumber(Number number) {
        return number instanceof Byte || number instanceof Short || number instanceof Integer || number instanceof Long || number instanceof BigInteger;
    }

    private static String formatNumber(Number number, Field field) {
        String formatString = "%" + field.getLength() + (field.getDecimalCount() == 0 ? "d" : "." + field.getDecimalCount() + "f");
        Number num = number;
        if (field.getDecimalCount() > 0 && NumberValue.isIntegralNumber(number)) {
            num = NumberValue.convertIntegralToFractional(number);
        }
        if (field.getDecimalCount() == 0 && !NumberValue.isIntegralNumber(number)) {
            num = NumberValue.convertFractionalToIntegral(number);
        }
        return String.format(Locale.US, formatString, num);
    }
}

