/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.web.utils.security;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Locale;
import nc.ird.cantharella.data.config.DataContext;
import nc.ird.cantharella.data.exceptions.DataNotFoundException;
import nc.ird.cantharella.data.model.Utilisateur;
import nc.ird.cantharella.service.services.PersonneService;
import nc.ird.cantharella.web.config.WebApplicationImpl;
import nc.ird.cantharella.web.utils.security.AuthRole;
import org.apache.commons.lang3.StringUtils;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.http.WebSession;
import org.apache.wicket.request.Request;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AuthSession
extends WebSession
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(AuthSession.class);
    private static final String ATTRIBUTE_REMEMBER_ME = "rememberMe";
    private static final String ATTRIBUTE_ROLE = "role";
    private static final String ATTRIBUTE_UTILISATEUR = "utilisateur";
    @SpringBean
    private PersonneService personneService;

    public AuthSession(Request request) {
        super(request);
        WebApplicationImpl.injectSpringBeans((Object)this);
        this.checkLocale();
        this.setAttribute(ATTRIBUTE_ROLE, new HashSet());
        this.setUtilisateur(null);
        if (!this.autologin()) {
            this.logout();
        }
        this.bind();
    }

    protected void checkLocale() {
        Locale locale = super.getLocale();
        if (!DataContext.LOCALES.contains(locale)) {
            if (!DataContext.LOCALES.contains(locale = new Locale(locale.getLanguage()))) {
                locale = (Locale)DataContext.LOCALES.get(0);
            }
            this.setLocale(locale);
        }
    }

    private boolean autologin() {
        String[] cookie = WebApplication.get().getSecuritySettings().getAuthenticationStrategy().load();
        if (cookie != null && cookie.length == 2 && !StringUtils.isEmpty((CharSequence)cookie[0]) && !StringUtils.isEmpty((CharSequence)cookie[1]) && this.authenticate(cookie[0], cookie[1])) {
            try {
                this.connectUser(this.personneService.loadUtilisateur(cookie[0]), false);
            }
            catch (DataNotFoundException e) {
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean authenticate(String username, String password) {
        boolean authenticate = this.personneService.authenticateUtilisateur(username, password);
        LOG.debug(String.valueOf(authenticate));
        return authenticate;
    }

    public Boolean getRememberMe() {
        return (Boolean)this.getAttribute(ATTRIBUTE_REMEMBER_ME);
    }

    public AuthRole getRole() {
        return (AuthRole)this.getAttribute(ATTRIBUTE_ROLE);
    }

    public Utilisateur getUtilisateur() {
        Integer idPersonne = (Integer)this.getAttribute(ATTRIBUTE_UTILISATEUR);
        Utilisateur utilisateur = null;
        if (idPersonne != null) {
            try {
                utilisateur = this.personneService.loadUtilisateur(idPersonne);
            }
            catch (DataNotFoundException e) {
                this.logout();
            }
            catch (Exception e) {
                LOG.debug(e.getClass() + e.getMessage());
                return null;
            }
        }
        return utilisateur;
    }

    public void connectUser(Utilisateur utilisateur, boolean rememberMe) {
        this.setUtilisateur(utilisateur);
        this.setRole(utilisateur.getTypeDroit() == Utilisateur.TypeDroit.UTILISATEUR ? AuthRole.USER : AuthRole.ADMIN);
        this.setRememberMe(Boolean.valueOf(rememberMe));
        if (rememberMe) {
            WebApplication.get().getSecuritySettings().getAuthenticationStrategy().save(utilisateur.getCourriel(), utilisateur.getPasswordHash());
        }
    }

    public void logout() {
        this.setUtilisateur(null);
        this.setRememberMe(Boolean.valueOf(false));
        this.setRole(AuthRole.VISITOR);
        WebApplication.get().getSecuritySettings().getAuthenticationStrategy().remove();
    }

    private void setRememberMe(Boolean rememberMe) {
        this.setAttribute(ATTRIBUTE_REMEMBER_ME, (Serializable)rememberMe);
    }

    private void setRole(AuthRole role) {
        this.setAttribute(ATTRIBUTE_ROLE, (Serializable)role);
    }

    private void setUtilisateur(Utilisateur utilisateur) {
        this.setAttribute(ATTRIBUTE_UTILISATEUR, (Serializable)(utilisateur != null ? utilisateur.getIdPersonne() : null));
    }

    public void update(Utilisateur utilisateur) {
        this.connectUser(utilisateur, this.getRememberMe().booleanValue());
    }
}

