/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.web.utils.models;

import java.io.Serializable;
import nc.ird.cantharella.data.dao.GenericDao;
import nc.ird.cantharella.data.exceptions.UnexpectedException;
import nc.ird.cantharella.data.model.utils.AbstractModel;
import nc.ird.cantharella.utils.AssertTools;
import nc.ird.cantharella.web.config.WebApplicationImpl;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GenericLoadableDetachableModel<M extends AbstractModel>
extends LoadableDetachableModel<M> {
    private static final Logger LOG = LoggerFactory.getLogger(GenericLoadableDetachableModel.class);
    @SpringBean
    private GenericDao dao;
    private final Class<M> modelClass;
    private final Serializable modelID;

    public GenericLoadableDetachableModel(Class<M> modelClass, Serializable modelID) {
        AssertTools.assertNotNull(modelClass);
        AssertTools.assertNotNull((Object)modelID);
        this.modelClass = modelClass;
        this.modelID = modelID;
        WebApplicationImpl.injectSpringBeans((Object)this);
    }

    public GenericLoadableDetachableModel(M model) {
        this(model.getClass(), model.getIdValue());
        this.setObject(model);
    }

    protected M load() {
        try {
            return (M)this.dao.read(this.modelClass, this.modelID);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException(e);
        }
    }
}

