/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.web.utils.models;

import java.math.RoundingMode;
import java.text.NumberFormat;
import java.util.Locale;
import nc.ird.cantharella.web.utils.models.DisplayDecimalPropertyModel;
import org.apache.wicket.model.PropertyModel;

public class DisplayDecimalPropertyModel
extends PropertyModel<Object> {
    private int NB_DECIMAL_SMALL = 2;
    private Locale locale;
    private DecimalDisplFormat format;

    public DisplayDecimalPropertyModel(Object modelObject, String expression, DecimalDisplFormat format, Locale locale) {
        super(modelObject, expression);
        this.format = format;
        this.locale = locale;
    }

    public Object getObject() {
        return this.formatDecimalValue((Number)super.getObject());
    }

    private final NumberFormat getDecimalFormat() {
        int numberOfDec = this.format == DecimalDisplFormat.SMALL ? this.NB_DECIMAL_SMALL : 4;
        NumberFormat fmt = NumberFormat.getNumberInstance(this.locale);
        fmt.setMaximumIntegerDigits(5);
        fmt.setMaximumFractionDigits(numberOfDec);
        fmt.setMinimumFractionDigits(numberOfDec);
        fmt.setRoundingMode(RoundingMode.HALF_UP);
        return fmt;
    }

    private final String formatDecimalValue(Number decimalValue) {
        if (decimalValue == null) {
            return null;
        }
        return this.getDecimalFormat().format(decimalValue);
    }
}

