/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.web.utils.forms;

import nc.ird.cantharella.data.exceptions.UnexpectedException;
import nc.ird.cantharella.web.pages.TemplatePage;
import nc.ird.cantharella.web.utils.forms.SubmittableButtonEvents;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.model.IModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SubmittableButton
extends Button {
    private static final Logger LOG = LoggerFactory.getLogger(SubmittableButton.class);
    private final SubmittableButtonEvents submittable;
    private Class<? extends TemplatePage> specificMsgPage = null;

    public SubmittableButton(String id, Class<? extends TemplatePage> specificMsgPage, SubmittableButtonEvents submittable) {
        super(id);
        this.submittable = submittable;
        this.specificMsgPage = specificMsgPage;
    }

    public SubmittableButton(String id, IModel<String> model, SubmittableButtonEvents submittable) {
        super(id, model);
        this.submittable = submittable;
    }

    public SubmittableButton(String id, SubmittableButtonEvents submittable) {
        super(id);
        this.submittable = submittable;
    }

    public void onSubmit() {
        this.submittable.onValidate();
        if (!this.getPage().hasErrorMessage()) {
            try {
                this.submittable.onProcess();
            }
            catch (UnexpectedException e) {
                throw e;
            }
            catch (RuntimeException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                if (this.specificMsgPage == null) {
                    ((TemplatePage)this.getPage()).errorCurrentPage(this.getId(), e);
                }
                ((TemplatePage)this.getPage()).errorCurrentPage(this.specificMsgPage, this.getId(), e);
            }
        }
        if (this.getPage().hasErrorMessage()) {
            this.submittable.onError();
        } else {
            this.submittable.onSuccess();
        }
    }
}

