/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.web.utils.converters;

import java.math.BigDecimal;
import java.util.Locale;
import nc.ird.cantharella.utils.NumberTools;
import org.apache.wicket.util.convert.ConversionException;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.convert.converter.AbstractDecimalConverter;

public final class BigDecimalConverterImpl
extends AbstractDecimalConverter<BigDecimal> {
    public static final int DECIMAL_MIN_FRACTION_DIGIT = 0;
    public static final IConverter<BigDecimal> INSTANCE = new BigDecimalConverterImpl();

    public BigDecimal convertToObject(String value, Locale locale) {
        if (value == null || value.trim().equals("")) {
            return null;
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        try {
            return NumberTools.parseBigDecimal((String)value, (Locale)locale, (int)4, (int)5);
        }
        catch (RuntimeException e) {
            throw new ConversionException((Throwable)e);
        }
    }

    public String convertToString(BigDecimal value, Locale locale) {
        try {
            return NumberTools.bigDecimalToString((BigDecimal)value, (Locale)locale, (int)0, (int)4, (int)5);
        }
        catch (RuntimeException e) {
            throw new ConversionException((Throwable)e);
        }
    }

    protected Class<BigDecimal> getTargetType() {
        return BigDecimal.class;
    }
}

