/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.web.pages.domain.station;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import nc.ird.cantharella.data.config.DataContext;
import nc.ird.cantharella.data.exceptions.DataNotFoundException;
import nc.ird.cantharella.data.exceptions.UnexpectedException;
import nc.ird.cantharella.data.model.Personne;
import nc.ird.cantharella.data.model.Station;
import nc.ird.cantharella.data.validation.utils.ModelValidator;
import nc.ird.cantharella.service.services.StationService;
import nc.ird.cantharella.utils.CoordTools;
import nc.ird.cantharella.web.config.WebContext;
import nc.ird.cantharella.web.pages.TemplatePage;
import nc.ird.cantharella.web.pages.domain.document.panel.ManageListDocumentsPanel;
import nc.ird.cantharella.web.pages.model.ManageStationModel;
import nc.ird.cantharella.web.utils.CallerPage;
import nc.ird.cantharella.web.utils.behaviors.JSConfirmationBehavior;
import nc.ird.cantharella.web.utils.forms.AutoCompleteTextFieldString;
import nc.ird.cantharella.web.utils.forms.SubmittableButton;
import nc.ird.cantharella.web.utils.forms.SubmittableButtonEvents;
import nc.ird.cantharella.web.utils.renderers.MapChoiceRenderer;
import nc.ird.cantharella.web.utils.security.AuthRole;
import nc.ird.cantharella.web.utils.security.AuthRoles;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AuthRoles(value={AuthRole.ADMIN, AuthRole.USER})
public final class ManageStationPage
extends TemplatePage {
    private static final String ACTION_CREATE = "Create";
    private static final String ACTION_DELETE = "Delete";
    private static final String ACTION_UPDATE = "Update";
    private static final Logger LOG = LoggerFactory.getLogger(ManageStationPage.class);
    private final CallerPage callerPage;
    private boolean multipleEntry;
    private final IModel<ManageStationModel> manageStationModel;
    private final IModel<Station> stationModel;
    @SpringBean
    private StationService stationService;
    @SpringBean(name="webModelValidator")
    private ModelValidator validator;

    public ManageStationPage(CallerPage callerPage, boolean multipleEntry) {
        this(null, null, callerPage, multipleEntry);
    }

    public ManageStationPage(Integer idStation, CallerPage callerPage) {
        this(idStation, null, callerPage, false);
    }

    public ManageStationPage(Station station, CallerPage callerPage) {
        this(null, station, callerPage, true);
    }

    private ManageStationPage(Integer idStation, Station station, CallerPage callerPage, boolean multipleEntry) {
        super(ManageStationPage.class);
        boolean createMode;
        assert (idStation == null || station == null);
        this.callerPage = callerPage;
        CallerPage currentPage = new CallerPage((TemplatePage)this);
        this.multipleEntry = multipleEntry;
        this.manageStationModel = new Model((Serializable)new ManageStationModel());
        try {
            this.stationModel = new Model((Serializable)(idStation == null && station == null ? new Station() : (station != null ? station : this.stationService.loadStation(idStation))));
        }
        catch (DataNotFoundException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException((Exception)((Object)e));
        }
        boolean bl = createMode = idStation == null;
        if (createMode) {
            ((Station)this.stationModel.getObject()).setCreateur((Personne)this.getSession().getUtilisateur());
            if (station != null) {
                ((ManageStationModel)this.manageStationModel.getObject()).setLatitudeDegrees(CoordTools.latitudeDegrees((String)((Station)this.stationModel.getObject()).getLatitude()));
                ((ManageStationModel)this.manageStationModel.getObject()).setLatitudeOrientation(CoordTools.latitudeOrientation((String)((Station)this.stationModel.getObject()).getLatitude()));
                ((ManageStationModel)this.manageStationModel.getObject()).setLongitudeDegrees(CoordTools.longitudeDegrees((String)((Station)this.stationModel.getObject()).getLongitude()));
                ((ManageStationModel)this.manageStationModel.getObject()).setLongitudeOrientation(CoordTools.longitudeOrientation((String)((Station)this.stationModel.getObject()).getLongitude()));
            }
        } else {
            ((ManageStationModel)this.manageStationModel.getObject()).setLatitudeDegrees(CoordTools.latitudeDegrees((String)((Station)this.stationModel.getObject()).getLatitude()));
            ((ManageStationModel)this.manageStationModel.getObject()).setLatitudeMinutes(CoordTools.latitudeMinutes((String)((Station)this.stationModel.getObject()).getLatitude()));
            ((ManageStationModel)this.manageStationModel.getObject()).setLatitudeOrientation(CoordTools.latitudeOrientation((String)((Station)this.stationModel.getObject()).getLatitude()));
            ((ManageStationModel)this.manageStationModel.getObject()).setLongitudeDegrees(CoordTools.longitudeDegrees((String)((Station)this.stationModel.getObject()).getLongitude()));
            ((ManageStationModel)this.manageStationModel.getObject()).setLongitudeMinutes(CoordTools.longitudeMinutes((String)((Station)this.stationModel.getObject()).getLongitude()));
            ((ManageStationModel)this.manageStationModel.getObject()).setLongitudeOrientation(CoordTools.longitudeOrientation((String)((Station)this.stationModel.getObject()).getLongitude()));
        }
        List localites = this.stationService.listStationLocalites();
        Form formView = new Form("Form");
        formView.add(new Component[]{new TextField("Station.nom", (IModel)new PropertyModel((Object)this.stationModel, "nom"))});
        formView.add(new Component[]{new DropDownChoice("Station.codePays", (IModel)new PropertyModel((Object)this.stationModel, "codePays"), (List)WebContext.COUNTRY_CODES.get(this.getSession().getLocale()), (IChoiceRenderer)new MapChoiceRenderer((Map)WebContext.COUNTRIES.get(this.getSession().getLocale())))});
        formView.add(new Component[]{new AutoCompleteTextFieldString("Station.localite", (IModel)new PropertyModel((Object)this.stationModel, "localite"), localites, AutoCompleteTextFieldString.ComparisonMode.CONTAINS)});
        formView.add(new Component[]{new TextArea("Station.complement", (IModel)new PropertyModel((Object)this.stationModel, "complement"))});
        formView.add(new Component[]{new TextField("Station.createur", (IModel)new PropertyModel((Object)this.stationModel, "createur")).setEnabled(false)});
        formView.add(new Component[]{new TextField("ManageStationModel.latitudeDegrees", (IModel)new PropertyModel((Object)this.manageStationModel, "latitudeDegrees"))});
        formView.add(new Component[]{new Label("Coordonnate.degrees.latitude", String.valueOf('\u00b0'))});
        formView.add(new Component[]{new TextField("ManageStationModel.latitudeMinutes", (IModel)new PropertyModel((Object)this.manageStationModel, "latitudeMinutes"))});
        formView.add(new Component[]{new Label("Coordonnate.minutes.latitude", String.valueOf('\''))});
        formView.add(new Component[]{new DropDownChoice("ManageStationModel.latitudeOrientation", (IModel)new PropertyModel((Object)this.manageStationModel, "latitudeOrientation"), Arrays.asList(CoordTools.LATITUDE_ORIENTATIONS))});
        formView.add(new Component[]{new TextField("ManageStationModel.longitudeDegrees", (IModel)new PropertyModel((Object)this.manageStationModel, "longitudeDegrees"))});
        formView.add(new Component[]{new Label("Coordonnate.degrees.longitude", String.valueOf('\u00b0'))});
        formView.add(new Component[]{new TextField("ManageStationModel.longitudeMinutes", (IModel)new PropertyModel((Object)this.manageStationModel, "longitudeMinutes"))});
        formView.add(new Component[]{new Label("Coordonnate.minutes.longitude", String.valueOf('\''))});
        formView.add(new Component[]{new DropDownChoice("ManageStationModel.longitudeOrientation", (IModel)new PropertyModel((Object)this.manageStationModel, "longitudeOrientation"), Arrays.asList(CoordTools.LONGITUDE_ORIENTATIONS))});
        formView.add(new Component[]{new DropDownChoice("Station.referentiel", (IModel)new PropertyModel((Object)this.stationModel, "referentiel"), WebContext.REFERENTIEL_CODES, (IChoiceRenderer)new MapChoiceRenderer(DataContext.REFERENTIELS))});
        ManageListDocumentsPanel manageListDocumentsPanel = new ManageListDocumentsPanel("ManageListDocumentsPanel", this.stationModel, currentPage);
        manageListDocumentsPanel.setUpdateOrDeleteEnabled(createMode || this.stationService.updateOrdeleteStationEnabled((Station)this.stationModel.getObject(), this.getSession().getUtilisateur()));
        formView.add(new Component[]{manageListDocumentsPanel});
        SubmittableButton createButton = new SubmittableButton(ACTION_CREATE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        createButton.setVisibilityAllowed(createMode);
        formView.add(new Component[]{createButton});
        SubmittableButton updateButton = new SubmittableButton(ACTION_UPDATE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        updateButton.setVisibilityAllowed(!createMode && this.stationService.updateOrdeleteStationEnabled((Station)this.stationModel.getObject(), this.getSession().getUtilisateur()));
        formView.add(new Component[]{updateButton});
        SubmittableButton deleteButton = new SubmittableButton(ACTION_DELETE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        deleteButton.setVisibilityAllowed(!createMode && this.stationService.updateOrdeleteStationEnabled((Station)this.stationModel.getObject(), this.getSession().getUtilisateur()));
        deleteButton.add(new Behavior[]{new JSConfirmationBehavior(this.getStringModel("Confirm", new Object[0]))});
        deleteButton.setDefaultFormProcessing(false);
        formView.add(new Component[]{deleteButton});
        formView.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        if (createMode) {
            if (((Station)this.stationModel.getObject()).getCodePays() == null) {
                ((Station)this.stationModel.getObject()).setCodePays((String)((Map)WebContext.COUNTRIES.get(this.getSession().getLocale())).entrySet().iterator().next().getKey());
            }
            if (((Station)this.stationModel.getObject()).getReferentiel() == null) {
                ((Station)this.stationModel.getObject()).setReferentiel((Integer)WebContext.REFERENTIEL_CODES.get(0));
            }
            if (((ManageStationModel)this.manageStationModel.getObject()).getLatitudeOrientation() == null) {
                ((ManageStationModel)this.manageStationModel.getObject()).setLatitudeOrientation(CoordTools.LATITUDE_ORIENTATIONS[1]);
            }
            if (((ManageStationModel)this.manageStationModel.getObject()).getLongitudeOrientation() == null) {
                ((ManageStationModel)this.manageStationModel.getObject()).setLongitudeOrientation(CoordTools.LONGITUDE_ORIENTATIONS[0]);
            }
        }
        this.add(new Component[]{formView});
    }

    private void redirect() {
        if (this.multipleEntry) {
            Station nextStation = new Station();
            nextStation.setCodePays(((Station)this.stationModel.getObject()).getCodePays());
            if (((ManageStationModel)this.manageStationModel.getObject()).getLatitudeDegrees() != null) {
                nextStation.setLatitude(((Station)this.stationModel.getObject()).getLatitude());
                nextStation.setLongitude(((Station)this.stationModel.getObject()).getLongitude());
                nextStation.setReferentiel(((Station)this.stationModel.getObject()).getReferentiel());
            }
            this.setResponsePage((Page)new ManageStationPage(nextStation, this.callerPage));
        } else {
            this.callerPage.addPageParameter(Station.class.getSimpleName(), (Object)((Station)this.stationModel.getObject()).getIdStation());
            this.callerPage.responsePage((TemplatePage)this);
        }
    }

    private void validateModel() {
        if (((Station)this.stationModel.getObject()).getCreateur() == null) {
            ((Station)this.stationModel.getObject()).setCreateur((Personne)this.getSession().getUtilisateur());
        }
        List referentielErrors = this.validator.validate(this.stationModel.getObject(), this.getSession().getLocale(), new String[]{"referentiel"});
        List coordErrors = this.validator.validate(this.manageStationModel.getObject(), this.getSession().getLocale(), new String[0]);
        if (((ManageStationModel)this.manageStationModel.getObject()).getLatitudeDegrees() != null || ((ManageStationModel)this.manageStationModel.getObject()).getLatitudeMinutes() != null || ((ManageStationModel)this.manageStationModel.getObject()).getLongitudeDegrees() != null || ((ManageStationModel)this.manageStationModel.getObject()).getLongitudeMinutes() != null) {
            if (((ManageStationModel)this.manageStationModel.getObject()).getLatitudeDegrees() != null && ((ManageStationModel)this.manageStationModel.getObject()).getLatitudeMinutes() != null && ((ManageStationModel)this.manageStationModel.getObject()).getLatitudeOrientation() != null && ((ManageStationModel)this.manageStationModel.getObject()).getLongitudeDegrees() != null && ((ManageStationModel)this.manageStationModel.getObject()).getLongitudeMinutes() != null && ((ManageStationModel)this.manageStationModel.getObject()).getLongitudeOrientation() != null && ((Station)this.stationModel.getObject()).getReferentiel() != null) {
                if (referentielErrors.isEmpty() && coordErrors.isEmpty()) {
                    ((Station)this.stationModel.getObject()).setLatitude(CoordTools.latitude((Integer)((ManageStationModel)this.manageStationModel.getObject()).getLatitudeDegrees(), (BigDecimal)((ManageStationModel)this.manageStationModel.getObject()).getLatitudeMinutes(), (Character)((ManageStationModel)this.manageStationModel.getObject()).getLatitudeOrientation()));
                    ((Station)this.stationModel.getObject()).setLongitude(CoordTools.longitude((Integer)((ManageStationModel)this.manageStationModel.getObject()).getLongitudeDegrees(), (BigDecimal)((ManageStationModel)this.manageStationModel.getObject()).getLongitudeMinutes(), (Character)((ManageStationModel)this.manageStationModel.getObject()).getLongitudeOrientation()));
                }
            } else {
                this.getPage().error((Serializable)((Object)this.getString("Station.coordonnees.KO")));
            }
        } else if (((ManageStationModel)this.manageStationModel.getObject()).getLatitudeDegrees() == null && ((ManageStationModel)this.manageStationModel.getObject()).getLatitudeMinutes() == null && ((ManageStationModel)this.manageStationModel.getObject()).getLongitudeDegrees() == null && ((ManageStationModel)this.manageStationModel.getObject()).getLongitudeMinutes() == null) {
            ((Station)this.stationModel.getObject()).setLatitude(null);
            ((Station)this.stationModel.getObject()).setLongitude(null);
        }
        this.addValidationErrors((Collection)this.validator.validate(this.stationModel.getObject(), this.getSession().getLocale(), new String[]{"nom", "codePays", "localite", "complement", "createur", "latitude", "longitude"}));
        this.addValidationErrors((Collection)referentielErrors);
        this.addValidationErrors((Collection)coordErrors);
    }

    static /* synthetic */ IModel access$000(ManageStationPage x0) {
        return x0.manageStationModel;
    }

    static /* synthetic */ IModel access$100(ManageStationPage x0) {
        return x0.stationModel;
    }

    static /* synthetic */ StationService access$200(ManageStationPage x0) {
        return x0.stationService;
    }

    static /* synthetic */ void access$300(ManageStationPage x0) {
        x0.redirect();
    }

    static /* synthetic */ void access$400(ManageStationPage x0) {
        x0.validateModel();
    }
}

