/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.web.pages.domain.lot;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import nc.ird.cantharella.data.exceptions.DataNotFoundException;
import nc.ird.cantharella.data.exceptions.UnexpectedException;
import nc.ird.cantharella.data.model.Campagne;
import nc.ird.cantharella.data.model.Lot;
import nc.ird.cantharella.data.model.Partie;
import nc.ird.cantharella.data.model.Personne;
import nc.ird.cantharella.data.model.Specimen;
import nc.ird.cantharella.data.model.Station;
import nc.ird.cantharella.data.validation.utils.ModelValidator;
import nc.ird.cantharella.service.services.CampagneService;
import nc.ird.cantharella.service.services.LotService;
import nc.ird.cantharella.service.services.SpecimenService;
import nc.ird.cantharella.utils.BeanTools;
import nc.ird.cantharella.utils.CollectionTools;
import nc.ird.cantharella.web.pages.TemplatePage;
import nc.ird.cantharella.web.pages.domain.document.panel.ManageListDocumentsPanel;
import nc.ird.cantharella.web.utils.CallerPage;
import nc.ird.cantharella.web.utils.behaviors.JSConfirmationBehavior;
import nc.ird.cantharella.web.utils.forms.SubmittableButton;
import nc.ird.cantharella.web.utils.forms.SubmittableButtonEvents;
import nc.ird.cantharella.web.utils.panels.SimpleTooltipPanel;
import nc.ird.cantharella.web.utils.security.AuthRole;
import nc.ird.cantharella.web.utils.security.AuthRoles;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.form.DateTextField;
import org.apache.wicket.extensions.yui.calendar.DatePicker;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.apache.wicket.util.string.StringValueConversionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AuthRoles(value={AuthRole.USER, AuthRole.ADMIN})
public final class ManageLotPage
extends TemplatePage {
    private static final String ACTION_CREATE = "Create";
    private static final String ACTION_DELETE = "Delete";
    private static final String ACTION_UPDATE = "Update";
    private static final Logger LOG = LoggerFactory.getLogger(ManageLotPage.class);
    private final List<Campagne> campagnes;
    @SpringBean
    private CampagneService campagneService;
    private final IModel<Lot> lotModel;
    @SpringBean
    private LotService lotService;
    private final List<Specimen> specimens;
    @SpringBean
    private SpecimenService specimenService;
    @SpringBean(name="webModelValidator")
    private ModelValidator validator;
    private final CallerPage callerPage;
    private boolean multipleEntry;

    public ManageLotPage(CallerPage callerPage, boolean multipleEntry) {
        this(null, null, callerPage, multipleEntry);
    }

    public ManageLotPage(Integer idLot, CallerPage callerPage) {
        this(idLot, null, callerPage, false);
    }

    public ManageLotPage(Lot lot, CallerPage callerPage) {
        this(null, lot, callerPage, true);
    }

    private ManageLotPage(Integer idLot, Lot lot, CallerPage callerPage, boolean multipleEntry) {
        super(ManageLotPage.class);
        boolean createMode;
        assert (idLot == null || lot == null);
        this.callerPage = callerPage;
        this.multipleEntry = multipleEntry;
        CallerPage currentPage = new CallerPage((TemplatePage)this);
        try {
            this.lotModel = new Model((Serializable)(idLot == null && lot == null ? new Lot() : (lot != null ? lot : this.lotService.loadLot(idLot))));
        }
        catch (DataNotFoundException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException((Exception)((Object)e));
        }
        boolean bl = createMode = idLot == null;
        if (createMode) {
            ((Lot)this.lotModel.getObject()).setCreateur((Personne)this.getSession().getUtilisateur());
        }
        this.campagnes = this.campagneService.listCampagnes(this.getSession().getUtilisateur());
        this.specimens = this.specimenService.listSpecimens(this.getSession().getUtilisateur());
        List parties = this.lotService.listParties();
        if (lot != null) {
            ((Lot)this.lotModel.getObject()).setCampagne((Campagne)CollectionTools.findWithValue((List)this.campagnes, (String)"idCampagne", (BeanTools.AccessType)BeanTools.AccessType.GETTER, (Object)((Lot)this.lotModel.getObject()).getCampagne().getIdCampagne()));
            if (((Lot)this.lotModel.getObject()).getCampagne() != null) {
                List stations = ((Lot)this.lotModel.getObject()).getCampagne().getStations();
                ((Lot)this.lotModel.getObject()).setStation((Station)CollectionTools.findWithValue((List)stations, (String)"idStation", (BeanTools.AccessType)BeanTools.AccessType.GETTER, (Object)((Lot)this.lotModel.getObject()).getStation().getIdStation()));
            }
            if (((Lot)this.lotModel.getObject()).getPartie() != null) {
                ((Lot)this.lotModel.getObject()).setPartie((Partie)CollectionTools.findWithValue((List)parties, (String)"idPartie", (BeanTools.AccessType)BeanTools.AccessType.GETTER, (Object)((Lot)this.lotModel.getObject()).getPartie().getIdPartie()));
            }
        } else if (idLot != null) {
            // empty if block
        }
        Form formView = new Form("Form");
        DropDownChoice campagnesInput = new DropDownChoice("Lot.campagne", (IModel)new PropertyModel((Object)this.lotModel, "campagne"), this.campagnes);
        campagnesInput.setNullValid(false);
        formView.add(new Component[]{campagnesInput});
        formView.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        DropDownChoice stationsInput = new DropDownChoice("Lot.station", (IModel)new PropertyModel((Object)this.lotModel, "station"), ((Lot)this.lotModel.getObject()).getCampagne() == null ? new ArrayList() : ((Lot)this.lotModel.getObject()).getCampagne().getStations());
        stationsInput.setOutputMarkupId(true);
        stationsInput.setNullValid(false);
        stationsInput.setEnabled(((Lot)this.lotModel.getObject()).getCampagne() != null);
        formView.add(new Component[]{stationsInput});
        formView.add(new Component[]{new SimpleTooltipPanel("Lot.station.info", this.getStringModel("Lot.station.info", new Object[0]))});
        campagnesInput.add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
        formView.add(new Component[]{new DateTextField("Lot.dateRecolte", (IModel)new PropertyModel((Object)this.lotModel, "dateRecolte")).add(new Behavior[]{new DatePicker()})});
        formView.add(new Component[]{new TextField("Lot.ref", (IModel)new PropertyModel((Object)this.lotModel, "ref"))});
        formView.add(new Component[]{new DropDownChoice("Lot.specimenRef", (IModel)new PropertyModel((Object)this.lotModel, "specimenRef"), this.specimens).setNullValid(false)});
        formView.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        formView.add(new Component[]{new DropDownChoice("Lot.partie", (IModel)new PropertyModel((Object)this.lotModel, "partie"), parties).setNullValid(true)});
        formView.add(new Component[]{new TextField("Lot.masseFraiche", (IModel)new PropertyModel((Object)this.lotModel, "masseFraiche"))});
        formView.add(new Component[]{new TextField("Lot.masseSeche", (IModel)new PropertyModel((Object)this.lotModel, "masseSeche"))});
        formView.add(new Component[]{new CheckBox("Lot.echantillonColl", (IModel)new PropertyModel((Object)this.lotModel, "echantillonColl"))});
        formView.add(new Component[]{new CheckBox("Lot.echantillonIdent", (IModel)new PropertyModel((Object)this.lotModel, "echantillonIdent"))});
        formView.add(new Component[]{new CheckBox("Lot.echantillonPhylo", (IModel)new PropertyModel((Object)this.lotModel, "echantillonPhylo"))});
        formView.add(new Component[]{new TextArea("Lot.complement", (IModel)new PropertyModel((Object)this.lotModel, "complement"))});
        formView.add(new Component[]{new TextField("Lot.createur", (IModel)new PropertyModel((Object)this.lotModel, "createur")).setEnabled(false)});
        ManageListDocumentsPanel manageListDocumentsPanel = new ManageListDocumentsPanel("ManageListDocumentsPanel", this.lotModel, currentPage);
        manageListDocumentsPanel.setUpdateOrDeleteEnabled(createMode || this.lotService.updateOrdeleteLotEnabled((Lot)this.lotModel.getObject(), this.getSession().getUtilisateur()));
        formView.add(new Component[]{manageListDocumentsPanel});
        SubmittableButton createButton = new SubmittableButton(ACTION_CREATE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        createButton.setVisibilityAllowed(createMode);
        formView.add(new Component[]{createButton});
        SubmittableButton updateButton = new SubmittableButton(ACTION_UPDATE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        updateButton.setVisibilityAllowed(!createMode && this.lotService.updateOrdeleteLotEnabled((Lot)this.lotModel.getObject(), this.getSession().getUtilisateur()));
        formView.add(new Component[]{updateButton});
        SubmittableButton deleteButton = new SubmittableButton(ACTION_DELETE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        deleteButton.setVisibilityAllowed(!createMode && this.lotService.updateOrdeleteLotEnabled((Lot)this.lotModel.getObject(), this.getSession().getUtilisateur()));
        deleteButton.add(new Behavior[]{new JSConfirmationBehavior(this.getStringModel("Confirm", new Object[0]))});
        deleteButton.setDefaultFormProcessing(false);
        formView.add(new Component[]{deleteButton});
        formView.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        this.add(new Component[]{formView});
    }

    protected void onBeforeRender() {
        this.refreshModel();
        super.onBeforeRender();
    }

    private void redirect() {
        if (this.multipleEntry) {
            Lot nextLot = new Lot();
            nextLot.setCampagne(((Lot)this.lotModel.getObject()).getCampagne());
            nextLot.setStation(((Lot)this.lotModel.getObject()).getStation());
            nextLot.setDateRecolte(((Lot)this.lotModel.getObject()).getDateRecolte());
            nextLot.setPartie(((Lot)this.lotModel.getObject()).getPartie());
            this.setResponsePage((Page)new ManageLotPage(nextLot, this.callerPage));
        } else if (this.callerPage != null) {
            this.callerPage.addPageParameter(Lot.class.getSimpleName(), (Object)((Lot)this.lotModel.getObject()).getIdLot());
            this.callerPage.responsePage((TemplatePage)this);
        }
    }

    private void refreshModel() {
        String key = Campagne.class.getSimpleName();
        if (this.getPageParameters().getNamedKeys().contains(key)) {
            CollectionTools.setter((Collection)this.campagnes, (Collection)this.campagneService.listCampagnes(this.getSession().getUtilisateur()));
            try {
                Campagne createdCampagne = this.campagneService.loadCampagne(Integer.valueOf(this.getPageParameters().get(key).toInt()));
                ((Lot)this.lotModel.getObject()).setCampagne(createdCampagne);
            }
            catch (StringValueConversionException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                throw new UnexpectedException((Exception)((Object)e));
            }
            catch (DataNotFoundException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                throw new UnexpectedException((Exception)((Object)e));
            }
            this.getPageParameters().remove(key, new String[0]);
        }
        key = Specimen.class.getSimpleName();
        if (this.getPageParameters().getNamedKeys().contains(key)) {
            CollectionTools.setter((Collection)this.specimens, (Collection)this.specimenService.listSpecimens(this.getSession().getUtilisateur()));
            try {
                Specimen createdSpecimen = this.specimenService.loadSpecimen(Integer.valueOf(this.getPageParameters().get(key).toInt()));
                ((Lot)this.lotModel.getObject()).setSpecimenRef(createdSpecimen);
            }
            catch (StringValueConversionException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                throw new UnexpectedException((Exception)((Object)e));
            }
            catch (DataNotFoundException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                throw new UnexpectedException((Exception)((Object)e));
            }
            this.getPageParameters().remove(key, new String[0]);
        }
    }

    private void validateModel() {
        if (((Lot)this.lotModel.getObject()).getCreateur() == null) {
            ((Lot)this.lotModel.getObject()).setCreateur((Personne)this.getSession().getUtilisateur());
        }
        this.addValidationErrors((Collection)this.validator.validate(this.lotModel.getObject(), this.getSession().getLocale(), new String[0]));
    }

    static /* synthetic */ IModel access$000(ManageLotPage x0) {
        return x0.lotModel;
    }

    static /* synthetic */ CampagneService access$100(ManageLotPage x0) {
        return x0.campagneService;
    }

    static /* synthetic */ LotService access$200(ManageLotPage x0) {
        return x0.lotService;
    }

    static /* synthetic */ void access$300(ManageLotPage x0) {
        x0.redirect();
    }

    static /* synthetic */ void access$400(ManageLotPage x0) {
        x0.validateModel();
    }
}

