/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.web.pages.domain.document;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import nc.ird.cantharella.data.model.Document;
import nc.ird.cantharella.data.model.utils.DocumentAttachable;
import nc.ird.cantharella.web.pages.domain.document.DocumentTooltipColumn;
import org.apache.commons.collections.CollectionUtils;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public abstract class DocumentTooltipColumn<T extends DocumentAttachable, S>
extends AbstractColumn<T, S> {
    public DocumentTooltipColumn(IModel<String> displayModel) {
        super(displayModel);
    }

    public Component getHeader(String componentId) {
        ImagePanel panel = new ImagePanel(this, componentId, Model.of((Serializable)((Object)"images/open_folder_yellow.png")));
        panel.add(new Behavior[]{new AttributeModifier("title", this.getDisplayModel())});
        return panel;
    }

    public void populateItem(Item<ICellPopulator<T>> item, String componentId, IModel<T> model) {
        List documents = ((DocumentAttachable)model.getObject()).getDocuments();
        StringBuilder builder = new StringBuilder();
        if (CollectionUtils.isNotEmpty((Collection)documents)) {
            for (Document document : documents) {
                builder.append(document.getTitre());
                builder.append("\n");
            }
        }
        DocumentTooltipPanel panel = new DocumentTooltipPanel(this, componentId, model, (IModel)Model.of((Serializable)((Object)builder.toString())));
        panel.setVisibilityAllowed(CollectionUtils.isNotEmpty((Collection)documents));
        item.add(new Component[]{panel});
    }

    public abstract void onClick(IModel<T> var1);
}

