/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.web.pages;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.MissingResourceException;
import nc.ird.cantharella.service.model.SearchBean;
import nc.ird.cantharella.utils.AssertTools;
import nc.ird.cantharella.utils.Pair;
import nc.ird.cantharella.web.pages.ContactPage;
import nc.ird.cantharella.web.pages.HomePage;
import nc.ird.cantharella.web.pages.ImprintPage;
import nc.ird.cantharella.web.pages.TemplatePage;
import nc.ird.cantharella.web.pages.domain.campagne.ListCampagnesPage;
import nc.ird.cantharella.web.pages.domain.config.ListConfigurationPage;
import nc.ird.cantharella.web.pages.domain.extraction.ListExtractionsPage;
import nc.ird.cantharella.web.pages.domain.lot.ListLotsPage;
import nc.ird.cantharella.web.pages.domain.molecule.ListMoleculesPage;
import nc.ird.cantharella.web.pages.domain.personne.ListPersonnesPage;
import nc.ird.cantharella.web.pages.domain.purification.ListPurificationsPage;
import nc.ird.cantharella.web.pages.domain.specimen.ListSpecimensPage;
import nc.ird.cantharella.web.pages.domain.station.ListStationsPage;
import nc.ird.cantharella.web.pages.domain.testBio.ListTestsBioPage;
import nc.ird.cantharella.web.pages.domain.utilisateur.UpdateUtilisateurPage;
import nc.ird.cantharella.web.utils.security.AuthContainer;
import nc.ird.cantharella.web.utils.security.AuthRole;
import nc.ird.cantharella.web.utils.security.AuthSession;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.IAjaxIndicatorAware;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.ResourceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TemplatePage
extends WebPage
implements IAjaxIndicatorAware,
IHeaderContributor {
    private static final String ACTION_LOGOUT = "Logout";
    private static final String ID_AJAX_INDICATOR = "AjaxIndicator";
    private static final Logger LOG = LoggerFactory.getLogger(TemplatePage.class);
    public static final String PATTERN_ENUM_VALUE_LABEL = "%s.%s";
    private static final String PATTERN_ERROR_ACTION_EXCEPTION = "%s.%s.%s";
    private static final String PATTERN_ERROR_MESSAGE = "%s.KO";
    private static final String PATTERN_ERROR_MESSAGE_VALIDATOR = "%s - %s";
    private static final String PATTERN_SUCCESS_ACTION_MESSAGE = "%s.%s.OK";
    private static final String YEAR = String.valueOf(Calendar.getInstance().get(1));
    private final MarkupContainer feedbackPanelContainer;
    private final String resource;

    protected TemplatePage(Class<? extends TemplatePage> page) {
        super(new PageParameters());
        AssertTools.assertNotNull(page);
        this.resource = page.getSimpleName();
        this.addPageTitles();
        this.add(new Component[]{new BookmarkablePageLink(HomePage.class.getSimpleName(), this.getApplication().getHomePage())});
        this.add(new Component[]{this.createUserSatellite()});
        this.add(new Component[]{this.createUserSearch()});
        this.add(new Component[]{this.createVisitorMenu()});
        this.add(new Component[]{this.createUserMenu()});
        this.createLanguageLinks();
        this.feedbackPanelContainer = new WebMarkupContainer("FeedbackPageContainer");
        this.feedbackPanelContainer.add(new Component[]{new FeedbackPanel("FeedbackPage")});
        this.feedbackPanelContainer.setOutputMarkupId(true);
        this.add(new Component[]{this.feedbackPanelContainer});
        this.add(new Component[]{new Label("Year", YEAR)});
        this.add(new Component[]{new BookmarkablePageLink(ContactPage.class.getSimpleName(), ContactPage.class)});
        this.add(new Component[]{new BookmarkablePageLink(ImprintPage.class.getSimpleName(), ImprintPage.class)});
        this.setVersioned(true);
        WebMarkupContainer bannerContainer = new WebMarkupContainer("TemplatePage.Banner");
        bannerContainer.setVisibilityAllowed(this.getApplication().getDebugSettings().isDevelopmentUtilitiesEnabled());
        this.add(new Component[]{bannerContainer});
    }

    public void renderHead(IHeaderResponse response) {
        response.render((HeaderItem)CssHeaderItem.forUrl((String)this.getString("TemplatePage.Css.Menu")));
        if (!this.getSession().getFeedbackMessages().isEmpty()) {
            response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)"location.hash='header'"));
        }
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)Application.get().getJavaScriptLibrarySettings().getJQueryReference()));
        response.render((HeaderItem)CssHeaderItem.forUrl((String)"colorbox/colorbox.css"));
        response.render((HeaderItem)JavaScriptHeaderItem.forUrl((String)"colorbox/jquery.colorbox-min.js"));
        response.render((HeaderItem)JavaScriptHeaderItem.forUrl((String)"js/imagebox.js"));
    }

    private void createLanguageLinks() {
        this.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        this.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
    }

    private AuthContainer createUserSatellite() {
        AuthContainer userSatellite = new AuthContainer("Satellite.USER", new AuthRole[]{AuthRole.USER, AuthRole.ADMIN});
        if (userSatellite.isAuthorized()) {
            BookmarkablePageLink link = new BookmarkablePageLink(UpdateUtilisateurPage.class.getSimpleName(), UpdateUtilisateurPage.class);
            link.add(new Component[]{new Label("Utilisateur", (IModel)new PropertyModel((Object)this, "session.utilisateur"))});
            userSatellite.add(new Component[]{link});
            userSatellite.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        }
        return userSatellite;
    }

    private AuthContainer createUserSearch() {
        AuthContainer userSatellite = new AuthContainer("Search.USER", new AuthRole[]{AuthRole.USER, AuthRole.ADMIN});
        Model searchModel = Model.of((Serializable)new SearchBean());
        4 searchForm = new /* Unavailable Anonymous Inner Class!! */;
        searchForm.add(new Component[]{new TextField("Search.query", (IModel)new PropertyModel((Object)searchModel, "query"))});
        userSatellite.add(new Component[]{searchForm});
        return userSatellite;
    }

    private AuthContainer createVisitorMenu() {
        AuthContainer visitorMenu = new AuthContainer("Menu.VISITOR", new AuthRole[]{AuthRole.VISITOR});
        return visitorMenu;
    }

    private AuthContainer createUserMenu() {
        AuthContainer userMenu = new AuthContainer("Menu.USER", new AuthRole[]{AuthRole.USER, AuthRole.ADMIN});
        if (userMenu.isAuthorized()) {
            userMenu.add(new Component[]{this.createAdminMenu()});
            userMenu.add(new Component[]{new BookmarkablePageLink(ListPersonnesPage.class.getSimpleName(), ListPersonnesPage.class)});
            userMenu.add(new Component[]{new BookmarkablePageLink(ListCampagnesPage.class.getSimpleName(), ListCampagnesPage.class)});
            userMenu.add(new Component[]{new BookmarkablePageLink(ListStationsPage.class.getSimpleName(), ListStationsPage.class)});
            userMenu.add(new Component[]{new BookmarkablePageLink(ListLotsPage.class.getSimpleName(), ListLotsPage.class)});
            userMenu.add(new Component[]{new BookmarkablePageLink(ListSpecimensPage.class.getSimpleName(), ListSpecimensPage.class)});
            userMenu.add(new Component[]{new BookmarkablePageLink(ListExtractionsPage.class.getSimpleName(), ListExtractionsPage.class)});
            userMenu.add(new Component[]{new BookmarkablePageLink(ListPurificationsPage.class.getSimpleName(), ListPurificationsPage.class)});
            userMenu.add(new Component[]{new BookmarkablePageLink(ListMoleculesPage.class.getSimpleName(), ListMoleculesPage.class)});
            userMenu.add(new Component[]{new BookmarkablePageLink(ListTestsBioPage.class.getSimpleName(), ListTestsBioPage.class)});
        }
        return userMenu;
    }

    private AuthContainer createAdminMenu() {
        AuthContainer adminMenu = new AuthContainer("Menu.ADMIN", new AuthRole[]{AuthRole.ADMIN});
        if (adminMenu.isAuthorized()) {
            adminMenu.add(new Component[]{new BookmarkablePageLink(ListConfigurationPage.class.getSimpleName(), ListConfigurationPage.class)});
        }
        return adminMenu;
    }

    private void addPageTitles() {
        IModel page = this.getStringModel(this.getResource(), new Object[0]);
        this.add(new Component[]{new Label("PageTitleHead", page)});
        this.add(new Component[]{new Label("PageTitleBody", page)});
    }

    public final void addValidationErrors(Collection<String> violations) {
        for (String violation : violations) {
            this.error((Serializable)((Object)violation));
        }
    }

    public final void addValidationErrors(List<Pair<String, String>> violations) {
        for (Pair<String, String> violation : violations) {
            String label = (String)violation.getKey();
            try {
                label = this.getString(label);
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
            this.error((Serializable)((Object)String.format(PATTERN_ERROR_MESSAGE_VALIDATOR, label, violation.getValue())));
        }
    }

    public final void errorCurrentPage(Class<? extends TemplatePage> pageClass, String action, Exception exception) {
        AssertTools.assertNotNull(pageClass);
        AssertTools.assertNotEmpty((String)action);
        AssertTools.assertNotNull((Object)exception);
        String errorMessage = this.getString(String.format(PATTERN_ERROR_ACTION_EXCEPTION, pageClass.getSimpleName(), action, exception.getClass().getSimpleName()));
        LOG.warn(errorMessage);
        this.error((Serializable)((Object)errorMessage));
    }

    public final void errorCurrentPage(Component component) {
        AssertTools.assertNotNull((Object)component);
        String errorMessage = String.format(PATTERN_ERROR_MESSAGE, component.getId());
        try {
            errorMessage = this.getString(errorMessage);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        LOG.warn(errorMessage);
        this.error((Serializable)((Object)errorMessage));
    }

    public final void errorCurrentPage(String action, Exception exception) {
        AssertTools.assertNotEmpty((String)action);
        AssertTools.assertNotNull((Object)exception);
        String errorMessage = this.getString(String.format(PATTERN_ERROR_ACTION_EXCEPTION, this.getResource(), action, exception.getClass().getSimpleName()));
        LOG.warn(errorMessage);
        this.error((Serializable)((Object)errorMessage));
    }

    public final String getAjaxIndicatorMarkupId() {
        return ID_AJAX_INDICATOR;
    }

    protected final String getResource() {
        return this.resource;
    }

    public final AuthSession getSession() {
        return (AuthSession)super.getSession();
    }

    public final void refreshFeedbackPage(AjaxRequestTarget target) {
        if (target != null) {
            target.add(new Component[]{this.feedbackPanelContainer});
            if (!this.getSession().getFeedbackMessages().isEmpty()) {
                LOG.debug("REFRESH FEEDBACK BY AJAX");
                target.appendJavaScript((CharSequence)"window.location.hash = '#header';");
                target.focusComponent((Component)this.feedbackPanelContainer);
            }
        }
    }

    public final void successCurrentPage(Class<? extends TemplatePage> pageClass, String action) {
        this.info((Serializable)((Object)this.successMessage(pageClass, action)));
    }

    public final void successCurrentPage(String action) {
        this.info((Serializable)((Object)this.successMessage(action)));
    }

    private String successMessage(Class<? extends TemplatePage> pageClass, String action) {
        AssertTools.assertNotNull(pageClass);
        AssertTools.assertNotEmpty((String)action);
        return this.getString(String.format(PATTERN_SUCCESS_ACTION_MESSAGE, pageClass.getSimpleName(), action));
    }

    private String successMessage(String action) {
        AssertTools.assertNotEmpty((String)action);
        return this.getString(String.format(PATTERN_SUCCESS_ACTION_MESSAGE, this.getResource(), action));
    }

    public final void successNextPage(Class<? extends TemplatePage> pageClass, String action) {
        this.getSession().info((Serializable)((Object)this.successMessage(pageClass, action)));
    }

    public final void successNextPage(String action) {
        this.getSession().info((Serializable)((Object)this.successMessage(action)));
    }

    public final <E extends Enum<?>> String enumValueMessage(E enumValue) {
        if (enumValue == null) {
            return null;
        }
        String enumValueMessage = String.format(PATTERN_ENUM_VALUE_LABEL, enumValue.getClass().getSimpleName(), enumValue.toString());
        return this.getString(enumValueMessage);
    }

    public IModel<String> getStringModel(String key, Object ... parameters) {
        return new StringResourceModel(key, (Component)this, null, parameters);
    }
}

