/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.service.utils.normalizers.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import nc.ird.cantharella.service.utils.normalizers.utils.Normalize;
import nc.ird.cantharella.service.utils.normalizers.utils.Normalizer;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public final class NormalizerAspect {
    private static final Logger LOG = LoggerFactory.getLogger(NormalizerAspect.class);

    @Around(value="execution(* nc.ird.cantharella.service.services.*Service.*(..,@Normalize (*),..))")
    public Object normalize(ProceedingJoinPoint joinPoint) throws Throwable {
        Method method = ((MethodSignature)joinPoint.getSignature()).getMethod();
        Object[] args = joinPoint.getArgs();
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            for (Annotation annotation : parameterAnnotations[i]) {
                if (!(annotation instanceof Normalize)) continue;
                args[i] = Normalizer.normalize(((Normalize)annotation).value(), args[i]);
                LOG.debug("normalize : '" + args[i] + "' in " + method.getDeclaringClass().getSimpleName() + "." + method.getName() + "(" + Arrays.asList(method.getParameterTypes()) + ")");
            }
        }
        return joinPoint.proceed(args);
    }
}

