/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.service.services.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import nc.ird.cantharella.data.dao.GenericDao;
import nc.ird.cantharella.data.dao.impl.StationDao;
import nc.ird.cantharella.data.exceptions.DataConstraintException;
import nc.ird.cantharella.data.exceptions.DataNotFoundException;
import nc.ird.cantharella.data.exceptions.UnexpectedException;
import nc.ird.cantharella.data.model.Campagne;
import nc.ird.cantharella.data.model.Lot;
import nc.ird.cantharella.data.model.Station;
import nc.ird.cantharella.data.model.Utilisateur;
import nc.ird.cantharella.data.model.utils.AbstractModel;
import nc.ird.cantharella.service.services.StationService;
import nc.ird.cantharella.utils.AssertTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public final class StationServiceImpl
implements StationService {
    private static final Logger LOG = LoggerFactory.getLogger(StationServiceImpl.class);
    @Autowired
    private GenericDao dao;

    @Override
    public long countStations() {
        return this.dao.count(Station.class);
    }

    @Override
    public void createStation(Station station) throws DataConstraintException {
        LOG.info("createStation " + station.getNom());
        this.dao.create((AbstractModel)station);
    }

    @Override
    public void deleteStation(Station station) throws DataConstraintException {
        LOG.info("deleteStation " + station.getIdStation());
        try {
            this.dao.delete((AbstractModel)station);
        }
        catch (DataNotFoundException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException((Exception)((Object)e));
        }
    }

    @Override
    public List<String> listStationLocalites() {
        return this.dao.list(StationDao.CRITERIA_DISTINCT_STATION_LOCALITES);
    }

    @Override
    public List<Station> listStations(Utilisateur utilisateur) {
        AssertTools.assertNotNull((Object)utilisateur);
        if (utilisateur.getTypeDroit() == Utilisateur.TypeDroit.ADMINISTRATEUR) {
            return this.dao.readList(Station.class, new String[]{"nom"});
        }
        SortedSet<Station> stations = this.listStationsForUser(utilisateur);
        return new ArrayList<Station>(stations);
    }

    @Override
    public SortedSet<Station> listStationsForUser(Utilisateur utilisateur) {
        TreeSet<Station> stations = new TreeSet<Station>();
        stations.addAll(utilisateur.getStationsCrees());
        ArrayList campagnes = new ArrayList();
        campagnes.addAll(utilisateur.getCampagnesCreees());
        campagnes.addAll(utilisateur.getCampagnesDroits().keySet());
        for (Campagne c : campagnes) {
            stations.addAll(c.getStations());
        }
        ArrayList lots = new ArrayList();
        lots.addAll(utilisateur.getLotsCrees());
        lots.addAll(utilisateur.getLotsDroits().keySet());
        for (Lot l : lots) {
            stations.add(l.getStation());
            if (l.getSpecimenRef().getStation() == null) continue;
            stations.add(l.getSpecimenRef().getStation());
        }
        return stations;
    }

    @Override
    public Station loadStation(Integer idStation) throws DataNotFoundException {
        AssertTools.assertNotNull((Object)idStation);
        return (Station)this.dao.read(Station.class, (Serializable)idStation);
    }

    @Override
    public Station loadStation(String nom) throws DataNotFoundException {
        AssertTools.assertNotEmpty((String)nom);
        return (Station)this.dao.read(Station.class, "nom", (Serializable)((Object)nom));
    }

    @Override
    public boolean updateOrdeleteStationEnabled(Station station, Utilisateur utilisateur) {
        return utilisateur.getTypeDroit() == Utilisateur.TypeDroit.ADMINISTRATEUR || utilisateur.getIdPersonne() == station.getCreateur().getIdPersonne();
    }

    @Override
    public void updateStation(Station station) throws DataConstraintException {
        LOG.info("updateStation " + station.getNom());
        try {
            this.dao.update((AbstractModel)station);
        }
        catch (DataNotFoundException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException((Exception)((Object)e));
        }
    }
}

