/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.service.services.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import nc.ird.cantharella.data.dao.GenericDao;
import nc.ird.cantharella.data.exceptions.DataConstraintException;
import nc.ird.cantharella.data.exceptions.DataNotFoundException;
import nc.ird.cantharella.data.exceptions.UnexpectedException;
import nc.ird.cantharella.data.model.Extraction;
import nc.ird.cantharella.data.model.Extrait;
import nc.ird.cantharella.data.model.Fraction;
import nc.ird.cantharella.data.model.MethodePurification;
import nc.ird.cantharella.data.model.ParamMethoPuri;
import nc.ird.cantharella.data.model.ParamMethoPuriEffectif;
import nc.ird.cantharella.data.model.Purification;
import nc.ird.cantharella.data.model.Utilisateur;
import nc.ird.cantharella.data.model.utils.AbstractModel;
import nc.ird.cantharella.service.services.ExtractionService;
import nc.ird.cantharella.service.services.PurificationService;
import nc.ird.cantharella.utils.AssertTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public final class PurificationServiceImpl
implements PurificationService {
    private static final Logger LOG = LoggerFactory.getLogger(PurificationServiceImpl.class);
    @Autowired
    private GenericDao dao;
    @Autowired
    private ExtractionService extractionService;

    @Override
    public long countPurifications() {
        return this.dao.count(Purification.class);
    }

    @Override
    public void createPurification(Purification purification) throws DataConstraintException {
        LOG.info("createPurification: " + purification.getRef());
        this.dao.create((AbstractModel)purification);
    }

    @Override
    public void initParamsMethoPuriEffectif(Purification purification) {
        AssertTools.assertNotNull((Object)purification);
        if (purification.getMethode() != null) {
            this.refreshMethodePurification(purification.getMethode());
            this.refreshMethodePurification(purification.getMethode());
            purification.getParamsMetho().clear();
            for (int paramInd = 0; paramInd < purification.getMethode().getParametres().size(); ++paramInd) {
                ParamMethoPuri paramMetho = (ParamMethoPuri)purification.getMethode().getParametres().get(paramInd);
                ParamMethoPuriEffectif effectifParam = new ParamMethoPuriEffectif();
                effectifParam.setParam(paramMetho);
                effectifParam.setPurification(purification);
                purification.getParamsMetho().add(effectifParam);
            }
        }
    }

    @Override
    public void deletePurification(Purification purification) throws DataConstraintException {
        AssertTools.assertNotNull((Object)purification);
        LOG.info("deletePurification: " + purification.getRef());
        try {
            this.dao.delete((AbstractModel)purification);
        }
        catch (DataNotFoundException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException((Exception)((Object)e));
        }
    }

    @Override
    public List<Purification> listPurifications(Utilisateur utilisateur) {
        AssertTools.assertNotNull((Object)utilisateur);
        if (utilisateur.getTypeDroit() == Utilisateur.TypeDroit.ADMINISTRATEUR) {
            return this.dao.readList(Purification.class, new String[]{"produit", "ref"});
        }
        return new ArrayList<Purification>(this.listPurificationsForUser(utilisateur));
    }

    @Override
    public SortedSet<Purification> listPurificationsForUser(Utilisateur utilisateur) {
        TreeSet<Purification> purifications = new TreeSet<Purification>();
        purifications.addAll(utilisateur.getPurificationsCrees());
        this.addAllPurificationsOfExtractions(purifications, this.extractionService.listExtractionsForUser(utilisateur));
        return purifications;
    }

    private void addAllPurificationsOfExtractions(Set<Purification> purifications, Set<Extraction> extractions) {
        for (Extraction curExtraction : extractions) {
            for (Extrait curExtrait : curExtraction.getExtraits()) {
                for (Purification curPurification : curExtrait.getPurificationsSuivantes()) {
                    purifications.add(curPurification);
                    LinkedList fractionsQueue = new LinkedList(curPurification.getFractions());
                    while (!fractionsQueue.isEmpty()) {
                        Fraction curFraction = (Fraction)fractionsQueue.remove();
                        for (Purification curPuriFromFraction : curFraction.getPurificationsSuivantes()) {
                            purifications.add(curPuriFromFraction);
                            fractionsQueue.addAll(curPuriFromFraction.getFractions());
                        }
                    }
                }
            }
        }
    }

    @Override
    public boolean isPurificationUnique(Purification purification) {
        Purification puriWithSameVal;
        AssertTools.assertNotNull((Object)purification);
        if (!this.dao.exists(Purification.class, "ref", (Serializable)((Object)purification.getRef()))) {
            return true;
        }
        try {
            puriWithSameVal = (Purification)this.dao.read(Purification.class, "ref", (Serializable)((Object)purification.getRef()));
            this.dao.evict((AbstractModel)puriWithSameVal);
        }
        catch (DataNotFoundException e) {
            return true;
        }
        return purification.getIdPurification() != null && purification.getIdPurification().equals(puriWithSameVal.getIdPurification());
    }

    @Override
    public Purification loadPurification(Integer idPurification) throws DataNotFoundException {
        return (Purification)this.dao.read(Purification.class, (Serializable)idPurification);
    }

    @Override
    public Purification loadPurification(String nom) throws DataNotFoundException {
        return (Purification)this.dao.read(Purification.class, "nom", (Serializable)((Object)nom));
    }

    @Override
    public void updatePurification(Purification purification) throws DataConstraintException {
        LOG.info("updatePurification: " + purification.getRef());
        try {
            this.dao.update((AbstractModel)purification);
        }
        catch (DataNotFoundException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException((Exception)((Object)e));
        }
    }

    @Override
    public void refreshPurification(Purification purification) {
        this.dao.refresh((AbstractModel)purification);
    }

    @Override
    public boolean updateOrdeletePurificationEnabled(Purification purification, Utilisateur utilisateur) {
        return utilisateur.getTypeDroit() == Utilisateur.TypeDroit.ADMINISTRATEUR || utilisateur.getIdPersonne() == purification.getCreateur().getIdPersonne();
    }

    @Override
    public void createMethodePurification(MethodePurification methode) throws DataConstraintException {
        LOG.info("createMethodePurification: " + methode.getNom());
        this.dao.create((AbstractModel)methode);
    }

    @Override
    public void deleteMethodePurification(MethodePurification methode) throws DataConstraintException {
        AssertTools.assertNotNull((Object)methode);
        LOG.info("deleteMethodePurification: " + methode.getNom());
        try {
            this.dao.delete((AbstractModel)methode);
        }
        catch (DataNotFoundException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException((Exception)((Object)e));
        }
    }

    @Override
    public List<MethodePurification> listMethodesPurification() {
        return this.dao.readList(MethodePurification.class, new String[]{"nom"});
    }

    @Override
    public MethodePurification loadMethodePurification(Integer idMethode) throws DataNotFoundException {
        return (MethodePurification)this.dao.read(MethodePurification.class, (Serializable)idMethode);
    }

    @Override
    public MethodePurification loadMethodePurification(String nom) throws DataNotFoundException {
        return (MethodePurification)this.dao.read(MethodePurification.class, "nom", (Serializable)((Object)nom));
    }

    @Override
    public void updateMethodePurification(MethodePurification methode) throws DataConstraintException {
        LOG.info("updateMethodePurification: " + methode.getNom());
        try {
            this.dao.update((AbstractModel)methode);
        }
        catch (DataNotFoundException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException((Exception)((Object)e));
        }
    }

    @Override
    public void refreshMethodePurification(MethodePurification methode) {
        AssertTools.assertNotNull((Object)methode);
        this.dao.refresh((AbstractModel)methode);
    }

    @Override
    public boolean isParamMethoPuriReferenced(ParamMethoPuri paramMetho) {
        AssertTools.assertNotNull((Object)paramMetho);
        AssertTools.assertNotNull((Object)paramMetho.getIdParamMethoPuri());
        return this.dao.count("select count(purif) from Purification purif inner join purif.paramsMetho paramsEff where paramsEff.id.pk2.idParamMethoPuri = ?", new Object[]{paramMetho.getIdParamMethoPuri()}) > 0L;
    }

    @Override
    public boolean isFractionUnique(Fraction fraction) {
        Fraction fractWithSameVal;
        AssertTools.assertNotNull((Object)fraction);
        if (!this.dao.exists(Fraction.class, "ref", (Serializable)((Object)fraction.getRef()))) {
            return true;
        }
        try {
            fractWithSameVal = (Fraction)this.dao.read(Fraction.class, "ref", (Serializable)((Object)fraction.getRef()));
            this.dao.evict((AbstractModel)fractWithSameVal);
        }
        catch (DataNotFoundException e) {
            return true;
        }
        return fraction.getId() != null && fraction.getId().equals(fractWithSameVal.getId());
    }
}

