/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.service.services.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Resource;
import nc.ird.cantharella.data.dao.GenericDao;
import nc.ird.cantharella.data.exceptions.DataConstraintException;
import nc.ird.cantharella.data.exceptions.DataNotFoundException;
import nc.ird.cantharella.data.exceptions.UnexpectedException;
import nc.ird.cantharella.data.model.Campagne;
import nc.ird.cantharella.data.model.Lot;
import nc.ird.cantharella.data.model.Partie;
import nc.ird.cantharella.data.model.Utilisateur;
import nc.ird.cantharella.data.model.utils.AbstractModel;
import nc.ird.cantharella.service.services.LotService;
import nc.ird.cantharella.utils.AssertTools;
import nc.ird.cantharella.utils.BeanTools;
import nc.ird.cantharella.utils.CollectionTools;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public final class LotServiceImpl
implements LotService {
    private static final Logger LOG = LoggerFactory.getLogger(LotServiceImpl.class);
    @Autowired
    private GenericDao dao;
    @Resource
    private SessionFactory sessionFactory;

    @Override
    public long countLots() {
        return this.dao.count(Lot.class);
    }

    @Override
    public void refreshLot(Lot lot) {
        AssertTools.assertNotNull((Object)lot);
        this.dao.refresh((AbstractModel)lot);
    }

    @Override
    public void createLot(Lot lot) throws DataConstraintException {
        LOG.info("createLot " + lot.getRef());
        this.dao.create((AbstractModel)lot);
    }

    @Override
    public void createPartie(Partie partie) throws DataConstraintException {
        LOG.info("createPartie: " + partie.getNom());
        this.dao.create((AbstractModel)partie);
    }

    @Override
    public void deleteLot(Lot lot) throws DataConstraintException {
        AssertTools.assertNotNull((Object)lot);
        LOG.info("deleteLot " + lot.getRef());
        try {
            this.dao.delete((AbstractModel)lot);
        }
        catch (DataNotFoundException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException((Exception)((Object)e));
        }
    }

    @Override
    public void deletePartie(Partie partie) throws DataConstraintException {
        AssertTools.assertNotNull((Object)partie);
        LOG.info("deletePartie: " + partie.getNom());
        try {
            this.dao.delete((AbstractModel)partie);
        }
        catch (DataNotFoundException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException((Exception)((Object)e));
        }
    }

    @Override
    public List<Lot> listLots(Utilisateur utilisateur) {
        AssertTools.assertNotNull((Object)utilisateur);
        if (utilisateur.getTypeDroit() == Utilisateur.TypeDroit.ADMINISTRATEUR) {
            return this.dao.readList(Lot.class, new String[]{"ref"});
        }
        return new ArrayList<Lot>(this.listLotsForUser(utilisateur));
    }

    @Override
    public SortedSet<Lot> listLotsForUser(Utilisateur utilisateur) {
        AssertTools.assertNotNull((Object)utilisateur);
        TreeSet<Lot> lots = new TreeSet<Lot>();
        for (Campagne c : utilisateur.getCampagnesCreees()) {
            lots.addAll(c.getLots());
        }
        for (Campagne c : utilisateur.getCampagnesDroits().keySet()) {
            lots.addAll(c.getLots());
        }
        lots.addAll(utilisateur.getLotsCrees());
        lots.addAll(utilisateur.getLotsDroits().keySet());
        return lots;
    }

    @Override
    public boolean updateOrdeleteLotEnabled(Lot lot, Utilisateur utilisateur) {
        return utilisateur.getTypeDroit() == Utilisateur.TypeDroit.ADMINISTRATEUR || utilisateur.getIdPersonne() == lot.getCreateur().getIdPersonne();
    }

    @Override
    public boolean isLotAccessibleByUser(Lot lot, Utilisateur utilisateur) {
        if (utilisateur.getTypeDroit() == Utilisateur.TypeDroit.ADMINISTRATEUR || utilisateur.equals(lot.getCreateur())) {
            return true;
        }
        if (utilisateur.getCampagnesCreees().contains(lot.getCampagne())) {
            return true;
        }
        if (CollectionTools.containsWithValue(utilisateur.getCampagnesDroits().keySet(), (String)"idCampagne", (BeanTools.AccessType)BeanTools.AccessType.GETTER, (Object)lot.getCampagne().getIdCampagne())) {
            return true;
        }
        return CollectionTools.containsWithValue(utilisateur.getLotsDroits().keySet(), (String)"idLot", (BeanTools.AccessType)BeanTools.AccessType.GETTER, (Object)lot.getIdLot());
    }

    @Override
    public List<Partie> listParties() {
        return this.dao.readList(Partie.class, new String[]{"nom"});
    }

    @Override
    public Lot loadLot(Integer idLot) throws DataNotFoundException {
        return (Lot)this.dao.read(Lot.class, (Serializable)idLot);
    }

    @Override
    public Lot loadLot(String ref) throws DataNotFoundException {
        AssertTools.assertNotEmpty((String)ref);
        return (Lot)this.dao.read(Lot.class, "ref", (Serializable)((Object)ref));
    }

    @Override
    public Partie loadPartie(Integer idPartie) throws DataNotFoundException {
        return (Partie)this.dao.read(Partie.class, (Serializable)idPartie);
    }

    @Override
    public Partie loadPartie(String nom) throws DataNotFoundException {
        return (Partie)this.dao.read(Partie.class, "nom", (Serializable)((Object)nom));
    }

    @Override
    public void updateLot(Lot lot) throws DataConstraintException {
        LOG.info("updateLot " + lot.getRef());
        try {
            this.dao.update((AbstractModel)lot);
        }
        catch (DataNotFoundException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException((Exception)((Object)e));
        }
    }

    @Override
    public void updatePartie(Partie partie) throws DataConstraintException {
        LOG.info("updatePartie: " + partie.getNom());
        try {
            this.dao.update((AbstractModel)partie);
        }
        catch (DataNotFoundException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException((Exception)((Object)e));
        }
    }
}

