/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.service.services;

import java.util.List;
import java.util.SortedSet;
import nc.ird.cantharella.data.exceptions.DataConstraintException;
import nc.ird.cantharella.data.exceptions.DataNotFoundException;
import nc.ird.cantharella.data.model.Fraction;
import nc.ird.cantharella.data.model.MethodePurification;
import nc.ird.cantharella.data.model.ParamMethoPuri;
import nc.ird.cantharella.data.model.Purification;
import nc.ird.cantharella.data.model.Utilisateur;
import nc.ird.cantharella.service.utils.normalizers.MethodePurificationNormalizer;
import nc.ird.cantharella.service.utils.normalizers.PurificationNormalizer;
import nc.ird.cantharella.service.utils.normalizers.UniqueFieldNormalizer;
import nc.ird.cantharella.service.utils.normalizers.utils.Normalize;
import org.springframework.transaction.annotation.Transactional;

public interface PurificationService {
    public long countPurifications();

    public void createPurification(@Normalize(value=PurificationNormalizer.class) Purification var1) throws DataConstraintException;

    public void initParamsMethoPuriEffectif(Purification var1);

    public void deletePurification(Purification var1) throws DataConstraintException;

    @Transactional(readOnly=true)
    public List<Purification> listPurifications(Utilisateur var1);

    public SortedSet<Purification> listPurificationsForUser(Utilisateur var1);

    @Transactional(readOnly=true)
    public boolean isPurificationUnique(Purification var1);

    public Purification loadPurification(Integer var1) throws DataNotFoundException;

    public Purification loadPurification(@Normalize(value=UniqueFieldNormalizer.class) String var1) throws DataNotFoundException;

    public void updatePurification(@Normalize(value=PurificationNormalizer.class) Purification var1) throws DataConstraintException;

    public void refreshPurification(Purification var1);

    public boolean updateOrdeletePurificationEnabled(Purification var1, Utilisateur var2);

    public void createMethodePurification(@Normalize(value=MethodePurificationNormalizer.class) MethodePurification var1) throws DataConstraintException;

    public void deleteMethodePurification(MethodePurification var1) throws DataConstraintException;

    @Transactional(readOnly=true)
    public List<MethodePurification> listMethodesPurification();

    public MethodePurification loadMethodePurification(Integer var1) throws DataNotFoundException;

    public MethodePurification loadMethodePurification(@Normalize(value=UniqueFieldNormalizer.class) String var1) throws DataNotFoundException;

    public void updateMethodePurification(@Normalize(value=MethodePurificationNormalizer.class) MethodePurification var1) throws DataConstraintException;

    public void refreshMethodePurification(MethodePurification var1);

    @Transactional(readOnly=true)
    public boolean isParamMethoPuriReferenced(ParamMethoPuri var1);

    @Transactional(readOnly=true)
    public boolean isFractionUnique(Fraction var1);
}

