/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.service.services;

import java.util.List;
import nc.ird.cantharella.data.exceptions.DataConstraintException;
import nc.ird.cantharella.data.exceptions.DataNotFoundException;
import nc.ird.cantharella.data.model.Molecule;
import nc.ird.cantharella.data.model.MoleculeProvenance;
import nc.ird.cantharella.data.model.Utilisateur;
import nc.ird.cantharella.service.model.MoleculeProvenanceBean;
import nc.ird.cantharella.service.utils.normalizers.MoleculeNormalizer;
import nc.ird.cantharella.service.utils.normalizers.utils.Normalize;
import org.springframework.transaction.annotation.Transactional;

public interface MoleculeService {
    @Transactional(readOnly=true)
    public long countMolecules();

    public void createMolecule(@Normalize(value=MoleculeNormalizer.class) Molecule var1) throws DataConstraintException;

    public void deleteMolecule(Molecule var1) throws DataConstraintException;

    @Transactional(readOnly=true)
    public List<Molecule> listMolecules();

    @Transactional(readOnly=true)
    public List<MoleculeProvenanceBean> listMoleculeProvenances(Utilisateur var1);

    public List<MoleculeProvenanceBean> listMoleculeProvenances(List<Molecule> var1, Utilisateur var2);

    @Transactional(readOnly=true)
    public Molecule loadMolecule(Integer var1) throws DataNotFoundException;

    public void updateMolecule(@Normalize(value=MoleculeNormalizer.class) Molecule var1) throws DataConstraintException;

    public boolean updateOrdeleteMoleculeEnabled(Molecule var1, Utilisateur var2);

    @Transactional(readOnly=true)
    public List<String> listMoleculeOrganisme();

    @Transactional(readOnly=true)
    public boolean isMoleculeProvenanceAccessibleByUser(MoleculeProvenance var1, Utilisateur var2);
}

