/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.data.model;

import java.math.BigDecimal;
import java.util.Comparator;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import nc.ird.cantharella.data.model.Document;
import nc.ird.cantharella.data.model.ErreurTestBio;
import nc.ird.cantharella.data.model.Extrait;
import nc.ird.cantharella.data.model.Fraction;
import nc.ird.cantharella.data.model.Lot;
import nc.ird.cantharella.data.model.Produit;
import nc.ird.cantharella.data.model.TestBio;
import nc.ird.cantharella.data.model.TypeExtrait;
import nc.ird.cantharella.data.model.utils.AbstractModel;
import nc.ird.cantharella.data.model.utils.DocumentAttachable;
import nc.ird.cantharella.data.validation.CollectionUniqueField;
import nc.ird.cantharella.utils.AssertTools;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ComparatorChain;
import org.hibernate.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;

@Entity
@CollectionUniqueField(fieldName="repere", pathToCollection="testBio.resultats")
@Indexed
public class ResultatTestBio
extends AbstractModel
implements Cloneable,
Comparable<ResultatTestBio>,
DocumentAttachable {
    @Id
    @GeneratedValue
    private Integer id;
    @Length(max=10)
    @NotEmpty
    private String repere;
    @NotNull
    @Enumerated(value=EnumType.ORDINAL)
    @Index(name="typeResultat")
    private TypeResultat typeResultat;
    @ManyToOne(fetch=FetchType.EAGER, optional=true)
    @IndexedEmbedded
    private Produit produit;
    @Length(max=60)
    private String produitTemoin;
    @Min(value=0L)
    @Max(value=99999L)
    @Column(precision=9, scale=4)
    private BigDecimal concMasse;
    @Enumerated(value=EnumType.ORDINAL)
    private UniteConcMasse uniteConcMasse;
    @Enumerated(value=EnumType.ORDINAL)
    private Stade stade;
    @Max(value=99999L)
    @Column(precision=9, scale=4)
    private BigDecimal valeur;
    private Boolean estActif;
    @ManyToOne(fetch=FetchType.EAGER, optional=true)
    private ErreurTestBio erreur;
    @NotNull
    @ManyToOne(fetch=FetchType.EAGER, optional=false)
    @IndexedEmbedded
    private TestBio testBio;
    @ManyToOne(fetch=FetchType.EAGER, optional=true)
    private TypeExtrait typeExtraitSource;

    public Lot getLotSource() {
        if (this.produit == null) {
            return null;
        }
        if (this.produit.isExtrait()) {
            Extrait extrait = (Extrait)this.produit;
            return extrait.getExtraction().getLot();
        }
        Fraction fraction = (Fraction)this.produit;
        return fraction.getPurification().getLotSource();
    }

    public ResultatTestBio clone() throws CloneNotSupportedException {
        ResultatTestBio clone = (ResultatTestBio)super.clone();
        clone.id = this.id;
        clone.repere = this.repere;
        clone.typeResultat = this.typeResultat;
        clone.produit = this.produit;
        clone.stade = this.stade;
        clone.estActif = this.estActif;
        clone.testBio = this.testBio;
        return clone;
    }

    public String toString() {
        return "(" + this.getRepere() + ", " + this.getTypeResultat() + ", " + (TypeResultat.PRODUIT.equals(this.getTypeResultat()) ? this.getProduit() : this.getProduitTemoin()) + ")";
    }

    @Override
    public final int compareTo(ResultatTestBio resultat) {
        ComparatorChain comparatorChain = new ComparatorChain();
        comparatorChain.addComparator((Comparator)new BeanComparator("testBio.methode.cible"));
        comparatorChain.addComparator((Comparator)new BeanComparator("produit"));
        comparatorChain.addComparator((Comparator)new BeanComparator("repere"));
        return comparatorChain.compare((Object)this, (Object)resultat);
    }

    public void setProduit(Produit produit) {
        this.typeExtraitSource = produit == null ? null : this.findExtraitSourceFromProduit(produit).getTypeExtrait();
        this.produit = produit;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getRepere() {
        return this.repere;
    }

    public void setRepere(String repere) {
        this.repere = repere;
    }

    public TypeResultat getTypeResultat() {
        return this.typeResultat;
    }

    public void setTypeResultat(TypeResultat typeResultat) {
        this.typeResultat = typeResultat;
    }

    public Produit getProduit() {
        return this.produit;
    }

    public String getProduitTemoin() {
        return this.produitTemoin;
    }

    public void setProduitTemoin(String produitTemoin) {
        this.produitTemoin = produitTemoin;
    }

    public BigDecimal getConcMasse() {
        return this.concMasse;
    }

    public void setConcMasse(BigDecimal concMasse) {
        this.concMasse = concMasse;
    }

    public UniteConcMasse getUniteConcMasse() {
        return this.uniteConcMasse;
    }

    public void setUniteConcMasse(UniteConcMasse uniteConcMasse) {
        this.uniteConcMasse = uniteConcMasse;
    }

    public Stade getStade() {
        return this.stade;
    }

    public void setStade(Stade stade) {
        this.stade = stade;
    }

    public BigDecimal getValeur() {
        return this.valeur;
    }

    public void setValeur(BigDecimal valeur) {
        this.valeur = valeur;
    }

    public Boolean isActif() {
        return this.estActif;
    }

    public void setActif(Boolean estActif) {
        this.estActif = estActif;
    }

    public ErreurTestBio getErreur() {
        return this.erreur;
    }

    public void setErreur(ErreurTestBio erreur) {
        this.erreur = erreur;
    }

    public TestBio getTestBio() {
        return this.testBio;
    }

    public void setTestBio(TestBio testBio) {
        this.testBio = testBio;
    }

    public TypeExtrait getTypeExtraitSource() {
        return this.typeExtraitSource;
    }

    public void setTypeExtraitSource(TypeExtrait typeExtraitSource) {
        this.typeExtraitSource = typeExtraitSource;
    }

    public Extrait findExtraitSourceFromProduit(Produit produit) {
        if (produit.isExtrait()) {
            Extrait extrait = (Extrait)produit;
            return extrait;
        }
        Produit curProd = produit;
        while (curProd.isFraction()) {
            Fraction curFraction = (Fraction)curProd;
            curProd = curFraction.getPurification().getProduit();
        }
        AssertTools.assertClassOrInterface((Object)curProd, Extrait.class);
        return (Extrait)curProd;
    }

    @Override
    public List<Document> getDocuments() {
        return this.testBio.getDocuments();
    }

    @Override
    public void addDocument(Document document) {
        this.testBio.addDocument(document);
    }

    @Override
    public void removeDocument(Document document) {
        this.testBio.removeDocument(document);
    }

    public static enum UniteConcMasse implements Comparable<UniteConcMasse>
    {
        MG,
        MICROG,
        NG,
        MG_ML,
        MICROG_ML,
        NG_ML;

    }

    public static enum Stade implements Comparable<Stade>
    {
        DETECTION,
        CONFIRMATION,
        FRACTIONNEMENT;

    }

    public static enum TypeResultat implements Comparable<TypeResultat>
    {
        BLANC,
        TEMOIN,
        PRODUIT;

    }
}

