/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.data.model;

import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import nc.ird.cantharella.data.model.MethodePurification;
import nc.ird.cantharella.data.model.utils.AbstractModel;
import nc.ird.cantharella.data.validation.CollectionUniqueField;
import org.apache.commons.beanutils.BeanComparator;
import org.hibernate.annotations.Type;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;

@Entity
@CollectionUniqueField(fieldName="nom", pathToCollection="methodePurification.parametres")
public class ParamMethoPuri
extends AbstractModel
implements Cloneable,
Comparable<ParamMethoPuri> {
    @Id
    @GeneratedValue
    private Integer idParamMethoPuri;
    @NotNull
    @Min(value=0L)
    private Integer index;
    @Length(max=60)
    @NotEmpty
    private String nom;
    @NotEmpty
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    private String description;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private MethodePurification methodePurification;

    public ParamMethoPuri clone() throws CloneNotSupportedException {
        ParamMethoPuri clone = (ParamMethoPuri)super.clone();
        clone.idParamMethoPuri = this.idParamMethoPuri;
        clone.nom = this.nom;
        clone.description = this.description;
        return clone;
    }

    public String toString() {
        return this.nom;
    }

    @Override
    public int compareTo(ParamMethoPuri paramMethoPuri) {
        return new BeanComparator("index").compare((Object)this, (Object)paramMethoPuri);
    }

    public Integer getIdParamMethoPuri() {
        return this.idParamMethoPuri;
    }

    public void setIdParamMethoPuri(Integer idParamMethoPuri) {
        this.idParamMethoPuri = idParamMethoPuri;
    }

    public Integer getIndex() {
        return this.index;
    }

    public void setIndex(Integer index) {
        this.index = index;
    }

    public String getNom() {
        return this.nom;
    }

    public void setNom(String nom) {
        this.nom = nom;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public MethodePurification getMethodePurification() {
        return this.methodePurification;
    }

    public void setMethodePurification(MethodePurification methodePurification) {
        this.methodePurification = methodePurification;
    }
}

