/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.data.config;

import javax.validation.Validation;
import javax.validation.ValidatorFactory;
import nc.ird.cantharella.data.validation.utils.ModelValidatorEventListener;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.PreInsertEventListener;
import org.hibernate.event.spi.PreUpdateEventListener;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.metamodel.source.MetadataImplementor;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationIntegrator
implements Integrator {
    private static final Logger LOG = LoggerFactory.getLogger(ValidationIntegrator.class);

    public void integrate(Configuration configuration, SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Registering validator into hibernate");
        }
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        ModelValidatorEventListener validationListener = new ModelValidatorEventListener(factory);
        EventListenerRegistry eventRegistry = (EventListenerRegistry)serviceRegistry.getService(EventListenerRegistry.class);
        eventRegistry.prependListeners(EventType.PRE_INSERT, (Object[])new PreInsertEventListener[]{validationListener});
        eventRegistry.prependListeners(EventType.PRE_UPDATE, (Object[])new PreUpdateEventListener[]{validationListener});
    }

    public void integrate(MetadataImplementor metadata, SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
        this.integrate((Configuration)null, sessionFactory, serviceRegistry);
    }

    public void disintegrate(SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
    }
}

