/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.list.impl.seine;

import fr.ird.observe.DataService;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.db.constants.DataContextType;
import fr.ird.observe.entities.seine.Route;
import fr.ird.observe.entities.seine.TripSeine;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.list.ContentListUIHandler;
import fr.ird.observe.ui.content.list.impl.seine.RoutesUI;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class RoutesUIHandler
extends ContentListUIHandler<TripSeine, Route> {
    private static Log log = LogFactory.getLog(RoutesUIHandler.class);

    public RoutesUIHandler(RoutesUI ui) {
        super(ui, DataContextType.TripSeine, DataContextType.Route);
    }

    @Override
    protected ContentMode getContentMode(DataContext dataContext) {
        String openTripId = dataContext.getOpenTripId();
        if (openTripId == null) {
            this.addInfoMessage(I18n.n((String)"observe.tripSeine.message.no.active.found", (Object[])new Object[0]));
            return ContentMode.READ;
        }
        boolean openRoute = dataContext.isOpenRoute();
        if (dataContext.isSelectedOpen(TripSeine.class)) {
            if (openRoute) {
                this.addInfoMessage(I18n.n((String)"observe.route.message.active.found", (Object[])new Object[0]));
                return ContentMode.UPDATE;
            }
            this.addInfoMessage(I18n.n((String)"observe.route.message.no.active.found", (Object[])new Object[0]));
            return ContentMode.CREATE;
        }
        if (openRoute) {
            this.addInfoMessage(I18n.n((String)"observe.route.message.active.found.for.other.trip", (Object[])new Object[0]));
        } else {
            this.addInfoMessage(I18n.n((String)"observe.route.message.no.active.found.for.other.trip", (Object[])new Object[0]));
        }
        return ContentMode.READ;
    }

    @Override
    protected List<Route> getChilds(TripSeine bean) throws DataSourceException {
        DataSource source = this.getDataSource();
        DataService dataService = this.getDataService();
        List list = dataService.getRouteStubByTrip(source, bean.getTopiaId());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will use " + list.size() + " routes."));
        }
        return list;
    }
}

