/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.admin.validate;

import com.google.common.base.Charsets;
import fr.ird.observe.DataService;
import fr.ird.observe.DecoratorService;
import fr.ird.observe.ObserveServiceHelper;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.db.model.DataSelectionModel;
import fr.ird.observe.entities.Trip;
import fr.ird.observe.entities.referentiel.Program;
import fr.ird.observe.entities.seine.TripSeine;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.admin.AdminStep;
import fr.ird.observe.ui.admin.AdminTabUI;
import fr.ird.observe.ui.admin.AdminTabUIHandler;
import fr.ird.observe.ui.admin.AdminUI;
import fr.ird.observe.ui.admin.AdminUIModel;
import fr.ird.observe.ui.admin.config.ConfigUI;
import fr.ird.observe.ui.admin.config.SelectDataUI;
import fr.ird.observe.ui.admin.validate.ValidateConfigUI;
import fr.ird.observe.ui.admin.validate.ValidateEntityListCellRenderer;
import fr.ird.observe.ui.admin.validate.ValidateModel;
import fr.ird.observe.ui.admin.validate.ValidateUI;
import fr.ird.observe.ui.util.ObserveSimpleValidatorMessageTableRenderer;
import fr.ird.observe.validation.ValidationContext;
import fr.ird.observe.validation.ValidationMessageDetector;
import fr.ird.observe.validation.ValidationModelMode;
import fr.ird.observe.validation.ValidatorsMap;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.Callable;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.wizard.WizardStep;
import jaxx.runtime.swing.wizard.ext.WizardState;
import jaxx.runtime.validator.swing.SimpleBeanValidatorMessageTableRenderer;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.decorator.Decorator;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityRef;
import org.nuiton.validator.NuitonValidatorScope;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;
import org.nuiton.validator.bean.simple.SimpleBeanValidatorEvent;
import org.nuiton.validator.bean.simple.SimpleBeanValidatorMessage;
import org.nuiton.validator.bean.simple.SimpleBeanValidators;

public class ValidateUIHandler
extends AdminTabUIHandler {
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final String LINE = "--------------------------------------------------------------------------------";
    private static final Log log = LogFactory.getLog(ValidateUIHandler.class);
    protected DataSource source;
    protected Decorator<TripSeine> dTrip;
    protected Decorator<Program> dProgram;

    public ValidateUIHandler(AdminTabUI ui) {
        super(ui);
    }

    public void initTabUI(AdminUI ui, ValidateUI tabUI) {
        super.initTabUI(ui, tabUI);
        if (log.isDebugEnabled()) {
            log.debug((Object)(" specialized for [" + (Object)((Object)tabUI.getStep()) + "] for main ui " + ui.getClass().getName() + "@" + System.identityHashCode(ui)));
        }
        SwingValidatorUtil.installUI((JTable)tabUI.getMessageTable(), (SimpleBeanValidatorMessageTableRenderer)new ObserveSimpleValidatorMessageTableRenderer());
        ValidateEntityListCellRenderer listRenderer = new ValidateEntityListCellRenderer(tabUI.getStepModel());
        tabUI.getTypeList().setCellRenderer(listRenderer);
        tabUI.getRefList().setCellRenderer(listRenderer);
        tabUI.getStartButton().setText(I18n.t((String)"observe.action.synchro.launch.operation", (Object[])new Object[]{I18n.t((String)tabUI.getStep().getOperationLabel(), (Object[])new Object[0])}));
        if (log.isInfoEnabled()) {
            log.info((Object)("Init extra configuration for " + tabUI.getName()));
        }
        ConfigUI configUI = (ConfigUI)ui.getStepUI(AdminStep.CONFIG);
        JAXXInitialContext tx = new JAXXInitialContext().add((Object)configUI).add((Object)this);
        ValidateConfigUI extraConfig = new ValidateConfigUI((JAXXContext)tx);
        configUI.getExtraConfig().add(extraConfig);
        final SelectDataUI selectTabUI = (SelectDataUI)ui.getStepUI(AdminStep.SELECT_DATA);
        this.getModel().getValidateModel().addPropertyChangeListener("modelMode", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ValidationModelMode value = (ValidationModelMode)evt.getNewValue();
                if (value == null) {
                    return;
                }
                DataSelectionModel selectDataModel = selectTabUI.getSelectDataModel();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("validation model changed to " + value));
                }
                switch (value) {
                    case REFERENTIEL: {
                        selectDataModel.setUseData(false);
                        selectDataModel.setUseReferentiel(true);
                        break;
                    }
                    case DATA: {
                        selectDataModel.setUseData(true);
                        selectDataModel.setUseReferentiel(false);
                        break;
                    }
                    case ALL: {
                        selectDataModel.setUseData(true);
                        selectDataModel.setUseReferentiel(true);
                    }
                }
            }
        });
        selectTabUI.getModel().addPropertyChangeListener("selectionModelChanged", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                AdminUIModel model = (AdminUIModel)((Object)evt.getSource());
                if (!model.containsStep((WizardStep)selectTabUI.getStep())) {
                    return;
                }
                DataSelectionModel value = (DataSelectionModel)evt.getNewValue();
                if (log.isInfoEnabled()) {
                    log.info((Object)("selection model changed to " + value));
                }
                ValidateUIHandler.this.updateSelectionModel(selectTabUI);
            }
        });
    }

    public void updateState(ValidateUI tabUI, WizardState newState) {
        super.updateState(tabUI, newState);
        if (newState == WizardState.NEED_FIX) {
            this.updateTypes();
            tabUI.resumeLabel.setText(I18n.t((String)"observe.synchro.validate.save.reportFile", (Object[])new Object[]{tabUI.getStepModel().getReportFile()}));
            String actionText = tabUI.getStepModel().isGenerateReport() ? I18n.t((String)"observe.synchro.save.report", (Object[])new Object[0]) : I18n.t((String)"observe.synchro.continue.with.no.save.report", (Object[])new Object[0]);
            tabUI.saveReport.setText(actionText);
            return;
        }
        if (newState == WizardState.RUNNING) {
            tabUI.typeList.clearSelection();
            tabUI.refList.clearSelection();
            tabUI.messageTable.clearSelection();
            tabUI.typeModel.clear();
            tabUI.refModel.clear();
            tabUI.messagesModel.clear();
            tabUI.messagesModel.clearValidators();
            for (SimpleBeanValidator v : tabUI.getStepModel().getValidators().values()) {
                tabUI.messagesModel.registerValidator(v);
            }
        }
        if (newState == WizardState.SUCCESSED) {
            // empty if block
        }
    }

    public void updateTypes() {
        ValidateUI tabUI = (ValidateUI)this.ui;
        DefaultListModel typeModel = tabUI.typeModel;
        tabUI.typeSelectionModel.clearSelection();
        typeModel.clear();
        Class[] classes = tabUI.getStepModel().getMessageTypes();
        for (Class e : classes = this.getDecoratorService().sortTypes(classes)) {
            typeModel.addElement(e);
        }
        tabUI.typeList.setSelectedIndex(0);
    }

    public void updateSelectedType() {
        ValidateUI tabUI = (ValidateUI)this.ui;
        this.getModel().setBusy(true);
        tabUI.refSelectionModel.clearSelection();
        tabUI.refModel.clear();
        Object o = tabUI.typeList.getSelectedValue();
        if (log.isInfoEnabled()) {
            log.info((Object)("new selected type = " + o));
        }
        if (o == null) {
            return;
        }
        Class type = (Class)o;
        List<TopiaEntityRef> refs = tabUI.getStepModel().getMessagesEntities(type);
        for (TopiaEntityRef ref : refs) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("add ref = " + ref));
            }
            tabUI.refModel.addElement(ref);
        }
        tabUI.refList.setSelectedIndex(0);
        this.getModel().setBusy(false);
    }

    public void updateSelectedRef() {
        ValidateUI tabUI = (ValidateUI)this.ui;
        tabUI.messageTable.clearSelection();
        tabUI.messagesModel.clear();
        Object o = tabUI.refList.getSelectedValue();
        if (log.isDebugEnabled()) {
            log.debug((Object)("new selected ref = " + o));
        }
        if (o == null) {
            return;
        }
        TopiaEntityRef ref = (TopiaEntityRef)o;
        if (log.isDebugEnabled()) {
            log.debug((Object)ref.getAccessorExpression());
        }
        for (SimpleBeanValidatorMessage<?> m : tabUI.getStepModel().getMessages(ref)) {
            SimpleBeanValidatorEvent evt = new SimpleBeanValidatorEvent(m.getValidator(), m.getField(), m.getScope(), new String[]{m.getMessage()}, EMPTY_STRING_ARRAY);
            tabUI.messagesModel.onFieldChanged(evt);
        }
    }

    public void startAction() {
        this.addAdminWorker(((ValidateUI)this.ui).getStartButton().getToolTipText(), new Callable<WizardState>(){

            @Override
            public WizardState call() throws Exception {
                return ValidateUIHandler.this.doAction();
            }
        });
    }

    public WizardState doAction() throws Exception {
        WizardState init;
        if (log.isDebugEnabled()) {
            log.debug((Object)this);
        }
        if ((init = this.initDB()) != null) {
            return init;
        }
        this.launchValidation();
        SortedMap<TopiaEntityRef, List<SimpleBeanValidatorMessage<?>>> refs = this.model.getValidateModel().getMessages();
        if (refs == null || refs.isEmpty()) {
            this.sendMessage(I18n.t((String)"observe.message.validation.nothing.to.do", (Object[])new Object[0]));
            this.sendMessage(I18n.t((String)"observe.message.validation.operation.done", (Object[])new Object[]{new Date()}));
            return WizardState.SUCCESSED;
        }
        this.sendMessage(I18n.t((String)"observe.message.validation.operation.needFix", (Object[])new Object[]{new Date()}));
        return WizardState.NEED_FIX;
    }

    protected WizardState initDB() throws Exception {
        this.source = this.getSource();
        DecoratorService decoratorService = this.getDecoratorService();
        this.dTrip = decoratorService.getDecoratorByType(TripSeine.class);
        this.dProgram = decoratorService.getDecoratorByType(Program.class);
        this.openSource(this.source);
        ValidateModel validationModel = this.model.getValidateModel();
        ValidatorsMap validators = validationModel.getValidators();
        this.sendMessage(I18n.t((String)"observe.message.validation.use.storage", (Object[])new Object[]{this.source.getLabel()}));
        this.sendMessage(I18n.t((String)"observe.message.validation.prepare.validators", (Object[])new Object[0]));
        if (!validators.isEmpty()) {
            for (SimpleBeanValidator v : validators.values()) {
                String label = I18n.t((String)DecoratorService.getEntityLabel((Class)v.getType()), (Object[])new Object[0]);
                this.sendMessage(I18n.t((String)"observe.message.validation.detected", (Object[])new Object[]{label}));
            }
        } else {
            this.sendMessage(I18n.t((String)"observe.message.no.validation.detected", (Object[])new Object[0]));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launchValidation() throws Exception {
        ValidateModel stepModel = this.model.getValidateModel();
        stepModel.setMessages(null);
        ValidatorsMap validators = stepModel.getValidators();
        ValidationMessageDetector detector = new ValidationMessageDetector(validators);
        DataSelectionModel dataModel = this.model.getSelectionDataModel();
        ValidationContext context = ObserveServiceHelper.getValidationContext();
        context.setDataSource(this.model.getLocalSource());
        context.setDataContext(this.model.getDataService().getDataContext());
        TopiaContext ctxt = this.beginTransaction(this.source, "launchValidation");
        try {
            if (dataModel.isUseReferentiel()) {
                this.validateReferentiel(detector, ctxt, dataModel);
            }
            if (dataModel.isUseData()) {
                this.validateData(detector, ctxt, dataModel);
            }
        }
        finally {
            context.setDataSource(null);
            SortedMap refs = detector.getRefs();
            stepModel.setMessages(refs);
            detector.clear();
            this.closeTransaction(this.source, ctxt, "launchValidation");
        }
    }

    private void validateData(ValidationMessageDetector detector, TopiaContext ctxt, DataSelectionModel dataModel) throws TopiaException {
        Set data = dataModel.getSelectedData();
        for (String id : data) {
            Trip e = (Trip)ctxt.findByTopiaId(id);
            Program p = e.getProgram();
            this.sendMessage(I18n.t((String)"observe.message.validation.start.maree", (Object[])new Object[]{this.dTrip.toString((Object)e), this.dProgram.toString((Object)p)}));
            detector.detectMessages(new TopiaEntity[]{e});
        }
    }

    protected void validateReferentiel(ValidationMessageDetector detector, TopiaContext ctxt, DataSelectionModel dataModel) throws DataSourceException, TopiaException {
        DataService dataService = this.getDataService();
        Set classes = dataModel.getSelectedReferentiel();
        Iterator i$ = classes.iterator();
        while (i$.hasNext()) {
            Class klass;
            Class refClass = klass = (Class)i$.next();
            List ids = dataService.getEntityIds(this.source, refClass);
            String entityLabel = I18n.t((String)DecoratorService.getEntityLabel((Class)klass), (Object[])new Object[0]);
            this.sendMessage(I18n.t((String)"observe.message.validation.start.referentiel", (Object[])new Object[]{entityLabel, ids.size()}));
            for (String id : ids) {
                TopiaEntity e = ctxt.findByTopiaId(id);
                detector.detectMessages(new TopiaEntity[]{e});
            }
            ids.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveReport() {
        WizardState finalState = null;
        ValidateModel validationModel = this.model.getValidateModel();
        try {
            if (validationModel.isGenerateReport()) {
                this.sendMessage(I18n.t((String)"observe.message.validation.save.report", (Object[])new Object[]{validationModel.getReportFile()}));
                this.generateReportFile(validationModel);
            } else {
                this.sendMessage(I18n.t((String)"observe.message.validation.not.save.report", (Object[])new Object[0]));
            }
            finalState = WizardState.SUCCESSED;
        }
        catch (Exception e) {
            try {
                validationModel.setError(e);
                finalState = WizardState.FAILED;
            }
            catch (Throwable throwable) {
                this.model.setStepState(AdminStep.VALIDATE, finalState);
                throw throwable;
            }
            this.model.setStepState(AdminStep.VALIDATE, finalState);
        }
        this.model.setStepState(AdminStep.VALIDATE, finalState);
    }

    public void generateReportFile(ValidateModel validationModel) throws IOException {
        File reportFile = validationModel.getReportFile();
        if (log.isInfoEnabled()) {
            log.info((Object)("save report in " + reportFile));
        }
        DecoratorService service = this.getDecoratorService();
        StringBuilder builder = new StringBuilder();
        builder.append(LINE).append('\n');
        builder.append(I18n.t((String)"observe.validation.report.title", (Object[])new Object[]{new Date()})).append('\n');
        builder.append(I18n.t((String)"observe.validation.report.scopes", (Object[])new Object[]{validationModel.getScopes()})).append('\n');
        builder.append(I18n.t((String)"observe.validation.report.contextName", (Object[])new Object[]{validationModel.getContextName()})).append('\n');
        SortedMap<TopiaEntityRef, List<SimpleBeanValidatorMessage<?>>> messages = validationModel.getMessages();
        builder.append(I18n.t((String)"observe.validation.report.entities.with.messages", (Object[])new Object[]{messages.size()})).append('\n');
        builder.append(LINE).append('\n').append('\n');
        for (Map.Entry<TopiaEntityRef, List<SimpleBeanValidatorMessage<?>>> entry : messages.entrySet()) {
            TopiaEntityRef ref = entry.getKey();
            String refStr = service.decorate((Object)ref.getRef());
            List<SimpleBeanValidatorMessage<?>> refMessages = entry.getValue();
            EnumSet scopes = SimpleBeanValidators.getScopes(refMessages);
            builder.append(I18n.t((String)"observe.validation.report.entity", (Object[])new Object[]{ref.getRef().getTopiaId(), refStr, refMessages.size(), scopes})).append('\n');
            for (NuitonValidatorScope scope : scopes) {
                List<SimpleBeanValidatorMessage<?>> messagesByScope = this.filterMessages(scope, refMessages);
                for (SimpleBeanValidatorMessage<?> message : messagesByScope) {
                    builder.append(message).append('\n');
                }
                builder.append('\n');
            }
            builder.append(LINE).append('\n').append('\n');
        }
        String content = builder.toString();
        if (log.isInfoEnabled()) {
            log.info((Object)content);
        }
        FileUtils.write((File)reportFile, (CharSequence)content, (String)Charsets.UTF_8.name());
    }

    private List<SimpleBeanValidatorMessage<?>> filterMessages(NuitonValidatorScope scope, List<SimpleBeanValidatorMessage<?>> refMessages) {
        ArrayList result = new ArrayList();
        for (SimpleBeanValidatorMessage<?> message : refMessages) {
            if (!message.getScope().equals((Object)scope)) continue;
            result.add(message);
        }
        return result;
    }

    public void updateValidationScopes(JCheckBox checkBox) {
        NuitonValidatorScope scope = this.getValidatorScope(checkBox);
        ValidateModel validateModel = this.getModel().getValidateModel();
        if (checkBox.isSelected()) {
            validateModel.addScope(scope);
        } else {
            validateModel.removeScope(scope);
        }
    }

    public ComboBoxModel updateComboModel(Object ... datas) {
        if (datas == null) {
            return new DefaultComboBoxModel();
        }
        return new DefaultComboBoxModel<Object>(datas);
    }

    public String updateValidatorResumeLabel(boolean valid) {
        ValidateModel validateModel = this.getModel().getValidateModel();
        if (validateModel == null || validateModel.getValidators() == null) {
            return null;
        }
        return I18n.t((String)"observe.common.selected.validators", (Object[])new Object[]{validateModel.getValidators().size()});
    }

    public AdminStep getObjectOperation(JCheckBox checkBox) {
        return AdminStep.valueOf(checkBox.getName());
    }

    public NuitonValidatorScope getValidatorScope(JCheckBox checkBox) {
        return (NuitonValidatorScope)checkBox.getClientProperty("value");
    }

    public boolean isScopeSelected(Set<NuitonValidatorScope> scopes, JCheckBox checkBox) {
        NuitonValidatorScope scope = this.getValidatorScope(checkBox);
        return scopes.contains(scope);
    }

    public boolean isObjectOperationSelected(Set<AdminStep> objectOperations, JCheckBox checkBox) {
        AdminStep scope = this.getObjectOperation(checkBox);
        return objectOperations.contains((Object)this.getObjectOperation(checkBox));
    }

    public void chooseValidationReportFile(ValidateConfigUI configUI) {
        File f = UIHelper.chooseDirectory(configUI, I18n.t((String)"observe.title.choose.report.directory", (Object[])new Object[0]), I18n.t((String)"observe.action.choose.report.directory", (Object[])new Object[0]), new File(configUI.validationReportDirectoryText.getText()));
        this.changeValidationReportDirectory(configUI, f);
    }

    public void changeValidationReportDirectory(ValidateConfigUI configUI, File f) {
        this.getModel().getValidateModel().setReportFile(new File(f, configUI.validationReportFilenameText.getText()));
    }

    public void changeValidationReportFilename(ValidateConfigUI configUI, String filename) {
        this.getModel().getValidateModel().setReportFile(new File(configUI.validationReportDirectoryText.getText(), filename));
    }

    public String updateReferentielPolicy(boolean valid) {
        if (!valid) {
            return I18n.t((String)"observe.common.storage.not.valid", (Object[])new Object[0]);
        }
        return this.model.getCentralSourceModel().getPgConfig().getPolicyLabel();
    }
}

