/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.actions;

import fr.ird.observe.ObserveContext;
import fr.ird.observe.db.constants.DbMode;
import fr.ird.observe.ui.ObserveMainUI;
import fr.ird.observe.ui.storage.StorageUILauncher;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.SwingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ChangeStorageAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ChangeStorageAction.class);
    private final ObserveMainUI ui;
    private final DbMode dbMode;
    private final String title;

    public ChangeStorageAction(ObserveMainUI ui) {
        this(ui, null, null);
    }

    public ChangeStorageAction(ObserveMainUI ui, DbMode dbMode, String title) {
        super(I18n.t((String)"observe.action.change.storage", (Object[])new Object[0]), SwingUtil.getUIManagerActionIcon((String)"db-change"));
        this.ui = ui;
        this.dbMode = dbMode;
        this.title = title;
        this.putValue("ShortDescription", I18n.t((String)"observe.action.change.storage.tip", (Object[])new Object[0]));
        this.putValue("MnemonicKey", 67);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.run();
    }

    public void run() {
        boolean canContinue = ObserveContext.get().closeSelectedContentUI(this.ui);
        if (canContinue) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Start change storage with dbMode: " + this.dbMode));
            }
            StorageUILauncher.changeStorage((JAXXContext)this.ui, this.ui, this.dbMode, I18n.t((String)this.title, (Object[])new Object[0]));
        }
    }
}

