/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.actions;

import fr.ird.observe.ui.ObserveMainUI;
import fr.ird.observe.ui.ObserveUIMode;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import jaxx.runtime.SwingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.h2.tools.Server;
import org.nuiton.i18n.I18n;

public class StopServerModeAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(StopServerModeAction.class);
    private final ObserveMainUI ui;

    public StopServerModeAction(ObserveMainUI ui) {
        super(I18n.t((String)"observe.action.stop.server.mode", (Object[])new Object[0]), SwingUtil.getUIManagerActionIcon((String)"db-stop-server"));
        this.ui = ui;
        this.putValue("ShortDescription", I18n.t((String)"observe.action.stop.server.mode.tip", (Object[])new Object[0]));
        this.putValue("MnemonicKey", 83);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Server server;
        if (log.isInfoEnabled()) {
            log.info((Object)"Will stop server mode...");
        }
        if ((server = this.ui.getContextValue(Server.class, "server")) != null) {
            server.stop();
        }
        this.ui.setMode(ObserveUIMode.NO_DB);
        if (this.ui.isH2WebServer().booleanValue()) {
            this.launchStopH2WebServer(this.ui);
        }
    }

    public void launchStopH2WebServer(ObserveMainUI ui) {
        if (ui.isH2WebServer().booleanValue()) {
            Server server;
            if (log.isInfoEnabled()) {
                log.info((Object)"Will stop web server mode...");
            }
            if ((server = ui.getContextValue(Server.class, "webServer")) != null) {
                server.stop();
            }
            ui.setH2WebServer(false);
        } else if (log.isWarnEnabled()) {
            log.warn((Object)"Can not stop h2 web server... (no web server found)");
        }
    }
}

