/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.admin.export;

import com.google.common.collect.ImmutableList;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.model.DataSelectionModel;
import fr.ird.observe.entities.Trip;
import fr.ird.observe.entities.longline.TripLongline;
import fr.ird.observe.entities.referentiel.Program;
import fr.ird.observe.entities.seine.TripSeine;
import fr.ird.observe.ui.admin.AdminActionModel;
import fr.ird.observe.ui.admin.AdminStep;
import fr.ird.observe.ui.admin.export.TripEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.nuiton.decorator.Decorator;

public class ExportModel
extends AdminActionModel {
    protected int[] exportDataSelectedIndex;
    protected List<String> existingTripIds;
    protected List<TripEntry> data;
    protected Decorator<Program> programDecorator;
    protected Decorator<TripSeine> tripSeineDecorator;
    protected Decorator<TripLongline> tripLonglineDecorator;
    protected DataSource source;
    protected DataSource centralSource;

    public ExportModel() {
        super(AdminStep.EXPORT_DATA);
    }

    public void setExportDataSelectedIndex(int ... exportDataSelectedIndex) {
        this.exportDataSelectedIndex = exportDataSelectedIndex;
    }

    public List<String> getExistingTripIds() {
        return this.existingTripIds;
    }

    public void setExistingTripIds(List<String> existingTripIds) {
        this.existingTripIds = existingTripIds;
    }

    public void destroy() {
        super.destroy();
        if (this.existingTripIds != null) {
            this.existingTripIds.clear();
            this.existingTripIds = null;
        }
        this.exportDataSelectedIndex = null;
        this.tripSeineDecorator = null;
        this.data = null;
        this.centralSource = null;
        this.source = null;
    }

    public List<TripEntry> getData() {
        return this.data;
    }

    public void setData(DataSelectionModel selectionModel) {
        ArrayList<TripEntry> tripEntries = new ArrayList<TripEntry>();
        for (List tripIds : selectionModel.getSelectedDataByProgram().values()) {
            if (!CollectionUtils.isNotEmpty((Collection)tripIds)) continue;
            for (String tripId : tripIds) {
                Trip trip = (Trip)selectionModel.getEntityCache(tripId);
                boolean exists = this.existingTripIds.contains(trip.getTopiaId());
                TripEntry entry = new TripEntry(trip, exists);
                tripEntries.add(entry);
            }
        }
        this.data = ImmutableList.copyOf(tripEntries);
    }

    public DataSource getSource() {
        return this.source;
    }

    public void setSource(DataSource source) {
        this.source = source;
    }

    public DataSource getCentralSource() {
        return this.centralSource;
    }

    public void setCentralSource(DataSource centralSource) {
        this.centralSource = centralSource;
    }

    public void setProgramDecorator(Decorator<Program> programDecorator) {
        this.programDecorator = programDecorator;
    }

    public void setTripSeineDecorator(Decorator<TripSeine> mareeDecorator) {
        this.tripSeineDecorator = mareeDecorator;
    }

    public void setTripLonglineDecorator(Decorator<TripLongline> tripLonglineDecorator) {
        this.tripLonglineDecorator = tripLonglineDecorator;
    }

    public String decorate(Trip trip) {
        return trip instanceof TripSeine ? this.tripSeineDecorator.toString((Object)trip) : this.tripLonglineDecorator.toString((Object)trip);
    }

    public String decorate(Program program) {
        return this.programDecorator.toString((Object)program);
    }

    public List<TripEntry> getSelectedTrips() {
        ArrayList<TripEntry> entries = new ArrayList<TripEntry>();
        for (int index : this.exportDataSelectedIndex) {
            entries.add(this.data.get(index));
        }
        return entries;
    }
}

