/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content;

import fr.ird.observe.BinderService;
import fr.ird.observe.DataService;
import fr.ird.observe.DecoratorService;
import fr.ird.observe.ObserveContext;
import fr.ird.observe.ObserveServiceHelper;
import fr.ird.observe.ObserveTechnicalException;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.constants.DataContextType;
import fr.ird.observe.db.util.TopiaExecutor;
import fr.ird.observe.db.util.TopiaExecutor2;
import fr.ird.observe.entities.referentiel.ReferenceEntity;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.actions.shared.AbstractUIAction;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.ContentUI;
import fr.ird.observe.ui.content.ContentUIInitializer;
import fr.ird.observe.ui.content.ContentUIModel;
import fr.ird.observe.ui.content.ObserveContentUI;
import fr.ird.observe.ui.content.ref.ContentReferenceUIHandler;
import fr.ird.observe.ui.tree.AbstractObserveTreeCellRenderer;
import fr.ird.observe.ui.tree.ObserveNode;
import fr.ird.observe.ui.tree.ObserveTreeHelper;
import fr.ird.observe.util.DBHelper;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.editor.bean.BeanListHeader;
import jaxx.runtime.swing.nav.NavNode;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.decorator.DecoratorUtil;
import org.nuiton.decorator.JXPathDecorator;
import org.nuiton.decorator.MultiJXPathDecorator;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.widgets.gis.absolute.CoordinatesEditor;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;
import org.nuiton.validator.NuitonValidatorScope;

public abstract class ContentUIHandler<E extends TopiaEntity> {
    private static final Log log = LogFactory.getLog(ContentUIHandler.class);
    protected final String prefix;
    private final TopiaExecutor<E> loadExecutor;
    private final TopiaExecutor2<? extends TopiaEntity, E> preCreateExecutor;
    private final TopiaExecutor2<? extends TopiaEntity, E> createExecutor;
    private final TopiaExecutor2<? extends TopiaEntity, E> updateExecutor;
    private final TopiaExecutor2<? extends TopiaEntity, E> deleteExecutor;
    private final DataContextType parentType;
    private final DataContextType type;
    private final Icon errorIcon;
    protected ObserveContentUI<E> ui;

    public ContentUIHandler(ObserveContentUI<E> ui, DataContextType parentType, DataContextType type) {
        this.ui = ui;
        this.parentType = parentType;
        this.type = type;
        this.prefix = "[" + ui.getClass().getSimpleName() + "] ";
        if (log.isDebugEnabled()) {
            log.debug((Object)("New handler [" + this + "] for ui " + this.prefix));
        }
        this.loadExecutor = new TopiaExecutor<E>(){

            public void execute(TopiaContext tx, E bean) throws TopiaException {
                ContentUIHandler.this.onLoad(tx, bean);
            }
        };
        this.preCreateExecutor = new TopiaExecutor2<TopiaEntity, E>(){

            public E execute(TopiaContext tx, TopiaEntity parentBean, E bean) throws TopiaException {
                return ContentUIHandler.this.onPreCreate(tx, parentBean, bean);
            }
        };
        this.createExecutor = new TopiaExecutor2<TopiaEntity, E>(){

            public E execute(TopiaContext tx, TopiaEntity parentBean, E bean) throws TopiaException {
                return ContentUIHandler.this.onCreate(tx, parentBean, bean);
            }
        };
        this.updateExecutor = new TopiaExecutor2<TopiaEntity, E>(){

            public E execute(TopiaContext tx, TopiaEntity parentBean, E bean) throws TopiaException {
                return ContentUIHandler.this.onUpdate(tx, parentBean, bean);
            }
        };
        this.deleteExecutor = new TopiaExecutor2<TopiaEntity, E>(){

            public E execute(TopiaContext tx, TopiaEntity parentBean, E beanToDelete) throws TopiaException {
                ContentUIHandler.this.onDelete(tx, parentBean, beanToDelete);
                return null;
            }
        };
        this.errorIcon = UIManager.getIcon("action.error");
    }

    public static <E extends TopiaEntity> ContentUIHandler<E> newHandler(ObserveContentUI<E> ui) {
        String uiName = ui.getClass().getName();
        String modelName = uiName + "Handler";
        try {
            Class<?> handlerClass = Class.forName(modelName);
            ContentUIHandler handler = (ContentUIHandler)ConstructorUtils.invokeConstructor(handlerClass, (Object[])new Object[]{ui});
            return handler;
        }
        catch (Exception e) {
            throw new ObserveTechnicalException("Could not create handler for ui: " + ui, (Throwable)e);
        }
    }

    protected static void attachTopiaContext(DataSource service, TopiaEntityAbstract entity) {
        DBHelper.attachTopiaContext((TopiaContext)service.getRootCtxt(), (TopiaEntityAbstract)entity);
    }

    public static ObserveTreeHelper getTreeHelper(JAXXContext context) {
        return (ObserveTreeHelper)((Object)context.getContextValue(ObserveTreeHelper.class));
    }

    public static boolean checkEdit(ObserveContentUI<?> ui) {
        ContentUIModel<?> model = ui.getModel();
        if (model.isCreatingMode()) {
            if (!model.isEnabled() || !model.isEditing() || !model.isModified() && model.isValid()) {
                if (model.isEditing()) {
                    ui.stopEdit();
                }
                return true;
            }
        } else if (!(model.isEnabled() && model.isEditing() && model.isModified())) {
            if (model.isEditing()) {
                ui.stopEdit();
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"previousUI is in edit mode");
        }
        boolean wasClosed = true;
        if (model.isValid()) {
            int reponse = UIHelper.askUser((JComponent)((Object)ui), I18n.t((String)"observe.title.need.confirm", (Object[])new Object[0]), I18n.t((String)"observe.message.quit.valid.edit", (Object[])new Object[0]), 2, new Object[]{I18n.t((String)"observe.choice.save", (Object[])new Object[0]), I18n.t((String)"observe.choice.doNotSave", (Object[])new Object[0]), I18n.t((String)"observe.choice.cancel", (Object[])new Object[0])}, 0);
            if (log.isDebugEnabled()) {
                log.debug((Object)("response : " + reponse));
            }
            switch (reponse) {
                case -1: 
                case 2: {
                    wasClosed = false;
                    break;
                }
                case 0: {
                    ui.save(false);
                    break;
                }
                case 1: {
                    ui.resetEdit();
                }
            }
        } else {
            int reponse = UIHelper.askUser((JComponent)((Object)ui), I18n.t((String)"observe.title.need.confirm", (Object[])new Object[0]), I18n.t((String)"observe.message.quit.invalid.edit", (Object[])new Object[0]), 0, new Object[]{I18n.t((String)"observe.choice.continue", (Object[])new Object[0]), I18n.t((String)"observe.choice.cancel", (Object[])new Object[0])}, 0);
            if (log.isDebugEnabled()) {
                log.debug((Object)("response : " + reponse));
            }
            switch (reponse) {
                case -1: 
                case 1: {
                    wasClosed = false;
                    break;
                }
                case 0: {
                    ui.resetEdit();
                }
            }
        }
        if (wasClosed) {
            ui.stopEdit();
        }
        return wasClosed;
    }

    public static void addMessage(ObserveContentUI<?> ui, NuitonValidatorScope scope, String fieldName, String message) {
        SwingValidatorMessageTableModel model = ui.getErrorTableModel();
        model.addMessages((JComponent)((Object)ui), fieldName, scope, new String[]{message});
    }

    public static void removeAllMessages(ContentUI<?> ui, NuitonValidatorScope scope, String fieldName) {
        SwingValidatorMessageTableModel model = ui.getErrorTableModel();
        model.removeMessages(ui, fieldName, scope);
    }

    public static void removeAllMessages(ObserveContentUI<?> ui) {
        SwingValidatorMessageTableModel model = ui.getErrorTableModel();
        model.removeMessages((JComponent)((Object)ui), null);
    }

    protected abstract ContentMode getContentMode(DataContext var1);

    protected abstract boolean computeCanWrite(DataSource var1);

    protected final String getSelectedParentId() {
        String s = null;
        if (this.parentType != null) {
            s = this.parentType.getSelectedId(this.getDataContext());
        }
        return s;
    }

    protected final String getSelectedId() {
        String s = null;
        if (this.type != null) {
            s = this.type.getSelectedId(this.getDataContext());
        }
        return s;
    }

    public ObserveContentUI<E> getUi() {
        return this.ui;
    }

    public ContentUIModel<E> getModel() {
        return this.getUi().getModel();
    }

    public Class<E> getBeanType() {
        Class<E> mainEntityClass = this.getModel().getBeanType();
        return mainEntityClass;
    }

    public E getBean() {
        ContentUIModel<E> model = this.getModel();
        E bean = model.getBean();
        return bean;
    }

    protected DataContext getDataContext() {
        DataContext dataContext = this.ui.getDataContext();
        return dataContext;
    }

    public DecoratorService getDecoratorService() {
        DecoratorService result = ObserveContext.get().getDecoratorService();
        return result;
    }

    public BinderService getBinderService() {
        return ObserveContext.get().getBinderService();
    }

    protected DataSource getDataSource() {
        return this.ui.getDataSource();
    }

    public void initUI() throws Exception {
        ContentUIInitializer uiInitializer = new ContentUIInitializer(this.ui);
        uiInitializer.initUI(this.getDataSource());
    }

    public void openUI() throws Exception {
        boolean canWrite = this.computeCanWrite(this.getDataSource());
        this.getModel().setCanWrite(canWrite);
        ObserveServiceHelper.getValidationContext().cleanCache();
        if (log.isDebugEnabled()) {
            log.debug((Object)("ui " + this.ui.getClass()));
        }
        ContentUIHandler.removeAllMessages(this.ui);
        ObserveTreeHelper treeHelper = ContentUIHandler.getTreeHelper(this.ui);
        AbstractObserveTreeCellRenderer render = treeHelper.getTreeCellRenderer();
        ObserveNode node = (ObserveNode)treeHelper.getSelectedNode();
        if (ContentReferenceUIHandler.class.isAssignableFrom(this.getClass())) {
            node = (ObserveNode)node.getParent();
        }
        this.ui.setContentIcon(render.getNavigationIcon(node));
        this.updateActions();
    }

    public Icon getErrorIconIfFalse(boolean valid) {
        Icon icon = null;
        if (!valid) {
            icon = this.errorIcon;
        }
        return icon;
    }

    protected void onLoad(TopiaContext tx, E bean) throws TopiaException {
        this.getLoadBinder().load(bean, this.getBean(), true, new String[0]);
    }

    protected E onPreCreate(TopiaContext tx, Object parentBean, E bean) throws TopiaException {
        return bean;
    }

    public void startEditUI(String ... binding) {
        E editBean = this.getBean();
        this.prepareValidationContext();
        SwingValidatorUtil.setValidatorBean(this.ui, null, (String[])new String[0]);
        this.getModel().setEditing(true);
        SwingValidatorUtil.setValidatorBean(this.ui, editBean, (String[])new String[0]);
        if (binding.length > 0) {
            UIHelper.processDataBinding(this.ui, (String[])binding);
        }
        UIHelper.processDataBinding(this.ui, (String[])new String[]{"reset.enabled", "save.enabled"});
    }

    public void stopEditUI() {
        ObserveServiceHelper.getValidationContext().cleanCache();
        ContentUIModel<E> model = this.getModel();
        model.setEditing(false);
        model.setValid(true);
        model.setModified(false);
        this.ui.removeContextValue(model.getBeanType(), "edit");
        SwingValidatorUtil.setValidatorBean(this.ui, null, (String[])new String[0]);
    }

    public void resetEditUI() {
        this.stopEditUI();
        ContentUIHandler.removeAllMessages(this.ui);
        try {
            this.openUI();
        }
        catch (Exception ex) {
            ErrorDialogUI.showError((Exception)ex);
            if (log.isErrorEnabled()) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
            this.stopEditUI();
        }
    }

    public void restartEditUI() {
        ContentUIModel<E> model = this.getModel();
        if (!model.isEditable()) {
            return;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(this.prefix + "Will restart edit " + this.getUi().getClass().getName()));
        }
        ObserveTreeHelper treeHelper = ContentUIHandler.getTreeHelper(this.ui);
        ContentUIHandler.removeAllMessages(this.ui);
        treeHelper.reloadSelectedNode(false, true);
        model.setMode(ContentMode.UPDATE);
        this.ui.startEdit(null);
        this.updateActions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void saveUI(boolean refresh) {
        boolean ok = false;
        try {
            ok = this.doSave(this.getBean(), this.getDataService(), this.getDataSource(), this.getLoadBinder());
        }
        catch (Exception e) {
            ErrorDialogUI.showError((Exception)e);
            if (log.isErrorEnabled()) {
                log.error((Object)e);
            }
        }
        finally {
            if (ok) {
                this.afterSave(refresh);
            }
        }
    }

    protected boolean doSave(E bean, DataService dataService, DataSource dataSource, TopiaEntityBinder<E> binder) throws Exception {
        return false;
    }

    protected void afterSave(boolean refresh) {
        SwingValidatorUtil.setValidatorChanged(this.ui, (boolean)false, (String[])new String[0]);
    }

    public final boolean closeUI() throws Exception {
        boolean b = ContentUIHandler.checkEdit(this.ui);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Can close " + this.ui.getClass() + " : " + b));
        }
        if (b) {
            this.closeSafeUI();
        }
        return b;
    }

    protected void closeSafeUI() {
        ObserveTreeHelper treehelper;
        ObserveNode node;
        ObserveNode parentNode;
        ContentUIHandler.removeAllMessages(this.ui);
        ContentUIModel<E> model = this.getModel();
        boolean create = model.isCreatingMode();
        if (create && model.isEditable() && (parentNode = (ObserveNode)(node = (ObserveNode)(treehelper = ContentUIHandler.getTreeHelper(this.ui)).getSelectedNode()).getParent()) != null) {
            treehelper.removeNode((NavNode)node);
            treehelper.selectNode((NavNode)parentNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deleteUI() {
        boolean ok = false;
        this.ui.stopEdit();
        ContentUIHandler.removeAllMessages(this.ui);
        try {
            ok = this.doDelete(this.getBean(), this.getDataService(), this.getDataSource(), this.getDeleteExecutor());
        }
        catch (Exception e) {
            ErrorDialogUI.showError((Exception)e);
            if (log.isErrorEnabled()) {
                log.error((Object)e);
            }
        }
        finally {
            if (ok) {
                this.afterDelete();
            }
        }
    }

    protected boolean doDelete(E bean, DataService dataService, DataSource dataSource, TopiaExecutor2<? extends TopiaEntity, E> deletor) throws Exception {
        return false;
    }

    protected boolean askToDelete(E bean) {
        boolean accept = UIHelper.confirmForEntityDelete(this.ui, this.getBeanType(), bean);
        return !accept;
    }

    protected void afterDelete() {
        this.ui.stopEdit();
        ContentUIHandler.removeAllMessages(this.ui);
        if (!(this.getBean() instanceof ReferenceEntity)) {
            ObserveTreeHelper treeHelper = ContentUIHandler.getTreeHelper(this.ui);
            ObserveNode node = (ObserveNode)treeHelper.getSelectedNode();
            ObserveNode parentNode = (ObserveNode)treeHelper.removeNode((NavNode)node);
            treeHelper.selectNode((NavNode)parentNode);
        }
    }

    public void gotoChild(TopiaEntity entity) {
        if (entity == null) {
            return;
        }
        ObserveTreeHelper treeHelper = ContentUIHandler.getTreeHelper(this.ui);
        ObserveNode parentNode = (ObserveNode)treeHelper.getSelectedNode();
        String id = entity.getTopiaId();
        ObserveNode node = (ObserveNode)treeHelper.findNode((NavNode)parentNode, new String[]{id});
        if (log.isInfoEnabled()) {
            log.info((Object)("will go to node " + (Object)((Object)node) + " for " + id));
        }
        treeHelper.selectNode((NavNode)node);
    }

    public void addChild(Class<?> type) {
        ObserveTreeHelper treeHelper = ContentUIHandler.getTreeHelper(this.ui);
        ObserveNode parentNode = (ObserveNode)treeHelper.getSelectedNode();
        treeHelper.addUnsavedNode(parentNode, type);
    }

    public <E> List<E> updateList(BeanListHeader<E> list, List<E> data, String message) {
        if (data != null && !data.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(list.getName() + " - " + data.size()));
            }
            MultiJXPathDecorator decorator = list.getHandler().getDecorator();
            DecoratorUtil.sort((JXPathDecorator)((JXPathDecorator)decorator), data, (int)0);
            return data;
        }
        ArrayList result = new ArrayList();
        return result;
    }

    public void openLink(String url) {
        block2: {
            try {
                UIHelper.openLink((String)url);
            }
            catch (Exception e) {
                ErrorDialogUI.showError((Exception)e);
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)e);
            }
        }
    }

    protected E onCreate(TopiaContext tx, Object parentBean, E editBean) throws TopiaException {
        return editBean;
    }

    protected E onUpdate(TopiaContext tx, Object parentBean, E beanToSave) throws TopiaException {
        return beanToSave;
    }

    protected void onDelete(TopiaContext tx, Object parentBean, E beanToDelete) throws TopiaException {
    }

    protected void addInfoMessage(String message) {
        ContentUIHandler.addMessage(this.ui, NuitonValidatorScope.INFO, this.getEntityLabel(this.getModel().getBeanType()), I18n.t((String)message, (Object[])new Object[0]));
    }

    protected String getEntityLabel(Class<?> klass) {
        String result = DecoratorService.getEntityLabel(klass);
        return result;
    }

    protected void prepareValidationContext() {
        ObserveServiceHelper.get().getValidationContext().cleanCache();
    }

    protected final TopiaEntityBinder<E> getLoadBinder() {
        return this.getModel().getLoadBinder();
    }

    protected final TopiaExecutor<E> getLoadExecutor() {
        return this.loadExecutor;
    }

    protected final TopiaExecutor2<? extends TopiaEntity, E> getPreCreateExecutor() {
        return this.preCreateExecutor;
    }

    protected final TopiaExecutor2<? extends TopiaEntity, E> getCreateExecutor() {
        return this.createExecutor;
    }

    protected final TopiaExecutor2<? extends TopiaEntity, E> getUpdateExecutor() {
        return this.updateExecutor;
    }

    protected final TopiaExecutor2<? extends TopiaEntity, E> getDeleteExecutor() {
        return this.deleteExecutor;
    }

    protected final ContentMode computeContentMode() {
        ContentMode mode;
        if (!this.getModel().isCanWrite()) {
            if (ReferenceEntity.class.isAssignableFrom(this.getBeanType())) {
                this.addInfoMessage(I18n.t((String)"observe.message.referentiel.no.editable", (Object[])new Object[0]));
            } else {
                this.addInfoMessage(I18n.t((String)"observe.message.can.not.write.data", (Object[])new Object[0]));
            }
            mode = ContentMode.READ;
        } else {
            mode = this.getContentMode(this.getDataContext());
        }
        return mode;
    }

    protected final String getValidatorContextName(ContentMode mode) {
        String contextName = mode == ContentMode.CREATE ? "n1-create" : "n1-update";
        return contextName;
    }

    protected final DataService getDataService() {
        return ObserveContext.get().getDataService();
    }

    protected void updateActions() {
        this.updateToolbarActions();
        ActionMap actionMap = ObserveContext.get().getActionMap();
        for (String name : this.ui.get$objectMap().keySet()) {
            AbstractButton button;
            String actionId;
            Object o = this.ui.getObjectById(name);
            if (!(o instanceof AbstractButton) || (actionId = (String)(button = (AbstractButton)o).getClientProperty("observeAction")) == null) continue;
            AbstractUIAction action = (AbstractUIAction)actionMap.get(actionId);
            if (log.isDebugEnabled()) {
                log.debug((Object)("update common action " + actionId));
            }
            action.updateAction(this.ui, button);
        }
    }

    protected void updateToolbarActions() {
        Component[] components;
        ObserveContentUI<E> ui = this.getUi();
        JToolBar toolBar = ui.getTitleRightToolBar();
        for (Component component : components = toolBar.getComponents()) {
            JComponent jcompo;
            if (component instanceof JComponent && (jcompo = (JComponent)component).getClientProperty("original") != null) continue;
            toolBar.remove(component);
        }
    }

    protected Icon updateModeIcon(ContentMode mode) {
        Icon icon = null;
        if (mode != null) {
            icon = (Icon)((JComponent)((Object)this.ui)).getClientProperty(mode.name() + "Icon");
        }
        return icon;
    }

    protected String updateModeTip(ContentMode mode) {
        String tip = null;
        if (mode != null) {
            tip = (String)((JComponent)((Object)this.ui)).getClientProperty(mode.name() + "Tip");
        }
        return tip;
    }

    protected void setContentMode(ContentMode newMode) {
        this.getModel().setMode(null);
        this.getModel().setMode(newMode);
    }

    public String updateTitle(String title) {
        if (ContentReferenceUIHandler.class.isAssignableFrom(this.getClass())) {
            return DecoratorService.getEntityLabel(this.getBeanType());
        }
        return title;
    }

    protected void resetQuadrant(CoordinatesEditor editor) {
        editor.setQuadrant(null);
        JAXXButtonGroup quadrantBG = editor.getQuadrantBG();
        quadrantBG.setSelectedValue(null);
        quadrantBG.setSelectedButton(null);
        quadrantBG.remove((AbstractButton)editor.getQuadrant1());
        quadrantBG.remove((AbstractButton)editor.getQuadrant2());
        quadrantBG.remove((AbstractButton)editor.getQuadrant3());
        quadrantBG.remove((AbstractButton)editor.getQuadrant4());
        editor.getQuadrant1().setSelected(false);
        editor.getQuadrant2().setSelected(false);
        editor.getQuadrant3().setSelected(false);
        editor.getQuadrant4().setSelected(false);
        quadrantBG.add((AbstractButton)editor.getQuadrant1());
        quadrantBG.add((AbstractButton)editor.getQuadrant2());
        quadrantBG.add((AbstractButton)editor.getQuadrant3());
        quadrantBG.add((AbstractButton)editor.getQuadrant4());
    }
}

