/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.util.tripMap;

import fr.ird.observe.DataService;
import fr.ird.observe.ObserveConfig;
import fr.ird.observe.ObserveContext;
import fr.ird.observe.ObserveTechnicalException;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.entities.Entities;
import fr.ird.observe.tripMap.TripMapPoint;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.util.tripMap.ObserveMapPane;
import fr.ird.observe.ui.util.tripMap.TripMapContentBuilder;
import fr.ird.observe.ui.util.tripMap.TripMapUI;
import java.awt.CardLayout;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.swing.event.MapPaneEvent;
import org.geotools.swing.event.MapPaneListener;
import org.nuiton.i18n.I18n;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;

public class TripMapUIHandler {
    public static final double ZOOM_STEP_RATIO = 0.1;
    private static final Log log = LogFactory.getLog(TripMapUIHandler.class);
    protected TripMapUI view;
    private ObserveConfig config;
    protected ReferencedEnvelope tripArea;
    protected boolean rendererRunning;
    protected double zoomRatio = 1.0;
    protected Point zoomCenter;

    public static TripMapUIHandler newHandler(TripMapUI view) {
        return new TripMapUIHandler(view);
    }

    public TripMapUIHandler(TripMapUI view) {
        this.view = view;
    }

    public void initUI() {
        ObserveMapPane mapPane = this.getObserveMapPane();
        MouseMapListener mouseMapListener = new MouseMapListener();
        mapPane.addMouseWheelListener(mouseMapListener);
        mapPane.addMouseMotionListener(mouseMapListener);
        mapPane.addMouseListener(mouseMapListener);
        mapPane.addMapPaneListener(new TripMapListener());
        mapPane.setComponentPopupMenu(this.view.getMapPopupMenu());
        this.rendererRunning = false;
    }

    public void setConfig(ObserveConfig config) {
        this.config = config;
        ObserveMapPane mapPane = this.getObserveMapPane();
        mapPane.setBackground(config.getMapBackgroundColor());
    }

    protected ObserveMapPane getObserveMapPane() {
        return this.view.getObserveMapPane();
    }

    public void doOpenMap(DataSource dataSource, DataService dataService, String tripId) {
        try {
            ((CardLayout)this.view.getLayout()).first(this.view);
            ObserveContext.get().getObserveMainUI().setBusy(true);
            ObserveMapPane mapPane = this.getObserveMapPane();
            if (mapPane.getMapContent() != null) {
                mapPane.getMapContent().dispose();
            }
            List tripMapPoints = dataService.loadTripMapActivityPoints(dataSource, tripId);
            TripMapContentBuilder mapContentBuilder = new TripMapContentBuilder();
            mapContentBuilder.setStyledLayerDescriptor(this.config.getMapStyleFile());
            for (File layerFile : this.config.getMapLayerFiles()) {
                mapContentBuilder.addLayer(layerFile);
            }
            if (Entities.isSeineId((String)tripId)) {
                mapContentBuilder.addTripLine(tripMapPoints);
            } else if (Entities.isLonglineId((String)tripId)) {
                mapContentBuilder.addLonglineFishingZone(tripMapPoints);
                mapContentBuilder.addLonglineLine(tripMapPoints);
            }
            mapContentBuilder.addPoints(tripMapPoints);
            this.tripArea = new ReferencedEnvelope();
            for (TripMapPoint point : tripMapPoints) {
                this.tripArea.expandToInclude((DirectPosition)new DirectPosition2D((double)point.getLongitude(), (double)point.getLatitude()));
            }
            this.tripArea.expandBy(1.1);
            mapPane.setMapContent(mapContentBuilder.getMapContent());
            mapPane.setLegendItems(mapContentBuilder.getLegendItems());
        }
        catch (Exception e) {
            throw new ObserveTechnicalException("Unable to load trip map activity points", (Throwable)e);
        }
        finally {
            ObserveContext.get().getObserveMainUI().setBusy(false);
        }
    }

    public void doCloseMap() {
        ((CardLayout)this.view.getLayout()).first(this.view);
    }

    public void zoomIt() {
        ObserveMapPane mapPane = this.getObserveMapPane();
        mapPane.setDisplayArea((Envelope)this.tripArea);
    }

    public void exportPng() {
        File file = UIHelper.chooseFile(this.view, I18n.t((String)"observe.map.export.chooseFile.title", (Object[])new Object[0]), I18n.t((String)"observe.map.export.chooseFile.ok", (Object[])new Object[0]), null, "^.+\\.png|.+\\.PNG$", I18n.t((String)"observe.map.export.chooseFile.png", (Object[])new Object[0]));
        boolean write = true;
        if (file.exists()) {
            boolean bl = write = UIHelper.askUser(this.view, I18n.t((String)"observe.map.export.overwrite.title", (Object[])new Object[0]), I18n.t((String)"observe.map.export.overwrite", (Object[])new Object[0]), 2, new Object[]{I18n.t((String)"observe.map.export.overwrite.ok", (Object[])new Object[0]), I18n.t((String)"observe.map.export.overwrite.cancel", (Object[])new Object[0])}, 1) == 0;
        }
        if (write) {
            BufferedImage im = new BufferedImage(this.view.getWidth(), this.view.getHeight(), 2);
            this.view.paint(im.getGraphics());
            try {
                ImageIO.write((RenderedImage)im, "PNG", file);
            }
            catch (IOException e) {
                throw new ObserveTechnicalException("unable to export map ", (Throwable)e);
            }
            UIHelper.displayInfo(I18n.t((String)"observe.map.export.success", (Object[])new Object[]{file}));
        }
    }

    protected void zoomApply() {
        if (this.zoomRatio != 1.0 && !this.rendererRunning) {
            ObserveMapPane mapPane = this.getObserveMapPane();
            ReferencedEnvelope displayArea = mapPane.getDisplayArea();
            double deltaWidth = displayArea.getWidth() * (this.zoomRatio - 1.0);
            double deltaHeight = displayArea.getHeight() * (this.zoomRatio - 1.0);
            double ratioLeft = this.zoomCenter.getX() * 1.0 / (double)mapPane.getWidth();
            double ratioTop = 1.0 - this.zoomCenter.getY() * 1.0 / (double)mapPane.getHeight();
            double deltaLeft = deltaWidth * ratioLeft;
            double deltaRight = deltaLeft - deltaWidth;
            double deltaTop = deltaHeight * ratioTop;
            double deltaBottom = deltaTop - deltaHeight;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Map mouse zoom (zoom ratio : %s, deltaLeft : %s, deltaRight : %s, deltaTop : %s, deltaBottom : %s)", this.zoomRatio, deltaLeft, deltaRight, deltaRight, deltaBottom));
            }
            ReferencedEnvelope newDisplayArea = new ReferencedEnvelope(displayArea.getMinX() + deltaLeft, displayArea.getMaxX() + deltaRight, displayArea.getMinY() + deltaTop, displayArea.getMaxY() + deltaBottom, displayArea.getCoordinateReferenceSystem());
            mapPane.setDisplayArea((Envelope)newDisplayArea);
            this.zoomRatio = 1.0;
        }
    }

    protected class TripMapListener
    implements MapPaneListener {
        protected boolean firstRendering;

        protected TripMapListener() {
        }

        public void onNewMapContent(MapPaneEvent ev) {
            this.firstRendering = true;
        }

        public void onDisplayAreaChanged(MapPaneEvent ev) {
        }

        public void onRenderingStarted(MapPaneEvent ev) {
            TripMapUIHandler.this.rendererRunning = true;
        }

        public void onRenderingStopped(MapPaneEvent ev) {
            TripMapUIHandler.this.rendererRunning = false;
            if (this.firstRendering) {
                TripMapUIHandler.this.zoomIt();
                ((CardLayout)TripMapUIHandler.this.view.getLayout()).last(TripMapUIHandler.this.view);
                this.firstRendering = false;
            } else {
                TripMapUIHandler.this.zoomApply();
            }
        }
    }

    private class MouseMapListener
    implements MouseWheelListener,
    MouseListener,
    MouseMotionListener {
        protected Point2D startPointInWorld;
        protected AffineTransform startScreenToWorldTransform;
        protected ReferencedEnvelope startDisplayArea;

        private MouseMapListener() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            int notches = e.getWheelRotation();
            TripMapUIHandler.this.zoomRatio *= 1.0 + 0.1 * (double)notches * -1.0;
            TripMapUIHandler.this.zoomCenter = e.getPoint();
            TripMapUIHandler.this.zoomApply();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 1) {
                this.startMove(e.getPoint());
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.getButton() == 1) {
                this.endMove(e.getPoint());
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        protected void startMove(Point2D startPointInScreen) {
            ObserveMapPane mapPane = TripMapUIHandler.this.getObserveMapPane();
            this.startDisplayArea = mapPane.getDisplayArea();
            this.startScreenToWorldTransform = mapPane.getScreenToWorldTransform();
            this.startPointInWorld = new Point2D.Double();
            this.startScreenToWorldTransform.transform(startPointInScreen, this.startPointInWorld);
        }

        protected void endMove(Point2D endPointInScreen) {
            Point2D.Double endPointInWorld = new Point2D.Double();
            this.startScreenToWorldTransform.transform(endPointInScreen, endPointInWorld);
            double transX = this.startPointInWorld.getX() - ((Point2D)endPointInWorld).getX();
            double transY = this.startPointInWorld.getY() - ((Point2D)endPointInWorld).getY();
            ReferencedEnvelope endDisplayArea = new ReferencedEnvelope(this.startDisplayArea);
            endDisplayArea.translate(transX, transY);
            ObserveMapPane mapPane = TripMapUIHandler.this.getObserveMapPane();
            mapPane.setDisplayArea((Envelope)endDisplayArea);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Translate (x : %s, y : %s)", transX, transY));
            }
        }
    }
}

