/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.impl.longline;

import fr.ird.observe.entities.longline.Branchline;
import fr.ird.observe.entities.longline.BranchlineImpl;
import fr.ird.observe.ui.content.impl.longline.LonglineCompositionTableModelSupport;
import fr.ird.observe.ui.content.impl.longline.LonglineDetailCompositionUIModel;
import java.util.Date;

public class BranchlinesTableModel
extends LonglineCompositionTableModelSupport<Branchline> {
    private static final long serialVersionUID = 1L;
    protected Date defaultDate;
    private boolean useTimer;

    public BranchlinesTableModel(LonglineDetailCompositionUIModel model) {
        super(model);
    }

    public void setDefaultDate(Date defaultDate) {
        this.defaultDate = defaultDate;
    }

    @Override
    protected Branchline createNewRow() {
        BranchlineImpl branchline = new BranchlineImpl();
        branchline.setTimerTimeOnBoard(this.defaultDate);
        branchline.setTimer(Boolean.valueOf(this.useTimer));
        return branchline;
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        boolean result;
        switch (columnIndex) {
            case 0: {
                result = false;
                break;
            }
            case 1: {
                result = !this.isGenerateHaulingIds();
                break;
            }
            case 2: {
                result = true;
                break;
            }
            case 3: {
                result = true;
                break;
            }
            default: {
                throw new IllegalStateException("Can't come here");
            }
        }
        return result;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Number result;
        Branchline row = (Branchline)this.data.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                result = row.getSettingIdentifier();
                break;
            }
            case 1: {
                result = row.getHaulingIdentifier();
                break;
            }
            case 2: {
                result = row.getBranchlineLength();
                break;
            }
            case 3: {
                result = row.getTracelineLength();
                break;
            }
            default: {
                throw new IllegalStateException("Can't come here");
            }
        }
        return result;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        Branchline row = (Branchline)this.data.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                row.setSettingIdentifier((Integer)aValue);
                break;
            }
            case 1: {
                row.setHaulingIdentifier((Integer)aValue);
                break;
            }
            case 2: {
                row.setBranchlineLength((Float)aValue);
                break;
            }
            case 3: {
                row.setTracelineLength((Float)aValue);
                break;
            }
            default: {
                throw new IllegalStateException("Can't come here");
            }
        }
        this.setModified(true);
    }

    public void setUseTimer(boolean useTimer) {
        this.useTimer = useTimer;
    }

    public boolean isUseTimer() {
        return this.useTimer;
    }
}

