/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.admin.save;

import fr.ird.observe.ObserveDAOHelper;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.entities.Entities;
import fr.ird.observe.entities.referentiel.Ocean;
import fr.ird.observe.entities.referentiel.Species;
import fr.ird.observe.entities.referentiel.SpeciesList;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.admin.AdminStep;
import fr.ird.observe.ui.admin.AdminTabUIHandler;
import fr.ird.observe.ui.admin.AdminUI;
import fr.ird.observe.ui.admin.save.SaveLocalModel;
import fr.ird.observe.ui.admin.save.SaveLocalUI;
import fr.ird.observe.ui.admin.synchronize.SynchronizeModel;
import fr.ird.observe.ui.admin.synchronize.SynchronizeUIHandler;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import jaxx.runtime.swing.wizard.ext.WizardState;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.jdbc.Work;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.DiffState;

public class SaveLocalUIHandler
extends AdminTabUIHandler {
    private static final Log log = LogFactory.getLog(SaveLocalUIHandler.class);
    private static final String UPDATE_VERSION_PATTERN = "UPDATE %1$s SET topiaversion = %2$d WHERE topiaid='%3$s';\n";
    protected DataSource source;

    public SaveLocalUIHandler(SaveLocalUI ui) {
        super(ui);
    }

    @Override
    public SaveLocalUI getUi() {
        return (SaveLocalUI)super.getUi();
    }

    public void initTabUI(AdminUI ui, SaveLocalUI tabUI) {
        super.initTabUI(ui, tabUI);
        if (log.isDebugEnabled()) {
            log.debug((Object)(" specialized for [" + (Object)((Object)tabUI.getStep()) + "] for main ui " + ui.getClass().getName() + "@" + System.identityHashCode(ui)));
        }
        String message = I18n.t((String)"observe.action.synchro.launch.operation", (Object[])new Object[]{I18n.t((String)tabUI.getStep().getOperationLabel(), (Object[])new Object[0])});
        tabUI.getStartAction().setText(message);
    }

    public void updateText() {
        String text = "";
        if (this.getUi().getStepModel().containsStepForsave(AdminStep.SYNCHRONIZE)) {
            text = I18n.t((String)"observe.synchro.message.need.save.for.synchro.operation", (Object[])new Object[0]);
            text = text + "\n\n";
        }
        if (this.getUi().getStepModel().containsStepForsave(AdminStep.VALIDATE)) {
            text = I18n.t((String)"observe.synchro.message.need.save.for.validation.operation", (Object[])new Object[0]);
            text = text + "\n\n";
        }
        this.getUi().needSaveText.setText(text);
    }

    public String updateText(boolean localSourceNeedSave) {
        return localSourceNeedSave ? I18n.t((String)"observe.message.synchro.local.modification", (Object[])new Object[0]) : I18n.t((String)"observe.message.synchro.no.local.modification", (Object[])new Object[0]);
    }

    public void skipOperation() {
        this.sendMessage(I18n.t((String)"observe.synchro.message.saveLocal.skip", (Object[])new Object[0]));
        this.getModel().setStepState(AdminStep.SAVE_LOCAL, WizardState.SUCCESSED);
        if (this.model.getNextStep() != null) {
            this.model.gotoNextStep();
        }
    }

    public void chooseBackupFile() {
        File f = UIHelper.chooseDirectory(this.getUi(), I18n.t((String)"observe.title.choose.db.dump.directory", (Object[])new Object[0]), I18n.t((String)"observe.action.choose.db.dump.directory", (Object[])new Object[0]), new File(this.getUi().directoryText.getText()));
        this.changeDirectory(f);
    }

    public void changeDirectory(File f) {
        this.getUi().getStepModel().setBackupFile(new File(f, this.getUi().filenameText.getText()));
    }

    public void changeFilename(String filename) {
        this.getUi().getStepModel().setBackupFile(new File(this.getUi().directoryText.getText(), filename));
    }

    public void doStartAction() {
        this.addAdminWorker(this.getUi().getStartAction().getToolTipText(), new Callable<WizardState>(){

            @Override
            public WizardState call() throws Exception {
                return SaveLocalUIHandler.this.doAction();
            }
        });
    }

    public WizardState doAction() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)this);
        }
        this.source = this.model.getSafeLocalSource(false);
        SaveLocalModel stepModel = this.model.getSaveLocalModel();
        if (!stepModel.isLocalSourceNeedSave()) {
            this.sendMessage("Aucune modification sur la base locale, op\u00e9ration non requise.");
            return WizardState.SUCCESSED;
        }
        this.openSource(this.source);
        if (stepModel.isDoBackup()) {
            this.sendMessage("Sauvegarde de la base locale vers " + stepModel.getBackupFile());
            File backupFile = stepModel.getBackupFile();
            this.source.storeDB(backupFile);
        }
        if (stepModel.containsStepForsave(AdminStep.SYNCHRONIZE)) {
            this.sendMessage("Sauvegarde du r\u00e9f\u00e9rentiel.");
            this.saveReferentiel();
        }
        this.sendMessage(I18n.t((String)"observe.message.synchro.operation.done", (Object[])new Object[]{new Date()}));
        return WizardState.SUCCESSED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveReferentiel() throws Exception {
        SynchronizeModel stepModel = this.getModel().getSynchronizeReferentielModel();
        DataSource referentielSource = stepModel.getTmpSource();
        if (referentielSource == null) {
            referentielSource = stepModel.getCentralSource();
        }
        DataSource targetSource = stepModel.getSource();
        DiffState.DiffStateMap diff = stepModel.getDiff();
        String txName = "saveReferentiel";
        TopiaContext targetTx = this.beginTransaction(targetSource, txName);
        try {
            TopiaContext sourceTx = this.beginTransaction(referentielSource, txName);
            try {
                Map<TopiaEntity, Long> versionsToUpdate;
                String message;
                List ids = (List)diff.get((Object)DiffState.NEW);
                if (CollectionUtils.isNotEmpty((Collection)ids)) {
                    for (String id : ids) {
                        TopiaEntity entity = sourceTx.findByTopiaId(id);
                        String message2 = I18n.t((String)"observe.synchro.add.object", (Object[])new Object[]{id});
                        this.sendMessage(message2);
                        sourceTx.replicateEntity(targetTx, entity);
                        this.commitTransaction(targetSource, targetTx, txName);
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("add [" + id + "] : " + targetTx.findByTopiaId(id)));
                    }
                }
                if (CollectionUtils.isNotEmpty((Collection)(ids = (List)diff.get((Object)DiffState.MODIFIED)))) {
                    for (String id : ids) {
                        this.copyEntity(stepModel, sourceTx, targetTx, id);
                    }
                }
                for (SynchronizeUIHandler.ObsoleteRefReplaceAction action : stepModel.getReplaceActions()) {
                    message = I18n.t((String)"observe.synchro.replaceObsolete.object", (Object[])new Object[]{action.getObsoleteId()});
                    this.sendMessage(message);
                    action.doAction(targetTx);
                }
                this.commitTransaction(targetSource, targetTx, txName);
                ids = (List)diff.get((Object)DiffState.REMOVED);
                if (CollectionUtils.isNotEmpty((Collection)ids)) {
                    for (String id : ids) {
                        message = I18n.t((String)"observe.synchro.remove.object", (Object[])new Object[]{id});
                        this.sendMessage(message);
                        TopiaEntity entity = targetTx.findByTopiaId(id);
                        this.getDAO(targetTx, entity).delete(entity);
                    }
                }
                if (MapUtils.isNotEmpty(versionsToUpdate = stepModel.getVersionsToUpdate())) {
                    this.patchTopiaVersions((TopiaContextImplementor)targetTx, versionsToUpdate);
                }
                this.commitTransaction(targetSource, targetTx, txName);
            }
            finally {
                try {
                    this.rollbackTransaction(referentielSource, sourceTx, txName);
                }
                finally {
                    this.closeTransaction(referentielSource, sourceTx, txName);
                }
            }
        }
        catch (Exception e) {
            this.rollbackTransaction(targetSource, targetTx, txName);
            throw e;
        }
        finally {
            this.closeTransaction(targetSource, targetTx, txName);
        }
    }

    protected <E extends TopiaEntity> void copyEntity(SynchronizeModel synchronizeModel, TopiaContext sourceTx, TopiaContext targetTx, String id) throws TopiaException {
        TopiaEntity source = sourceTx.findByTopiaId(id);
        long sourceVersion = source.getTopiaVersion();
        String message = I18n.t((String)"observe.synchro.update.object", (Object[])new Object[]{source.getTopiaId(), sourceVersion});
        this.sendMessage(message);
        TopiaDAO dao = ObserveDAOHelper.getDAO((TopiaContext)targetTx, (TopiaEntity)source);
        TopiaEntity target = dao.findByTopiaId(source.getTopiaId());
        long targetVersion = target.getTopiaVersion();
        this.copyEntity(targetTx, source, target);
        if (targetVersion < sourceVersion) {
            if (log.isDebugEnabled()) {
                message = "register [" + source.getTopiaId() + "] to update version " + sourceVersion + " to " + targetVersion;
                log.debug((Object)message);
            }
            synchronizeModel.getVersionsToUpdate().put(target, sourceVersion);
        }
        target.setTopiaVersion(source.getTopiaVersion() - 1L);
        dao.update(target);
    }

    protected <E extends TopiaEntity> void copyEntity(TopiaContext targetTx, E source, E target) throws TopiaException {
        this.getBinderService().simpleCopy(source, target, false);
        if (source instanceof Species) {
            this.getDataService().copyAssociation(Species.class, Ocean.class, "ocean", (TopiaEntity)((Species)source), (TopiaEntity)((Species)target), targetTx);
        } else if (source instanceof SpeciesList) {
            this.getDataService().copyAssociation(SpeciesList.class, Species.class, "species", (TopiaEntity)((SpeciesList)source), (TopiaEntity)((SpeciesList)target), targetTx);
        }
    }

    protected void patchTopiaVersions(TopiaContextImplementor sourceCtxt, Map<TopiaEntity, Long> versionsToUpdate) throws TopiaException {
        final StringBuilder buffer = new StringBuilder();
        for (Map.Entry<TopiaEntity, Long> entry : versionsToUpdate.entrySet()) {
            TopiaEntity entity = entry.getKey();
            String id = entity.getTopiaId();
            Long version = entry.getValue();
            String tableName = Entities.getTableName((TopiaEntity)entity);
            buffer.append(String.format(UPDATE_VERSION_PATTERN, tableName, version, id));
        }
        sourceCtxt.getHibernate().doWork(new Work(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(Connection connection) throws SQLException {
                String sql = buffer.toString();
                try (PreparedStatement sta = connection.prepareStatement(sql);){
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Will execute sql code :\n" + sql));
                    }
                    sta.executeUpdate();
                }
            }
        });
    }
}

